/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.tomcat;

import java.io.IOException;
import java.net.ServerSocket;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Tomcat;

public class TomcatKillSwitch
implements Runnable {
    public static final String TOMCAT_KILL_SWITCH_ACTIVE = "TomcatKillSwitch.active";
    private Tomcat tomcat;
    private int serverPort;

    public TomcatKillSwitch(Tomcat tomcat, int serverPort) {
        this.tomcat = tomcat;
        this.serverPort = serverPort;
    }

    public static boolean isActive() {
        return Boolean.getBoolean(TOMCAT_KILL_SWITCH_ACTIVE);
    }

    public void run() {
        System.setProperty(TOMCAT_KILL_SWITCH_ACTIVE, "true");
        int killListenerPort = this.serverPort + 1;
        ServerSocket serverSocket = TomcatKillSwitch.createKillSwitch(killListenerPort);
        if (serverSocket != null) {
            try {
                serverSocket.accept();
                try {
                    this.tomcat.stop();
                    this.tomcat.destroy();
                    System.setProperty(TOMCAT_KILL_SWITCH_ACTIVE, "false");
                    System.exit(0);
                }
                catch (LifecycleException e) {
                    System.err.println("Error stopping Tomcat: " + e.getMessage());
                    System.exit(1);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static ServerSocket createKillSwitch(int killListenerPort) {
        try {
            return new ServerSocket(killListenerPort);
        }
        catch (IOException e) {
            return null;
        }
    }
}

