/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.uaa.client;

import java.util.List;
import org.springframework.uaa.client.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface UaaDetectedProducts {
    public static final ProductInfo SPRING_UAA = new ProductInfo("Spring UAA", "org.springframework.uaa", "org.springframework.uaa.client", "org.springframework.uaa.client.UaaService");

    public ProductInfo getDetectedProductInfo(String var1, String var2);

    public List<ProductInfo> getDetectedProductInfos();

    public boolean shouldReportUsage(String var1, String var2);

    public static final class ProductInfo {
        private String artifactId;
        private String groupId;
        private String productName;
        private String typeName;

        public ProductInfo(String productName, String groupId, String artifactId, String typeName) {
            Assert.hasLength(productName, "Product name required");
            Assert.hasLength(productName, "Group ID required");
            Assert.hasLength(productName, "Artifact ID required");
            Assert.notNull(typeName, "Type name cannot be null (but may be empty)");
            this.productName = productName;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.typeName = typeName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProductInfo other = (ProductInfo)obj;
            if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                return false;
            }
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            if (this.productName == null ? other.productName != null : !this.productName.equals(other.productName)) {
                return false;
            }
            return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
        }

        public final String getArtifactId() {
            return this.artifactId;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final String getProductName() {
            return this.productName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            result = 31 * result + (this.productName == null ? 0 : this.productName.hashCode());
            result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
            return result;
        }
    }
}

