/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression;

import javax.el.ExpressionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.el.DefaultExpressionFactoryUtils;
import org.springframework.util.ClassUtils;
import org.springframework.webflow.expression.WebFlowOgnlExpressionParser;
import org.springframework.webflow.expression.el.WebFlowELExpressionParser;

public final class DefaultExpressionParserFactory {
    private static final Log logger;
    private static ExpressionParser INSTANCE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.expression.DefaultExpressionParserFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    private DefaultExpressionParserFactory() {
    }

    public static synchronized ExpressionParser getExpressionParser() {
        return DefaultExpressionParserFactory.getDefaultExpressionParser();
    }

    public static synchronized ExpressionParser getExpressionParser(ConversionService conversionService) {
        return DefaultExpressionParserFactory.createDefaultExpressionParser(conversionService);
    }

    private static synchronized ExpressionParser getDefaultExpressionParser() {
        if (INSTANCE == null) {
            INSTANCE = DefaultExpressionParserFactory.createDefaultExpressionParser(null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Initialized shared default Web Flow ExpressionParser " + INSTANCE));
            }
        }
        return INSTANCE;
    }

    private static ExpressionParser createDefaultExpressionParser(ConversionService conversionService) throws IllegalStateException {
        try {
            ExpressionFactory elFactory = DefaultExpressionFactoryUtils.createExpressionFactory();
            WebFlowELExpressionParser expressionParser = new WebFlowELExpressionParser(elFactory);
            if (conversionService != null) {
                expressionParser.setConversionService(conversionService);
            }
            return expressionParser;
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.springframework.webflow.expression.DefaultExpressionParserFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ClassUtils.forName((String)"ognl.Ognl", (ClassLoader)clazz.getClassLoader());
                WebFlowOgnlExpressionParser expressionParser = new WebFlowOgnlExpressionParser();
                if (conversionService != null) {
                    expressionParser.setConversionService(conversionService);
                }
                return expressionParser;
            }
            catch (ClassNotFoundException ex) {
                IllegalStateException ise = new IllegalStateException("Unable to create the default expression parser for Spring Web Flow: Neither a Unified EL implementation or OGNL could be found.");
                ise.initCause(ex);
                throw ise;
            }
            catch (NoClassDefFoundError ex) {
                IllegalStateException ise = new IllegalStateException("Unable to create the default expression parser for Spring Web Flow: Neither a Unified EL implementation or OGNL could be found.");
                ise.initCause(ex);
                throw ise;
            }
        }
    }
}

