/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model;

import java.beans.PropertyDescriptor;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.reflect.NameUtils;

public abstract class AbstractPersistentProperty
implements PersistentProperty {
    protected PersistentEntity owner;
    protected MappingContext context;
    protected String name;
    protected Class type;

    public AbstractPersistentProperty(PersistentEntity owner, MappingContext context, PropertyDescriptor descriptor) {
        this.owner = owner;
        this.context = context;
        this.name = descriptor.getName();
        this.type = descriptor.getPropertyType();
    }

    public AbstractPersistentProperty(PersistentEntity owner, MappingContext context, String name, Class type) {
        this.owner = owner;
        this.context = context;
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getCapitilizedName() {
        return NameUtils.capitalize(this.getName());
    }

    public Class getType() {
        return this.type;
    }

    public PersistentEntity getOwner() {
        return this.owner;
    }

    public String toString() {
        return this.getName() + ":" + this.getType().getName();
    }

    public boolean isNullable() {
        Object mappedForm = this.getMapping().getMappedForm();
        return mappedForm instanceof Property && ((Property)mappedForm).isNullable();
    }
}

