/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.processenvironment;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.internal.nativeintegration.EnvironmentModificationResult;
import org.gradle.internal.nativeintegration.NativeIntegrationException;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.nativeintegration.ReflectiveEnvironment;

public abstract class AbstractProcessEnvironment
implements ProcessEnvironment {
    private final ReflectiveEnvironment reflectiveEnvironment = new ReflectiveEnvironment();

    @Override
    public EnvironmentModificationResult maybeSetEnvironment(Map<String, String> source) {
        ArrayList keysToRemove = Lists.newArrayList((Iterable)Sets.difference(System.getenv().keySet(), source.keySet()));
        for (String string : keysToRemove) {
            this.removeEnvironmentVariable(string);
        }
        for (Map.Entry entry : source.entrySet()) {
            this.setEnvironmentVariable((String)entry.getKey(), (String)entry.getValue());
        }
        return EnvironmentModificationResult.SUCCESS;
    }

    @Override
    public void removeEnvironmentVariable(String name) throws NativeIntegrationException {
        this.removeNativeEnvironmentVariable(name);
        this.reflectiveEnvironment.unsetenv(name);
    }

    protected abstract void removeNativeEnvironmentVariable(String var1);

    @Override
    public EnvironmentModificationResult maybeRemoveEnvironmentVariable(String name) {
        this.removeEnvironmentVariable(name);
        return EnvironmentModificationResult.SUCCESS;
    }

    @Override
    public void setEnvironmentVariable(String name, String value) throws NativeIntegrationException {
        if (value == null) {
            this.removeEnvironmentVariable(name);
            return;
        }
        this.setNativeEnvironmentVariable(name, value);
        this.reflectiveEnvironment.setenv(name, value);
    }

    protected abstract void setNativeEnvironmentVariable(String var1, String var2);

    @Override
    public EnvironmentModificationResult maybeSetEnvironmentVariable(String name, String value) {
        this.setEnvironmentVariable(name, value);
        return EnvironmentModificationResult.SUCCESS;
    }

    @Override
    public void setProcessDir(File processDir) throws NativeIntegrationException {
        this.setNativeProcessDir(processDir);
        System.setProperty("user.dir", processDir.getAbsolutePath());
    }

    protected abstract void setNativeProcessDir(File var1);

    @Override
    public boolean maybeSetProcessDir(File processDir) {
        this.setProcessDir(processDir);
        return true;
    }

    @Override
    public Long maybeGetPid() {
        return this.getPid();
    }

    @Override
    public boolean maybeDetachProcess() {
        this.detachProcess();
        return true;
    }
}

