/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.VariantIdentityUniquenessVerifier;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.component.local.model.ConfigurationMetadataFactory;
import org.gradle.internal.component.local.model.DefaultLocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class LocalComponentGraphResolveStateFactory {
    private final AttributeDesugaring attributeDesugaring;
    private final ComponentIdGenerator idGenerator;
    private final LocalConfigurationMetadataBuilder metadataBuilder;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    public LocalComponentGraphResolveStateFactory(AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator, LocalConfigurationMetadataBuilder metadataBuilder, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.attributeDesugaring = attributeDesugaring;
        this.idGenerator = idGenerator;
        this.metadataBuilder = metadataBuilder;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    public LocalComponentGraphResolveState realizedStateFor(ComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionId, String status, AttributesSchemaInternal schema, List<? extends LocalConfigurationGraphResolveMetadata> configurations) {
        ConfigurationsListMetadataFactory configurationFactory = new ConfigurationsListMetadataFactory(configurations);
        return this.createLocalComponentState(componentIdentifier, moduleVersionId, status, schema, false, configurationFactory);
    }

    public LocalComponentGraphResolveState stateFor(ModelContainer<?> model, ComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionId, ConfigurationsProvider configurations, String status, AttributesSchemaInternal schema) {
        return this.lazyStateFor(model, componentIdentifier, configurations, moduleVersionId, status, schema, false);
    }

    public LocalComponentGraphResolveState adHocStateFor(ModelContainer<?> model, ComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionId, ConfigurationsProvider configurations, String status, AttributesSchemaInternal schema) {
        return this.lazyStateFor(model, componentIdentifier, configurations, moduleVersionId, status, schema, true);
    }

    private LocalComponentGraphResolveState lazyStateFor(ModelContainer<?> model, ComponentIdentifier componentIdentifier, ConfigurationsProvider configurations, ModuleVersionIdentifier moduleVersionId, String status, AttributesSchemaInternal schema, boolean adHoc) {
        ConfigurationsProviderMetadataFactory configurationFactory = new ConfigurationsProviderMetadataFactory(componentIdentifier, configurations, this.metadataBuilder, model, this.calculatedValueContainerFactory);
        return this.createLocalComponentState(componentIdentifier, moduleVersionId, status, schema, adHoc, configurationFactory);
    }

    private DefaultLocalComponentGraphResolveState createLocalComponentState(ComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionId, String status, AttributesSchemaInternal schema, boolean adHoc, ConfigurationMetadataFactory configurationFactory) {
        LocalComponentGraphResolveMetadata metadata = new LocalComponentGraphResolveMetadata(moduleVersionId, componentIdentifier, status, schema);
        return new DefaultLocalComponentGraphResolveState(this.idGenerator.nextComponentId(), metadata, this.attributeDesugaring, this.idGenerator, adHoc, configurationFactory, this.calculatedValueContainerFactory, null);
    }

    private static class ConfigurationsProviderMetadataFactory
    implements ConfigurationMetadataFactory {
        private final ComponentIdentifier componentId;
        private final ConfigurationsProvider configurationsProvider;
        private final LocalConfigurationMetadataBuilder metadataBuilder;
        private final ModelContainer<?> model;
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;
        private final LocalConfigurationMetadataBuilder.DependencyCache cache;

        public ConfigurationsProviderMetadataFactory(ComponentIdentifier componentId, ConfigurationsProvider configurationsProvider, LocalConfigurationMetadataBuilder metadataBuilder, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.componentId = componentId;
            this.configurationsProvider = configurationsProvider;
            this.metadataBuilder = metadataBuilder;
            this.model = model;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
            this.cache = new LocalConfigurationMetadataBuilder.DependencyCache();
        }

        @Override
        public void visitConsumableConfigurations(Consumer<LocalConfigurationGraphResolveMetadata> visitor) {
            this.model.applyToMutableState(p -> {
                VariantIdentityUniquenessVerifier.buildReport(this.configurationsProvider).assertNoConflicts();
                this.configurationsProvider.visitAll(configuration -> {
                    if (configuration.isCanBeConsumed()) {
                        visitor.accept(this.createConfigurationMetadata((ConfigurationInternal)configuration));
                    }
                });
            });
        }

        @Override
        public void invalidate() {
            this.cache.invalidate();
        }

        @Override
        @Nullable
        public LocalConfigurationGraphResolveMetadata getConfiguration(String name) {
            return (LocalConfigurationGraphResolveMetadata)this.model.fromMutableState(p -> {
                ConfigurationInternal configuration = this.configurationsProvider.findByName(name);
                if (configuration == null) {
                    return null;
                }
                return this.createConfigurationMetadata(configuration);
            });
        }

        @Override
        public Set<String> getConfigurationNames() {
            HashSet<String> names = new HashSet<String>();
            this.model.applyToMutableState(p -> this.configurationsProvider.visitAll(configuration -> names.add(configuration.getName())));
            return names;
        }

        private LocalConfigurationGraphResolveMetadata createConfigurationMetadata(ConfigurationInternal configuration) {
            return this.metadataBuilder.create(configuration, this.configurationsProvider, this.componentId, this.cache, this.model, this.calculatedValueContainerFactory);
        }
    }

    private static class ConfigurationsListMetadataFactory
    implements ConfigurationMetadataFactory {
        private final List<? extends LocalConfigurationGraphResolveMetadata> metadata;

        public ConfigurationsListMetadataFactory(List<? extends LocalConfigurationGraphResolveMetadata> metadata) {
            this.metadata = metadata;
        }

        @Override
        public void visitConsumableConfigurations(Consumer<LocalConfigurationGraphResolveMetadata> visitor) {
            for (LocalConfigurationGraphResolveMetadata localConfigurationGraphResolveMetadata : this.metadata) {
                visitor.accept(localConfigurationGraphResolveMetadata);
            }
        }

        @Override
        public void invalidate() {
        }

        @Override
        public LocalConfigurationGraphResolveMetadata getConfiguration(String name) {
            return this.metadata.stream().filter(configuration -> name.equals(configuration.getName())).findFirst().orElse(null);
        }

        @Override
        public Set<String> getConfigurationNames() {
            return this.metadata.stream().map(VariantGraphResolveMetadata::getName).collect(Collectors.toSet());
        }
    }
}

