/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform.utils;

import com.google.common.collect.Interner;
import java.io.EOFException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.initialization.transform.InstrumentationArtifactMetadata;
import org.gradle.api.internal.initialization.transform.InstrumentationDependencyAnalysis;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HierarchicalNameSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class InstrumentationAnalysisSerializer {
    private final StringInterner stringInterner;

    public InstrumentationAnalysisSerializer(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
    }

    public void writeDependencyAnalysis(File output, InstrumentationArtifactMetadata metadata, Map<String, Set<String>> dependencyAnalysis) {
        try (KryoBackedEncoder encoder = new KryoBackedEncoder(Files.newOutputStream(output.toPath(), new OpenOption[0]));){
            InstrumentationAnalysisSerializer.writeMetadata(metadata, encoder);
            HierarchicalNameSerializer nameSerializer = new HierarchicalNameSerializer((Interner)this.stringInterner);
            InstrumentationAnalysisSerializer.writeTypesMap(dependencyAnalysis, encoder, nameSerializer);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not serialize types map to a file: " + output, e);
        }
    }

    public void writeTypeHierarchyAnalysis(File output, Map<String, Set<String>> types) {
        try (KryoBackedEncoder encoder = new KryoBackedEncoder(Files.newOutputStream(output.toPath(), new OpenOption[0]));){
            HierarchicalNameSerializer nameSerializer = new HierarchicalNameSerializer((Interner)this.stringInterner);
            InstrumentationAnalysisSerializer.writeTypesMap(types, encoder, nameSerializer);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not serialize types map to a file: " + output, e);
        }
    }

    private static void writeMetadata(InstrumentationArtifactMetadata metadata, KryoBackedEncoder encoder) {
        encoder.writeString((CharSequence)metadata.getArtifactName());
        encoder.writeString((CharSequence)metadata.getArtifactHash());
    }

    private static void writeTypesMap(Map<String, Set<String>> typesMap, KryoBackedEncoder encoder, HierarchicalNameSerializer nameSerializer) throws Exception {
        MapSerializer serializer = new MapSerializer((Serializer)nameSerializer, (Serializer)new SetSerializer((Serializer)nameSerializer));
        serializer.write((Encoder)encoder, typesMap);
    }

    public InstrumentationDependencyAnalysis readDependencyAnalysis(File output) {
        InstrumentationDependencyAnalysis instrumentationDependencyAnalysis;
        KryoBackedDecoder decoder = new KryoBackedDecoder(Files.newInputStream(output.toPath(), new OpenOption[0]));
        try {
            HierarchicalNameSerializer nameSerializer = new HierarchicalNameSerializer((Interner)this.stringInterner);
            instrumentationDependencyAnalysis = new InstrumentationDependencyAnalysis(InstrumentationAnalysisSerializer.readMetadata(decoder), InstrumentationAnalysisSerializer.readTypesMap(decoder, nameSerializer));
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not serialize types map to a file: " + output, e);
            }
        }
        decoder.close();
        return instrumentationDependencyAnalysis;
    }

    public InstrumentationArtifactMetadata readMetadataOnly(File input) {
        InstrumentationArtifactMetadata instrumentationArtifactMetadata;
        KryoBackedDecoder decoder = new KryoBackedDecoder(Files.newInputStream(input.toPath(), new OpenOption[0]));
        try {
            instrumentationArtifactMetadata = InstrumentationAnalysisSerializer.readMetadata(decoder);
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not deserialize analysis from a file: " + input, e);
            }
        }
        decoder.close();
        return instrumentationArtifactMetadata;
    }

    public Map<String, Set<String>> readTypeHierarchyAnalysis(File input) {
        Map<String, Set<String>> map;
        KryoBackedDecoder decoder = new KryoBackedDecoder(Files.newInputStream(input.toPath(), new OpenOption[0]));
        try {
            HierarchicalNameSerializer nameSerializer = new HierarchicalNameSerializer((Interner)this.stringInterner);
            map = InstrumentationAnalysisSerializer.readTypesMap(decoder, nameSerializer);
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not deserialize analysis from a file: " + input, e);
            }
        }
        decoder.close();
        return map;
    }

    private static InstrumentationArtifactMetadata readMetadata(KryoBackedDecoder decoder) throws EOFException {
        return new InstrumentationArtifactMetadata(decoder.readString(), decoder.readString());
    }

    private static Map<String, Set<String>> readTypesMap(KryoBackedDecoder decoder, HierarchicalNameSerializer nameSerializer) throws Exception {
        MapSerializer serializer = new MapSerializer((Serializer)nameSerializer, (Serializer)new SetSerializer((Serializer)nameSerializer));
        return serializer.read((Decoder)decoder);
    }
}

