/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal.services;

import java.io.File;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.DefaultCacheCleanupStrategy;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CleanupActionDecorator;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.cache.scopes.BuildTreeScopedCacheBuilderFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.resource.local.ModificationTimeFileAccessTimeJournal;
import org.gradle.internal.time.TimestampSuppliers;
import org.gradle.util.internal.GFileUtils;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.git.GitVersionControlSpec;
import org.gradle.vcs.git.internal.GitVersionControlSystem;
import org.gradle.vcs.internal.VersionControlRepositoryConnection;
import org.gradle.vcs.internal.VersionControlRepositoryConnectionFactory;
import org.gradle.vcs.internal.VersionControlSystem;
import org.gradle.vcs.internal.VersionRef;

public class DefaultVersionControlRepositoryFactory
implements VersionControlRepositoryConnectionFactory,
Stoppable {
    private final PersistentCache vcsWorkingDirCache;

    public DefaultVersionControlRepositoryFactory(BuildTreeScopedCacheBuilderFactory cacheBuilderFactory, CleanupActionDecorator cleanupActionDecorator) {
        this.vcsWorkingDirCache = cacheBuilderFactory.createCrossVersionCacheBuilder("vcs-1").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).withDisplayName("VCS Checkout Cache").withCleanupStrategy(this.createCacheCleanupStrategy(cleanupActionDecorator)).open();
    }

    private CacheCleanupStrategy createCacheCleanupStrategy(CleanupActionDecorator cleanupActionDecorator) {
        return DefaultCacheCleanupStrategy.from((CleanupAction)cleanupActionDecorator.decorate((CleanupAction)new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(1), (FileAccessTimeJournal)new ModificationTimeFileAccessTimeJournal(), TimestampSuppliers.daysAgo((int)7))));
    }

    @Override
    public VersionControlRepositoryConnection create(VersionControlSpec spec) {
        if (!(spec instanceof GitVersionControlSpec)) {
            throw new IllegalArgumentException(String.format("Don't know how to create a VCS from spec %s.", spec));
        }
        GitVersionControlSystem vcs = new GitVersionControlSystem();
        return new LockingVersionControlRepository(spec, vcs, this.vcsWorkingDirCache);
    }

    public void stop() {
        this.vcsWorkingDirCache.close();
    }

    private static final class LockingVersionControlRepository
    implements VersionControlRepositoryConnection {
        private final VersionControlSpec spec;
        private final VersionControlSystem delegate;
        private final PersistentCache cacheAccess;

        private LockingVersionControlRepository(VersionControlSpec spec, VersionControlSystem delegate, PersistentCache cacheAccess) {
            this.spec = spec;
            this.delegate = delegate;
            this.cacheAccess = cacheAccess;
        }

        @Override
        public String getDisplayName() {
            return this.spec.getDisplayName();
        }

        @Override
        public String getUniqueId() {
            return this.spec.getUniqueId();
        }

        @Override
        public VersionRef getDefaultBranch() {
            try {
                return this.delegate.getDefaultBranch(this.spec);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not locate default branch for %s.", this.spec.getDisplayName()), (Throwable)e);
            }
        }

        @Override
        @Nullable
        public VersionRef getBranch(String branch) {
            try {
                return this.delegate.getBranch(this.spec, branch);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not locate branch '%s' for %s.", branch, this.spec.getDisplayName()), (Throwable)e);
            }
        }

        @Override
        public Set<VersionRef> getAvailableVersions() {
            try {
                return this.delegate.getAvailableVersions(this.spec);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not list available versions for %s.", this.spec.getDisplayName()), (Throwable)e);
            }
        }

        @Override
        public File populate(final VersionRef ref) {
            return (File)this.cacheAccess.useCache((Factory)new Factory<File>(){

                public File create() {
                    try {
                        String repoName = spec.getRepoName();
                        String prefix = repoName.length() <= 9 ? repoName : repoName.substring(0, 10);
                        String versionId = prefix + "_" + Hashing.hashString((CharSequence)(this.getUniqueId() + "-" + ref.getCanonicalId())).toCompactString();
                        File baseDir = new File(cacheAccess.getBaseDir(), versionId);
                        File workingDir = new File(baseDir, repoName);
                        GFileUtils.mkdirs((File)workingDir);
                        GFileUtils.touch((File)baseDir);
                        delegate.populate(workingDir, ref, spec);
                        return workingDir;
                    }
                    catch (Exception e) {
                        throw new GradleException(String.format("Could not populate working directory from %s.", spec.getDisplayName()), (Throwable)e);
                    }
                }
            });
        }
    }
}

