/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemBuilder;
import org.gradle.api.problems.ProblemBuilderSpec;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.internal.DefaultProblemBuilder;
import org.gradle.api.problems.internal.DefaultProblemProgressDetails;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scope.Global.class)
public class DefaultProblems
implements InternalProblems {
    private final BuildOperationProgressEventEmitter buildOperationProgressEventEmitter;
    private final Map<String, ProblemGroup> problemGroups = new LinkedHashMap<String, ProblemGroup>();

    public DefaultProblems(BuildOperationProgressEventEmitter buildOperationProgressEventEmitter) {
        this.buildOperationProgressEventEmitter = buildOperationProgressEventEmitter;
        this.addPredefinedGroup("generic");
        this.addPredefinedGroup("type_validation");
        this.addPredefinedGroup("deprecation");
        this.addPredefinedGroup("version_catalog");
    }

    private void addPredefinedGroup(String genericId) {
        this.problemGroups.put(genericId, new ProblemGroup(genericId));
    }

    @Override
    public DefaultProblemBuilder createProblemBuilder() {
        return new DefaultProblemBuilder(this);
    }

    @Override
    public RuntimeException throwing(ProblemBuilderSpec action) {
        DefaultProblemBuilder defaultProblemBuilder = this.createProblemBuilder();
        ProblemBuilder problemBuilder = action.apply(defaultProblemBuilder);
        throw this.throwError(defaultProblemBuilder.getException(), problemBuilder.build());
    }

    @Override
    public RuntimeException rethrowing(RuntimeException e, ProblemBuilderSpec action) {
        DefaultProblemBuilder defaultProblemBuilder = this.createProblemBuilder();
        ProblemBuilder problemBuilder = action.apply(defaultProblemBuilder);
        problemBuilder.withException(e);
        throw this.throwError(e, problemBuilder.build());
    }

    public RuntimeException throwError(RuntimeException exception, Problem problem) {
        this.reportAsProgressEvent(problem);
        throw exception;
    }

    @Override
    public void reportAsProgressEvent(Problem problem) {
        this.buildOperationProgressEventEmitter.emitNowIfCurrent((Object)new DefaultProblemProgressDetails(problem));
    }

    @Override
    public ProblemGroup getProblemGroup(String groupId) {
        return this.problemGroups.get(groupId);
    }
}

