/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.base.Optional;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.resolve.resolver.ArtifactSelector;

public class DefaultComponentGraphResolveState<T extends ComponentGraphResolveMetadata, S extends ComponentResolveMetadata>
extends AbstractComponentGraphResolveState<T, S> {
    private final ConcurrentMap<ConfigurationMetadata, DefaultVariantArtifactResolveState> variants = new ConcurrentHashMap<ConfigurationMetadata, DefaultVariantArtifactResolveState>();

    public DefaultComponentGraphResolveState(T graphMetadata, S artifactMetadata) {
        super(graphMetadata, artifactMetadata);
    }

    public static ComponentGraphResolveState of(ModuleComponentResolveMetadata metadata) {
        return new DefaultComponentGraphResolveState<ModuleComponentResolveMetadata, ModuleComponentResolveMetadata>(metadata, metadata);
    }

    @Override
    public ComponentArtifactResolveMetadata getResolveMetadata() {
        return new ExternalArtifactResolveMetadata((ComponentResolveMetadata)this.getArtifactMetadata());
    }

    @Override
    public VariantArtifactGraphResolveMetadata resolveArtifactsFor(VariantGraphResolveMetadata variant) {
        return (VariantArtifactGraphResolveMetadata)((Object)variant);
    }

    @Override
    public VariantArtifactResolveState prepareForArtifactResolution(VariantGraphResolveMetadata variant) {
        ConfigurationMetadata configurationMetadata = (ConfigurationMetadata)((Object)variant);
        return this.variants.computeIfAbsent(configurationMetadata, c -> new DefaultVariantArtifactResolveState((ComponentGraphResolveMetadata)this.getMetadata(), (ComponentResolveMetadata)this.getArtifactMetadata(), configurationMetadata));
    }

    private static class ExternalArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final ComponentResolveMetadata metadata;

        public ExternalArtifactResolveMetadata(ComponentResolveMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return this.metadata.getSources();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.metadata.getAttributes();
        }

        @Override
        public AttributesSchemaInternal getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }

        @Override
        public ComponentResolveMetadata getMetadata() {
            return this.metadata;
        }
    }

    private static class DefaultVariantArtifactResolveState
    implements VariantArtifactResolveState {
        private final ComponentResolveMetadata artifactMetadata;
        private final ConfigurationMetadata graphSelectedVariant;
        private final Set<? extends VariantResolveMetadata> fallbackVariants;
        private final Set<? extends VariantResolveMetadata> allVariants;

        public DefaultVariantArtifactResolveState(ComponentGraphResolveMetadata graphMetadata, ComponentResolveMetadata artifactMetadata, ConfigurationMetadata graphSelectedVariant) {
            this.artifactMetadata = artifactMetadata;
            this.graphSelectedVariant = graphSelectedVariant;
            this.fallbackVariants = graphSelectedVariant.getVariants();
            Optional<List<? extends VariantGraphResolveMetadata>> variantsForGraphTraversal = graphMetadata.getVariantsForGraphTraversal();
            this.allVariants = DefaultVariantArtifactResolveState.buildAllVariants(this.fallbackVariants, variantsForGraphTraversal);
        }

        @Override
        public ComponentArtifactMetadata resolveArtifact(IvyArtifactName artifact) {
            return this.graphSelectedVariant.artifact(artifact);
        }

        @Override
        public ArtifactSet resolveArtifacts(ArtifactSelector artifactSelector, ExcludeSpec exclusions, ImmutableAttributes overriddenAttributes) {
            return artifactSelector.resolveArtifacts(new ExternalArtifactResolveMetadata(this.artifactMetadata), () -> this.allVariants, this.fallbackVariants, exclusions, overriddenAttributes);
        }

        private static Set<? extends VariantResolveMetadata> buildAllVariants(Set<? extends VariantResolveMetadata> fallbackVariants, Optional<List<? extends VariantGraphResolveMetadata>> variantsForGraphTraversal) {
            Set<VariantResolveMetadata> allVariants = variantsForGraphTraversal.isPresent() ? ((List)variantsForGraphTraversal.get()).stream().map(ModuleConfigurationMetadata.class::cast).flatMap(variant -> variant.getVariants().stream()).collect(Collectors.toSet()) : fallbackVariants;
            return allVariants;
        }
    }
}

