/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.MappingsKt;
import org.jetbrains.kotlin.backend.common.lower.InlineClassLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InlineClassLowering;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "inlineClassDeclarationLowering", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "getInlineClassDeclarationLowering", "()Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "inlineClassUsageLowering", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "getInlineClassUsageLowering", "()Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "transformedFunction", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "createStaticBodilessMethod", "function", "getOrCreateStaticMethod", "isClassInlineLike", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "toInlineClassImplementationName", "Lorg/jetbrains/kotlin/name/Name;", "ir.backend.common"})
public final class InlineClassLowering {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final Mapping.Delegate<IrFunction, IrSimpleFunction> transformedFunction;
    @NotNull
    private final DeclarationTransformer inlineClassDeclarationLowering;
    @NotNull
    private final BodyLoweringPass inlineClassUsageLowering;

    public InlineClassLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.transformedFunction = this.context.getMapping().getInlineClassMemberToStatic();
        this.inlineClassDeclarationLowering = new DeclarationTransformer(this){
            final /* synthetic */ InlineClassLowering this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrDeclarationParent irDeclarationParent = declaration.getParent();
                IrClass irClass2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                if (irClass2 == null) {
                    return null;
                }
                IrClass irClass3 = irClass2;
                if (!InlineClassLowering.access$isClassInlineLike(this.this$0, irClass3)) {
                    return null;
                }
                IrDeclaration irDeclaration2 = declaration;
                return irDeclaration2 instanceof IrConstructor ? this.transformConstructor((IrConstructor)declaration) : (irDeclaration2 instanceof IrSimpleFunction ? this.transformMethodFlat((IrSimpleFunction)declaration) : null);
            }

            private final List<IrDeclaration> transformConstructor(IrConstructor irConstructor2) {
                if (irConstructor2.isPrimary()) {
                    return this.transformPrimaryConstructor(irConstructor2);
                }
                IrSimpleFunction result2 = InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, irConstructor2);
                this.transformConstructorBody(irConstructor2, result2);
                return CollectionsKt.listOf((Object)result2);
            }

            private final List<IrDeclaration> transformMethodFlat(IrSimpleFunction function2) {
                if (IrDeclarationsKt.isStaticMethodOfClass(function2) || !AdditionalIrUtilsKt.isReal(function2)) {
                    return null;
                }
                IrSimpleFunction staticMethod = InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function2);
                this.transformMethodBodyFlat(function2, staticMethod);
                function2.setBody(this.delegateToStaticMethod(function2, staticMethod));
                if (function2.getOverriddenSymbols().isEmpty()) {
                    return CollectionsKt.listOf((Object)staticMethod);
                }
                Object[] objectArray = new IrSimpleFunction[]{function2, staticMethod};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            /*
             * WARNING - void declaration
             */
            private final List<IrDeclaration> transformPrimaryConstructor(IrConstructor irConstructor2) {
                IrBlockBody irBlockBody;
                IrSimpleFunction irSimpleFunction;
                IrClass klass = IrUtilsKt.getParentAsClass(irConstructor2);
                IrSimpleType inlineClassType = IrUtilsKt.getDefaultType(klass);
                IrSimpleFunction it = irSimpleFunction = InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, irConstructor2);
                boolean bl = false;
                it.setReturnType(inlineClassType);
                IrSimpleFunction initFunction = irSimpleFunction;
                Ref.ObjectRef delegatingCtorCall = new Ref.ObjectRef();
                Ref.ObjectRef setMemberField = new Ref.ObjectRef();
                IrSimpleFunction irSimpleFunction2 = initFunction;
                IrBody irBody = irConstructor2.getBody();
                if (irBody != null) {
                    void body2;
                    IrBody irBody2 = irBody;
                    InlineClassLowering inlineClassLowering = this.this$0;
                    IrBody irBody3 = irBody2;
                    IrSimpleFunction irSimpleFunction3 = irSimpleFunction2;
                    boolean bl2 = false;
                    irBlockBody = inlineClassLowering.getContext().getIrFactory().createBlockBody(-1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)new Function1<IrBlockBody, Unit>(irConstructor2, inlineClassLowering, initFunction, (IrBody)body2, (Ref.ObjectRef<IrDelegatingConstructorCall>)delegatingCtorCall, klass, (Ref.ObjectRef<IrSetField>)setMemberField){
                        final /* synthetic */ IrConstructor $irConstructor;
                        final /* synthetic */ InlineClassLowering this$0;
                        final /* synthetic */ IrSimpleFunction $initFunction;
                        final /* synthetic */ IrBody $body;
                        final /* synthetic */ Ref.ObjectRef<IrDelegatingConstructorCall> $delegatingCtorCall;
                        final /* synthetic */ IrClass $klass;
                        final /* synthetic */ Ref.ObjectRef<IrSetField> $setMemberField;
                        {
                            this.$irConstructor = $irConstructor;
                            this.this$0 = $receiver;
                            this.$initFunction = $initFunction;
                            this.$body = $body;
                            this.$delegatingCtorCall = $delegatingCtorCall;
                            this.$klass = $klass;
                            this.$setMemberField = $setMemberField;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                            void p1;
                            DeepCopyTypeRemapper typeRemapper$iv$iv;
                            void $this$deepCopyWithSymbols$iv$iv;
                            void this_$iv$iv$iv;
                            void startOffset$iv$iv;
                            void $this$irBlockBody$iv$iv;
                            void irElement$iv;
                            void $this$irBlockBody$iv;
                            Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                            IrValueParameterSymbol origParameterSymbol = ((IrValueParameter)CollectionsKt.single(this.$irConstructor.getValueParameters())).getSymbol();
                            Collection collection = $this$createBlockBody.getStatements();
                            Object object = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)this.$initFunction.getSymbol(), 0, 0, 6, null);
                            IrElement irElement = this.$initFunction;
                            IrBody irBody = this.$body;
                            IrSimpleFunction irSimpleFunction = this.$initFunction;
                            Ref.ObjectRef<IrDelegatingConstructorCall> objectRef = this.$delegatingCtorCall;
                            IrConstructor irConstructor2 = this.$irConstructor;
                            IrClass irClass2 = this.$klass;
                            Ref.ObjectRef<IrSetField> objectRef2 = this.$setMemberField;
                            boolean $i$f$irBlockBody = false;
                            void var13_13 = $this$irBlockBody$iv;
                            int n = irElement$iv.getStartOffset();
                            int endOffset$iv$iv = irElement$iv.getEndOffset();
                            boolean $i$f$irBlockBody2 = false;
                            IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
                            boolean $i$f$blockBody = false;
                            void $this$invoke_u24lambda_u241 = this_$iv$iv$iv;
                            boolean bl = false;
                            void builder2 = $this$invoke_u24lambda_u241;
                            Intrinsics.checkNotNull((Object)irBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                            IrElement $this$deepCopyWithSymbols_u24default$iv = (IrBlockBody)irBody;
                            boolean $i$f$deepCopyWithSymbols = false;
                            IrElement irElement2 = $this$deepCopyWithSymbols_u24default$iv;
                            DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                            boolean $i$f$deepCopyWithSymbols2 = false;
                            IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
                            TypeRemapper typeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
                            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                            void var30_31 = $this$deepCopyWithSymbols$iv$iv;
                            boolean bl2 = false;
                            typeRemapper = typeRemapper;
                            SymbolRemapper p0 = deepCopySymbolRemapper;
                            IrElement irElement3 = PatchDeclarationParentsKt.patchDeclarationParents(var30_31.transform(new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1), null), irSimpleFunction);
                            if (irElement3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                            }
                            Iterable $this$forEach$iv = ((IrBlockBody)((IrElement)((IrBlockBody)irElement3))).getStatements();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                IrStatement statement2 = (IrStatement)element$iv;
                                boolean bl3 = false;
                                $this$invoke_u24lambda_u241.unaryPlus(IrElementsKt.transformStatement(statement2, new IrElementTransformerVoid(objectRef, irConstructor2, (IrBlockBodyBuilder)builder2, irClass2, objectRef2, irSimpleFunction, origParameterSymbol){
                                    final /* synthetic */ Ref.ObjectRef<IrDelegatingConstructorCall> $delegatingCtorCall;
                                    final /* synthetic */ IrConstructor $irConstructor;
                                    final /* synthetic */ IrBlockBodyBuilder $builder;
                                    final /* synthetic */ IrClass $klass;
                                    final /* synthetic */ Ref.ObjectRef<IrSetField> $setMemberField;
                                    final /* synthetic */ IrSimpleFunction $initFunction;
                                    final /* synthetic */ IrValueParameterSymbol $origParameterSymbol;
                                    {
                                        this.$delegatingCtorCall = $delegatingCtorCall;
                                        this.$irConstructor = $irConstructor;
                                        this.$builder = $builder;
                                        this.$klass = $klass;
                                        this.$setMemberField = $setMemberField;
                                        this.$initFunction = $initFunction;
                                        this.$origParameterSymbol = $origParameterSymbol;
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    @NotNull
                                    public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                                        void this_$iv$iv;
                                        void p1;
                                        DeepCopyTypeRemapper typeRemapper$iv$iv;
                                        void $this$deepCopyWithSymbols$iv$iv;
                                        void $this$deepCopyWithSymbols_u24default$iv;
                                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                                        IrElement irElement = expression2;
                                        IrDeclarationParent initialParent$iv = this.$irConstructor;
                                        boolean $i$f$deepCopyWithSymbols = false;
                                        void var6_7 = $this$deepCopyWithSymbols_u24default$iv;
                                        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                                        boolean $i$f$deepCopyWithSymbols22 = false;
                                        IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
                                        TypeRemapper typeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
                                        DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                                        void var14_17 = $this$deepCopyWithSymbols$iv$iv;
                                        Ref.ObjectRef<IrDelegatingConstructorCall> objectRef = this.$delegatingCtorCall;
                                        boolean bl = false;
                                        typeRemapper = typeRemapper;
                                        SymbolRemapper p0 = deepCopySymbolRemapper;
                                        DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1);
                                        IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var14_17.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
                                        if (irElement2 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall");
                                        }
                                        objectRef.element = (IrDelegatingConstructorCall)irElement2;
                                        IrBuilderWithScope $this$irBlock_u24default$iv = this.$builder;
                                        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
                                        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
                                        IrStatementOrigin origin$iv = null;
                                        IrType resultType$iv = null;
                                        boolean $i$f$irBlock = false;
                                        IrBlockBuilder $i$f$deepCopyWithSymbols22 = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                                        boolean $i$f$block = false;
                                        void $this$visitDelegatingConstructorCall_u24lambda_u240 = this_$iv$iv;
                                        boolean bl2 = false;
                                        return this_$iv$iv.doBuild();
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    @NotNull
                                    public IrExpression visitSetField(@NotNull IrSetField expression2) {
                                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                                        boolean isMemberFieldSet = Intrinsics.areEqual((Object)((IrField)expression2.getSymbol().getOwner()).getParent(), (Object)this.$klass);
                                        if (isMemberFieldSet) {
                                            void p1;
                                            DeepCopyTypeRemapper typeRemapper$iv$iv;
                                            void $this$deepCopyWithSymbols$iv$iv;
                                            void $this$deepCopyWithSymbols_u24default$iv;
                                            IrElement irElement = expression2;
                                            IrDeclarationParent initialParent$iv = this.$irConstructor;
                                            boolean $i$f$deepCopyWithSymbols = false;
                                            void var6_6 = $this$deepCopyWithSymbols_u24default$iv;
                                            DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                                            boolean $i$f$deepCopyWithSymbols2 = false;
                                            IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
                                            TypeRemapper typeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
                                            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                                            void var14_12 = $this$deepCopyWithSymbols$iv$iv;
                                            Ref.ObjectRef<IrSetField> objectRef = this.$setMemberField;
                                            boolean bl = false;
                                            typeRemapper = typeRemapper;
                                            SymbolRemapper p0 = deepCopySymbolRemapper;
                                            DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1);
                                            IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var14_12.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
                                            if (irElement2 == null) {
                                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrSetField");
                                            }
                                            objectRef.element = (IrSetField)irElement2;
                                        }
                                        this.transformChildrenVoid(expression2);
                                        if (isMemberFieldSet) {
                                            return expression2.getValue();
                                        }
                                        return expression2;
                                    }

                                    @NotNull
                                    public IrExpression visitGetField(@NotNull IrGetField expression2) {
                                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                                        this.transformChildrenVoid(expression2);
                                        if (Intrinsics.areEqual((Object)((IrField)expression2.getSymbol().getOwner()).getParent(), (Object)this.$klass)) {
                                            return ExpressionHelpersKt.irGet(this.$builder, (IrValueDeclaration)CollectionsKt.single(this.$initFunction.getValueParameters()));
                                        }
                                        return expression2;
                                    }

                                    @NotNull
                                    public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                                        this.transformChildrenVoid(expression2);
                                        if (Intrinsics.areEqual((Object)expression2.getSymbol().getOwner().getParent(), (Object)this.$klass)) {
                                            return inlineClassDeclarationLowering.transformPrimaryConstructor.1.1.access$invoke$lambda$1$unboxedInlineClassValue(this.$builder, this.$initFunction, this.$klass);
                                        }
                                        if (Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)this.$origParameterSymbol)) {
                                            return ExpressionHelpersKt.irGet(this.$builder, (IrValueDeclaration)CollectionsKt.single(this.$initFunction.getValueParameters()));
                                        }
                                        return expression2;
                                    }

                                    @NotNull
                                    public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                                        this.transformChildrenVoid(expression2);
                                        if (Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)this.$origParameterSymbol)) {
                                            return ExpressionHelpersKt.irSet$default((IrBuilderWithScope)this.$builder, (IrValueDeclaration)CollectionsKt.single(this.$initFunction.getValueParameters()), expression2.getValue(), null, 4, null);
                                        }
                                        return expression2;
                                    }
                                }));
                            }
                            $this$invoke_u24lambda_u241.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$invoke_u24lambda_u241, inlineClassDeclarationLowering.transformPrimaryConstructor.1.1.invoke$lambda$1$unboxedInlineClassValue((IrBlockBodyBuilder)builder2, irSimpleFunction, irClass2)));
                            object = this_$iv$iv$iv.doBuild().getStatements();
                            CollectionsKt.addAll((Collection)collection, (Iterable)object);
                        }

                        private static final IrTypeOperatorCallImpl invoke$lambda$1$unboxedInlineClassValue(IrBlockBodyBuilder builder2, IrSimpleFunction initFunction, IrClass klass) {
                            return ExpressionHelpersKt.irReinterpretCast(builder2, ExpressionHelpersKt.irGet(builder2, (IrValueDeclaration)CollectionsKt.single(initFunction.getValueParameters())), IrUtilsKt.getDefaultType(klass));
                        }

                        public static final /* synthetic */ IrTypeOperatorCallImpl access$invoke$lambda$1$unboxedInlineClassValue(IrBlockBodyBuilder builder2, IrSimpleFunction initFunction, IrClass klass) {
                            return inlineClassDeclarationLowering.transformPrimaryConstructor.1.1.invoke$lambda$1$unboxedInlineClassValue(builder2, initFunction, klass);
                        }
                    }));
                    irSimpleFunction2 = irSimpleFunction3;
                } else {
                    irBlockBody = null;
                }
                irSimpleFunction2.setBody(irBlockBody);
                if (irConstructor2.getBody() != null) {
                    irConstructor2.setBody(this.this$0.getContext().getIrFactory().createBlockBody(-1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)new Function1<IrBlockBody, Unit>((Ref.ObjectRef<IrDelegatingConstructorCall>)delegatingCtorCall, (Ref.ObjectRef<IrSetField>)setMemberField){
                        final /* synthetic */ Ref.ObjectRef<IrDelegatingConstructorCall> $delegatingCtorCall;
                        final /* synthetic */ Ref.ObjectRef<IrSetField> $setMemberField;
                        {
                            this.$delegatingCtorCall = $delegatingCtorCall;
                            this.$setMemberField = $setMemberField;
                            super(1);
                        }

                        public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                            block1: {
                                IrDeclarationReference it;
                                Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                                IrDelegatingConstructorCall irDelegatingConstructorCall2 = (IrDelegatingConstructorCall)this.$delegatingCtorCall.element;
                                if (irDelegatingConstructorCall2 != null) {
                                    it = irDelegatingConstructorCall2;
                                    boolean bl = false;
                                    ((Collection)$this$createBlockBody.getStatements()).add(it);
                                }
                                IrSetField irSetField = (IrSetField)this.$setMemberField.element;
                                if (irSetField == null) break block1;
                                it = irSetField;
                                boolean bl = false;
                                ((Collection)$this$createBlockBody.getStatements()).add(it);
                            }
                        }
                    })));
                }
                Object[] objectArray = new IrFunction[]{irConstructor2, initFunction};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            /*
             * WARNING - void declaration
             */
            private final void transformConstructorBody(IrConstructor irConstructor2, IrSimpleFunction staticMethod) {
                IrBlockBody irBlockBody;
                if (irConstructor2.isPrimary()) {
                    return;
                }
                IrClass irClass2 = IrUtilsKt.getParentAsClass(irConstructor2);
                IrSimpleFunction irSimpleFunction = staticMethod;
                IrBody irBody = irConstructor2.getBody();
                if (irBody != null) {
                    void constructorBody;
                    IrBody irBody2 = irBody;
                    InlineClassLowering inlineClassLowering = this.this$0;
                    IrBody irBody3 = irBody2;
                    IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
                    boolean bl = false;
                    irBlockBody = inlineClassLowering.getContext().getIrFactory().createBlockBody(-1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)new Function1<IrBlockBody, Unit>(inlineClassLowering, staticMethod, (IrBody)constructorBody, irConstructor2, irClass2){
                        final /* synthetic */ InlineClassLowering this$0;
                        final /* synthetic */ IrSimpleFunction $staticMethod;
                        final /* synthetic */ IrBody $constructorBody;
                        final /* synthetic */ IrConstructor $irConstructor;
                        final /* synthetic */ IrClass $irClass;
                        {
                            this.this$0 = $receiver;
                            this.$staticMethod = $staticMethod;
                            this.$constructorBody = $constructorBody;
                            this.$irConstructor = $irConstructor;
                            this.$irClass = $irClass;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                            IrVariable irVariable2;
                            void $this$associateByTo$iv$iv;
                            void this_$iv$iv$iv;
                            void startOffset$iv$iv;
                            void $this$irBlockBody$iv$iv;
                            void irElement$iv;
                            void $this$irBlockBody$iv;
                            Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                            Collection collection = $this$createBlockBody.getStatements();
                            Object object = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)this.$staticMethod.getSymbol(), 0, 0, 6, null);
                            IrElement irElement = this.$staticMethod;
                            IrSimpleFunction irSimpleFunction = this.$staticMethod;
                            IrBody irBody = this.$constructorBody;
                            IrConstructor irConstructor2 = this.$irConstructor;
                            IrClass irClass2 = this.$irClass;
                            boolean $i$f$irBlockBody = false;
                            void var10_10 = $this$irBlockBody$iv;
                            int n = irElement$iv.getStartOffset();
                            int endOffset$iv$iv = irElement$iv.getEndOffset();
                            boolean $i$f$irBlockBody2 = false;
                            IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
                            boolean $i$f$blockBody = false;
                            void $this$invoke_u24lambda_u242 = this_$iv$iv$iv;
                            boolean bl = false;
                            Ref.ObjectRef thisVar = new Ref.ObjectRef();
                            Iterable $this$associateBy$iv = irSimpleFunction.getValueParameters();
                            boolean $i$f$associateBy = false;
                            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                            Iterable iterable = $this$associateBy$iv;
                            Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                            boolean $i$f$associateByTo = false;
                            for (T element$iv$iv : $this$associateByTo$iv$iv) {
                                void it;
                                IrValueParameter irValueParameter = (IrValueParameter)element$iv$iv;
                                Map map = destination$iv$iv;
                                boolean bl2 = false;
                                map.put(irConstructor2.getValueParameters().get(it.getIndex()).getSymbol(), element$iv$iv);
                            }
                            Map parameterMapping = destination$iv$iv;
                            Intrinsics.checkNotNull((Object)irBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                            Iterable $this$forEach$iv = ((IrBlockBody)irBody).getStatements();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                IrStatement statement2 = (IrStatement)element$iv;
                                boolean bl3 = false;
                                $this$invoke_u24lambda_u242.unaryPlus(IrElementsKt.transformStatement(statement2, new IrElementTransformerVoid(irClass2, (IrBlockBodyBuilder)$this$invoke_u24lambda_u242, (Ref.ObjectRef<IrVariable>)thisVar, irSimpleFunction, parameterMapping, irConstructor2){
                                    final /* synthetic */ IrClass $irClass;
                                    final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody;
                                    final /* synthetic */ Ref.ObjectRef<IrVariable> $thisVar;
                                    final /* synthetic */ IrSimpleFunction $staticMethod;
                                    final /* synthetic */ Map<IrValueParameterSymbol, IrValueParameter> $parameterMapping;
                                    final /* synthetic */ IrConstructor $irConstructor;
                                    {
                                        this.$irClass = $irClass;
                                        this.$this_irBlockBody = $receiver;
                                        this.$thisVar = $thisVar;
                                        this.$staticMethod = $staticMethod;
                                        this.$parameterMapping = $parameterMapping;
                                        this.$irConstructor = $irConstructor;
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    @NotNull
                                    public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                                        IrVariable irVariable2;
                                        void this_$iv$iv$iv;
                                        void startOffset$iv$iv;
                                        void $this$irBlock$iv$iv;
                                        void $this$irBlock_u24default$iv;
                                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                                        this.transformChildrenVoid(expression2);
                                        expression2.setType(IrUtilsKt.getDefaultType(this.$irClass));
                                        IrGeneratorWithScope irGeneratorWithScope = this.$this_irBlockBody;
                                        Ref.ObjectRef<IrVariable> objectRef = this.$thisVar;
                                        IrClass irClass2 = this.$irClass;
                                        IrSimpleFunction irSimpleFunction = this.$staticMethod;
                                        IrStatementOrigin origin$iv = null;
                                        IrType resultType$iv = ((IrExpression)expression2).getType();
                                        boolean $i$f$irBlock = false;
                                        void var9_9 = $this$irBlock_u24default$iv;
                                        int n = ((IrExpression)expression2).getStartOffset();
                                        int endOffset$iv$iv = ((IrExpression)expression2).getEndOffset();
                                        boolean $i$f$irBlock2 = false;
                                        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
                                        boolean $i$f$block = false;
                                        void $this$visitDelegatingConstructorCall_u24lambda_u240 = this_$iv$iv$iv;
                                        boolean bl = false;
                                        objectRef.element = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$visitDelegatingConstructorCall_u24lambda_u240, (IrExpression)expression2, null, false, null, (IrType)IrUtilsKt.getDefaultType(irClass2), 14, null);
                                        if (objectRef.element == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                                            irVariable2 = null;
                                        } else {
                                            irVariable2 = (IrVariable)objectRef.element;
                                        }
                                        irVariable2.setParent(irSimpleFunction);
                                        return this_$iv$iv$iv.doBuild();
                                    }

                                    @NotNull
                                    public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                                        this.transformChildrenVoid(expression2);
                                        IrValueParameter irValueParameter = this.$irClass.getThisReceiver();
                                        if (Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)(irValueParameter != null ? irValueParameter.getSymbol() : null))) {
                                            IrVariable irVariable2;
                                            IrBuilderWithScope irBuilderWithScope = this.$this_irBlockBody;
                                            if (this.$thisVar.element == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                                                irVariable2 = null;
                                            } else {
                                                irVariable2 = (IrVariable)this.$thisVar.element;
                                            }
                                            return ExpressionHelpersKt.irGet(irBuilderWithScope, irVariable2);
                                        }
                                        IrValueParameter irValueParameter2 = this.$parameterMapping.get(expression2.getSymbol());
                                        if (irValueParameter2 != null) {
                                            IrValueParameter irValueParameter3 = irValueParameter2;
                                            IrBlockBodyBuilder irBlockBodyBuilder = this.$this_irBlockBody;
                                            IrValueParameter it = irValueParameter3;
                                            boolean bl = false;
                                            return ExpressionHelpersKt.irGet(irBlockBodyBuilder, it);
                                        }
                                        return expression2;
                                    }

                                    @NotNull
                                    public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                                        this.transformChildrenVoid(expression2);
                                        IrValueParameter irValueParameter = this.$parameterMapping.get(expression2.getSymbol());
                                        if (irValueParameter != null) {
                                            IrValueParameter irValueParameter2 = irValueParameter;
                                            IrBlockBodyBuilder irBlockBodyBuilder = this.$this_irBlockBody;
                                            IrValueParameter it = irValueParameter2;
                                            boolean bl = false;
                                            return ExpressionHelpersKt.irSet$default((IrBuilderWithScope)irBlockBodyBuilder, it.getSymbol(), expression2.getValue(), null, 4, null);
                                        }
                                        return expression2;
                                    }

                                    @NotNull
                                    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration) {
                                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                                        IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                                        if (Intrinsics.areEqual((Object)declaration.getParent(), (Object)this.$irConstructor)) {
                                            declaration.setParent(this.$staticMethod);
                                        }
                                        return declaration;
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    @NotNull
                                    public IrExpression visitReturn(@NotNull IrReturn expression2) {
                                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                                        this.transformChildrenVoid(expression2);
                                        if (Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol(), (Object)this.$irConstructor.getSymbol())) {
                                            IrVariable irVariable2;
                                            void $this$visitReturn_u24lambda_u243;
                                            void this_$iv$iv;
                                            void endOffset$iv;
                                            void startOffset$iv;
                                            void $this$irBlock_u24default$iv;
                                            IrBuilderWithScope irBuilderWithScope = this.$this_irBlockBody;
                                            int n = expression2.getStartOffset();
                                            int n2 = expression2.getEndOffset();
                                            Ref.ObjectRef<IrVariable> objectRef = this.$thisVar;
                                            IrStatementOrigin origin$iv = null;
                                            IrType resultType$iv = null;
                                            boolean $i$f$irBlock = false;
                                            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                                            boolean $i$f$block = false;
                                            void var11_11 = this_$iv$iv;
                                            IrBuilderWithScope irBuilderWithScope2 = this.$this_irBlockBody;
                                            boolean bl = false;
                                            $this$visitReturn_u24lambda_u243.unaryPlus(expression2.getValue());
                                            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$visitReturn_u24lambda_u243;
                                            if (objectRef.element == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                                                irVariable2 = null;
                                            } else {
                                                irVariable2 = (IrVariable)objectRef.element;
                                            }
                                            $this$visitReturn_u24lambda_u243.unaryPlus(ExpressionHelpersKt.irGet(irBuilderWithScope3, irVariable2));
                                            return ExpressionHelpersKt.irReturn(irBuilderWithScope2, this_$iv$iv.doBuild());
                                        }
                                        return expression2;
                                    }
                                }));
                            }
                            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$invoke_u24lambda_u242;
                            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$invoke_u24lambda_u242;
                            if (thisVar.element == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                                irVariable2 = null;
                            } else {
                                irVariable2 = (IrVariable)thisVar.element;
                            }
                            $this$invoke_u24lambda_u242.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irVariable2)));
                            object = this_$iv$iv$iv.doBuild().getStatements();
                            CollectionsKt.addAll((Collection)collection, (Iterable)object);
                        }
                    }));
                    irSimpleFunction = irSimpleFunction2;
                } else {
                    irBlockBody = null;
                }
                irSimpleFunction.setBody(irBlockBody);
            }

            /*
             * WARNING - void declaration
             */
            private final void transformMethodBodyFlat(IrSimpleFunction function2, IrSimpleFunction staticMethod) {
                IrBlockBody irBlockBody;
                if (IrDeclarationsKt.isStaticMethodOfClass(function2) || !AdditionalIrUtilsKt.isReal(function2)) {
                    return;
                }
                IrSimpleFunction irSimpleFunction = staticMethod;
                IrBody irBody = function2.getBody();
                if (irBody != null) {
                    void functionBody;
                    IrBody irBody2 = irBody;
                    InlineClassLowering inlineClassLowering = this.this$0;
                    IrBody irBody3 = irBody2;
                    IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
                    boolean bl = false;
                    irBlockBody = inlineClassLowering.getContext().getIrFactory().createBlockBody(-1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)new Function1<IrBlockBody, Unit>((IrBody)functionBody, function2, staticMethod, inlineClassLowering){
                        final /* synthetic */ IrBody $functionBody;
                        final /* synthetic */ IrSimpleFunction $function;
                        final /* synthetic */ IrSimpleFunction $staticMethod;
                        final /* synthetic */ InlineClassLowering this$0;
                        {
                            this.$functionBody = $functionBody;
                            this.$function = $function;
                            this.$staticMethod = $staticMethod;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                            Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                            List<IrStatement> list2 = $this$createBlockBody.getStatements();
                            IrBody irBody = this.$functionBody;
                            Intrinsics.checkNotNull((Object)irBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                            list2.addAll((Collection<IrStatement>)((IrBlockBody)irBody).getStatements());
                            IrElementTransformerVoidKt.transformChildrenVoid($this$createBlockBody, new IrElementTransformerVoid(this.$function, this.$staticMethod, this.this$0){
                                final /* synthetic */ IrSimpleFunction $function;
                                final /* synthetic */ IrSimpleFunction $staticMethod;
                                final /* synthetic */ InlineClassLowering this$0;
                                {
                                    this.$function = $function;
                                    this.$staticMethod = $staticMethod;
                                    this.this$0 = $receiver;
                                }

                                @NotNull
                                public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration) {
                                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                                    IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                                    if (Intrinsics.areEqual((Object)declaration.getParent(), (Object)this.$function)) {
                                        declaration.setParent(this.$staticMethod);
                                    }
                                    return declaration;
                                }

                                @NotNull
                                public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                                    IrValueParameter irValueParameter;
                                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                                    IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                                    IrValueParameter irValueParameter2 = irValueDeclaration instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration : null;
                                    if (irValueParameter2 == null) {
                                        return super.visitGetValue(expression2);
                                    }
                                    IrValueParameter valueDeclaration = irValueParameter2;
                                    IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)this.$staticMethod.getSymbol(), 0, 0, 6, null);
                                    IrValueParameter irValueParameter3 = valueDeclaration;
                                    if (Intrinsics.areEqual((Object)irValueParameter3, (Object)this.$function.getDispatchReceiverParameter()) ? true : Intrinsics.areEqual((Object)irValueParameter3, (Object)IrUtilsKt.getParentAsClass(this.$function).getThisReceiver())) {
                                        irValueParameter = this.$staticMethod.getValueParameters().get(0);
                                    } else if (Intrinsics.areEqual((Object)irValueParameter3, (Object)this.$function.getExtensionReceiverParameter())) {
                                        irValueParameter = this.$staticMethod.getValueParameters().get(1);
                                    } else if (this.$function.getValueParameters().contains(irValueParameter3)) {
                                        int offset2 = this.$function.getExtensionReceiverParameter() != null ? 2 : 1;
                                        irValueParameter = this.$staticMethod.getValueParameters().get(valueDeclaration.getIndex() + offset2);
                                    } else {
                                        return expression2;
                                    }
                                    return ExpressionHelpersKt.irGet(irBuilderWithScope, irValueParameter);
                                }

                                @NotNull
                                public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                                    IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                                    IrValueParameter irValueParameter = irValueDeclaration instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration : null;
                                    if (irValueParameter == null) {
                                        return super.visitSetValue(expression2);
                                    }
                                    IrValueParameter valueDeclaration = irValueParameter;
                                    this.transformChildrenVoid(expression2);
                                    IrValueParameter irValueParameter2 = valueDeclaration;
                                    if (!this.$function.getValueParameters().contains(irValueParameter2)) {
                                        return expression2;
                                    }
                                    int offset2 = this.$function.getExtensionReceiverParameter() != null ? 2 : 1;
                                    return ExpressionHelpersKt.irSet$default((IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)this.$staticMethod.getSymbol(), 0, 0, 6, null), this.$staticMethod.getValueParameters().get(valueDeclaration.getIndex() + offset2).getSymbol(), expression2.getValue(), null, 4, null);
                                }
                            });
                        }
                    }));
                    irSimpleFunction = irSimpleFunction2;
                } else {
                    irBlockBody = null;
                }
                irSimpleFunction.setBody(irBlockBody);
            }

            private final IrBlockBody delegateToStaticMethod(IrSimpleFunction function2, IrSimpleFunction staticMethod) {
                return this.this$0.getContext().getIrFactory().createBlockBody(-1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)new Function1<IrBlockBody, Unit>(this.this$0, function2, staticMethod){
                    final /* synthetic */ InlineClassLowering this$0;
                    final /* synthetic */ IrSimpleFunction $function;
                    final /* synthetic */ IrSimpleFunction $staticMethod;
                    {
                        this.this$0 = $receiver;
                        this.$function = $function;
                        this.$staticMethod = $staticMethod;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                        void $this$invoke_u24lambda_u241_u24lambda_u240;
                        IrFunctionAccessExpression irFunctionAccessExpression;
                        void this_$iv$iv;
                        void $this$irBlockBody_u24default$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                        Collection collection = $this$createBlockBody.getStatements();
                        Object object = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)this.$function.getSymbol(), 0, 0, 6, null);
                        IrSimpleFunction irSimpleFunction = this.$staticMethod;
                        IrSimpleFunction irSimpleFunction2 = this.$function;
                        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                        boolean $i$f$irBlockBody = false;
                        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                        boolean $i$f$blockBody = false;
                        void $this$invoke_u24lambda_u241 = this_$iv$iv;
                        boolean bl = false;
                        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$invoke_u24lambda_u241, irSimpleFunction);
                        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$invoke_u24lambda_u241;
                        void var16_16 = $this$invoke_u24lambda_u241;
                        boolean bl2 = false;
                        Object object2 = new IrValueParameter[2];
                        Intrinsics.checkNotNull((Object)irSimpleFunction2.getDispatchReceiverParameter());
                        object2[1] = irSimpleFunction2.getExtensionReceiverParameter();
                        List parameters2 = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])object2), (Iterable)irSimpleFunction2.getValueParameters());
                        object2 = parameters2.iterator();
                        int n = 0;
                        while (object2.hasNext()) {
                            int index2 = n++;
                            IrValueParameter valueParameter2 = (IrValueParameter)object2.next();
                            $this$invoke_u24lambda_u241_u24lambda_u240.putValueArgument(index2, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$invoke_u24lambda_u241, valueParameter2));
                        }
                        List typeParameters2 = CollectionsKt.plus((Collection)IrTypeSystemContextKt.extractTypeParameters(IrUtilsKt.getParentAsClass(irSimpleFunction2)), (Iterable)irSimpleFunction2.getTypeParameters());
                        Iterator<E> iterator2 = typeParameters2.iterator();
                        int n2 = 0;
                        while (iterator2.hasNext()) {
                            int index3 = n2++;
                            IrTypeParameter typeParameter2 = (IrTypeParameter)iterator2.next();
                            $this$invoke_u24lambda_u241_u24lambda_u240.putTypeArgument(index3, new IrSimpleTypeImpl((IrClassifierSymbol)typeParameter2.getSymbol(), SimpleTypeNullability.NOT_SPECIFIED, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, 16, null));
                        }
                        Unit unit2 = Unit.INSTANCE;
                        var16_16.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irFunctionAccessExpression));
                        object = this_$iv$iv.doBuild().getStatements();
                        CollectionsKt.addAll((Collection)collection, (Iterable)object);
                    }
                }));
            }
        };
        this.inlineClassUsageLowering = new BodyLoweringPass(this){
            final /* synthetic */ InlineClassLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
                Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
                Intrinsics.checkNotNullParameter((Object)container, (String)"container");
                IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this.this$0){
                    final /* synthetic */ InlineClassLowering this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    @NotNull
                    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                        IrConstructor function2 = (IrConstructor)expression2.getSymbol().getOwner();
                        if (!InlineClassLowering.access$isClassInlineLike(this.this$0, IrUtilsKt.getParentAsClass(function2))) {
                            return expression2;
                        }
                        return IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function2), false, false, null, null, 60, null);
                    }

                    @NotNull
                    public IrExpression visitCall(@NotNull IrCall expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                        IrSimpleFunction function2 = (IrSimpleFunction)expression2.getSymbol().getOwner();
                        if (!(function2.getParent() instanceof IrClass) || IrDeclarationsKt.isStaticMethodOfClass(function2) || !InlineClassLowering.access$isClassInlineLike(this.this$0, IrUtilsKt.getParentAsClass(function2)) || !AdditionalIrUtilsKt.isReal(function2)) {
                            return expression2;
                        }
                        return IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function2), true, false, null, null, 56, null);
                    }

                    @NotNull
                    public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                        IrConstructor function2 = (IrConstructor)expression2.getSymbol().getOwner();
                        IrClass klass = IrUtilsKt.getParentAsClass(function2);
                        return !InlineClassLowering.access$isClassInlineLike(this.this$0, klass) ? (IrExpression)expression2 : (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function2), false, false, null, null, 60, null);
                    }
                });
            }
        };
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    private final boolean isClassInlineLike(IrClass irClass2) {
        return this.context.getInlineClassesUtils().isClassInlineLike(irClass2);
    }

    @NotNull
    public final DeclarationTransformer getInlineClassDeclarationLowering() {
        return this.inlineClassDeclarationLowering;
    }

    private final IrSimpleFunction getOrCreateStaticMethod(IrFunction function2) {
        return MappingsKt.getOrPut(this.transformedFunction, (IrDeclaration)function2, (Function0)new Function0<IrSimpleFunction>(this, function2){
            final /* synthetic */ InlineClassLowering this$0;
            final /* synthetic */ IrFunction $function;
            {
                this.this$0 = $receiver;
                this.$function = $function;
                super(0);
            }

            @NotNull
            public final IrSimpleFunction invoke() {
                return InlineClassLowering.access$createStaticBodilessMethod(this.this$0, this.$function);
            }
        });
    }

    @NotNull
    public final BodyLoweringPass getInlineClassUsageLowering() {
        return this.inlineClassUsageLowering;
    }

    private final Name toInlineClassImplementationName(IrFunction $this$toInlineClassImplementationName) {
        Name name;
        String newName2 = IrUtilsKt.getParentAsClass($this$toInlineClassImplementationName).getName().asString() + "__" + $this$toInlineClassImplementationName.getName().asString() + "-impl";
        if ($this$toInlineClassImplementationName.getName().isSpecial()) {
            Name name2 = Name.special('<' + newName2 + '>');
            name = name2;
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<$newName>\")");
        } else {
            Name name3 = Name.identifier(newName2);
            name = name3;
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(newName)");
        }
        return name;
    }

    private final IrSimpleFunction createStaticBodilessMethod(IrFunction function2) {
        return IrUtilsKt.createStaticFunctionWithReceivers$default(this.context.getIrFactory(), function2.getParent(), this.toInlineClassImplementationName(function2), function2, null, null, null, null, false, false, IrTypeSystemContextKt.extractTypeParameters(IrUtilsKt.getParentAsClass(function2)), 504, null);
    }

    public static final /* synthetic */ IrSimpleFunction access$createStaticBodilessMethod(InlineClassLowering $this, IrFunction function2) {
        return $this.createStaticBodilessMethod(function2);
    }

    public static final /* synthetic */ boolean access$isClassInlineLike(InlineClassLowering $this, IrClass irClass2) {
        return $this.isClassInlineLike(irClass2);
    }

    public static final /* synthetic */ IrSimpleFunction access$getOrCreateStaticMethod(InlineClassLowering $this, IrFunction function2) {
        return $this.getOrCreateStaticMethod(function2);
    }
}

