/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.sun.tools.javac.util.Context;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.tasks.compile.AnnotationProcessingCompileTask;
import org.gradle.api.internal.tasks.compile.ApiCompilerResult;
import org.gradle.api.internal.tasks.compile.CompilationClassBackupService;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.ContextAwareJavaCompiler;
import org.gradle.api.internal.tasks.compile.DiagnosticToProblemListener;
import org.gradle.api.internal.tasks.compile.IncrementalCompilationAwareJavaCompiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompileOptions;
import org.gradle.api.internal.tasks.compile.ResourceCleaningCompilationTask;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDeclaration;
import org.gradle.api.internal.tasks.compile.reflect.GradleStandardJavaFileManager;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.language.base.internal.compile.Compiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkJavaCompiler
implements Compiler<JavaCompileSpec>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkJavaCompiler.class);
    private final Context context = new Context();
    private final Factory<ContextAwareJavaCompiler> compilerFactory;
    private final InternalProblems problemsService;
    private final DiagnosticToProblemListener diagnosticToProblemListener;

    @Inject
    public JdkJavaCompiler(Factory<ContextAwareJavaCompiler> compilerFactory, InternalProblems problemsService) {
        this.compilerFactory = compilerFactory;
        this.problemsService = problemsService;
        this.diagnosticToProblemListener = new DiagnosticToProblemListener(problemsService.getInternalReporter(), this.context);
    }

    public WorkResult execute(JavaCompileSpec spec) {
        JavaCompiler.CompilationTask task;
        LOGGER.info("Compiling with JDK Java compiler API.");
        ApiCompilerResult result = new ApiCompilerResult();
        try {
            task = this.createCompileTask(spec, result);
        }
        catch (RuntimeException ex) {
            throw this.problemsService.getInternalReporter().throwing(builder -> JdkJavaCompiler.buildProblemFrom(ex, builder));
        }
        boolean success = task.call();
        String diagnosticCounts = this.diagnosticToProblemListener.diagnosticCounts();
        if (!"".equals(diagnosticCounts)) {
            System.err.println(diagnosticCounts);
        }
        if (!success) {
            CompilationFailedException exception = new CompilationFailedException(result, this.diagnosticToProblemListener.getReportedProblems(), diagnosticCounts);
            throw this.problemsService.getInternalReporter().throwing((Throwable)exception, this.diagnosticToProblemListener.getReportedProblems());
        }
        this.problemsService.getInternalReporter().report(this.diagnosticToProblemListener.getReportedProblems());
        return result;
    }

    private JavaCompiler.CompilationTask createCompileTask(JavaCompileSpec spec, ApiCompilerResult result) {
        List<String> options = new JavaCompilerArgumentsBuilder(spec).build();
        ContextAwareJavaCompiler compiler = (ContextAwareJavaCompiler)this.compilerFactory.create();
        Objects.requireNonNull(compiler, "Compiler factory returned null compiler");
        MinimalJavaCompileOptions compileOptions = spec.getCompileOptions();
        Charset charset = Optional.ofNullable(compileOptions.getEncoding()).map(Charset::forName).orElse(null);
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(this.diagnosticToProblemListener, null, charset);
        Iterable<? extends JavaFileObject> compilationUnits = standardFileManager.getJavaFileObjectsFromFiles(spec.getSourceFiles());
        boolean hasEmptySourcepaths = JavaVersion.current().isJava9Compatible() && JdkJavaCompiler.emptySourcepathIn(options);
        JavaFileManager fileManager = GradleStandardJavaFileManager.wrap(standardFileManager, DefaultClassPath.of(spec.getAnnotationProcessorPath()), hasEmptySourcepaths);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, this.diagnosticToProblemListener, options, spec.getClassesToProcess(), compilationUnits, this.context);
        if (compiler instanceof IncrementalCompilationAwareJavaCompiler) {
            task = ((IncrementalCompilationAwareJavaCompiler)compiler).makeIncremental(task, result.getSourceClassesMapping(), result.getConstantsAnalysisResult(), new CompilationSourceDirs(spec), new CompilationClassBackupService(spec, result));
        }
        Set<AnnotationProcessorDeclaration> annotationProcessors = spec.getEffectiveAnnotationProcessors();
        task = new AnnotationProcessingCompileTask(task, annotationProcessors, spec.getAnnotationProcessorPath(), result.getAnnotationProcessingResult());
        task = new ResourceCleaningCompilationTask(task, fileManager);
        return task;
    }

    private static boolean emptySourcepathIn(List<String> options) {
        Iterator<String> optionsIter = options.iterator();
        while (optionsIter.hasNext()) {
            String current = optionsIter.next();
            if (!current.equals("-sourcepath") && !current.equals("--source-path")) continue;
            return optionsIter.next().isEmpty();
        }
        return false;
    }

    private static void buildProblemFrom(RuntimeException ex, ProblemSpec spec) {
        spec.severity(Severity.ERROR);
        spec.id("initialization-failed", "Java compilation initialization error", GradleCoreProblemGroup.compilation().java());
        spec.contextualLabel(ex.getLocalizedMessage());
        spec.withException((Throwable)ex);
    }

    public static boolean canBeUsed() {
        try {
            new Context();
        }
        catch (IllegalAccessError e) {
            LOGGER.debug("Expected failure when checking class presence: {}", (Object)e.getMessage());
            return false;
        }
        catch (Throwable throwable) {
            LOGGER.debug("Unexpected failure when checking class presence: {}", (Object)throwable.getMessage());
            return false;
        }
        return true;
    }
}

