/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.scala;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.ScalaSourceDirectorySet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.jvm.component.internal.JvmSoftwareComponentInternal;
import org.gradle.language.scala.tasks.AbstractScalaCompile;

public abstract class ScalaPlugin
implements Plugin<Project> {
    public static final String SCALA_DOC_TASK_NAME = "scaladoc";

    public void apply(Project project) {
        project.getPluginManager().apply(ScalaBasePlugin.class);
        project.getPluginManager().apply(JavaPlugin.class);
        JvmSoftwareComponentInternal component = JavaPluginHelper.getJavaComponent((Project)project);
        ScalaPlugin.configureScaladoc(project, component);
        Configuration incrementalAnalysisElements = project.getConfigurations().getByName("incrementalScalaAnalysisElements");
        String compileTaskName = component.getSourceSet().getCompileTaskName("scala");
        TaskProvider compileScala = project.getTasks().withType(AbstractScalaCompile.class).named(compileTaskName);
        Provider compileScalaMapping = project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + compileTaskName + ".mapping");
        compileScala.configure(task -> task.getAnalysisMappingFile().set(compileScalaMapping));
        incrementalAnalysisElements.getOutgoing().artifact((Object)compileScalaMapping, configurablePublishArtifact -> configurablePublishArtifact.builtBy(new Object[]{compileScala}));
    }

    private static void configureScaladoc(Project project, JvmSoftwareComponentInternal component) {
        project.getTasks().withType(ScalaDoc.class).configureEach(scalaDoc -> {
            scalaDoc.getConventionMapping().map("classpath", () -> {
                ConfigurableFileCollection files = project.files(new Object[0]);
                files.from(new Object[]{component.getMainOutput()});
                files.from(new Object[]{component.getSourceSet().getCompileClasspath()});
                return files;
            });
            scalaDoc.setSource((FileTree)component.getSourceSet().getExtensions().getByType(ScalaSourceDirectorySet.class));
            scalaDoc.getCompilationOutputs().from(new Object[]{component.getMainOutput()});
        });
        project.getTasks().register(SCALA_DOC_TASK_NAME, ScalaDoc.class, scalaDoc -> {
            scalaDoc.setDescription("Generates Scaladoc for the main source code.");
            scalaDoc.setGroup("documentation");
        });
    }
}

