/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import com.google.common.collect.Interner;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.artifacts.DefaultProjectDependencyFactory;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableMinimalDependency;
import org.gradle.api.internal.artifacts.dependencies.DependencyVariant;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryHelper;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.notations.DependencyClassPathNotationConverter;
import org.gradle.api.internal.notations.DependencyFilesNotationConverter;
import org.gradle.api.internal.notations.DependencyMapNotationConverter;
import org.gradle.api.internal.notations.DependencyProjectNotationConverter;
import org.gradle.api.internal.notations.DependencyStringNotationConverter;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarFactory;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationConverterToNotationParserAdapter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

public class DependencyNotationParser {
    private final NotationParser<Object, Dependency> notationParser;
    private final NotationParser<String, ? extends ExternalModuleDependency> stringNotationParser;
    private final NotationParser<MinimalExternalModuleDependency, ? extends MinimalExternalModuleDependency> minimalExternalModuleDependencyNotationParser;
    private final NotationParser<Map<String, ?>, ? extends ExternalModuleDependency> mapNotationParser;
    private final NotationParser<FileCollection, ? extends FileCollectionDependency> fileCollectionNotationParser;
    private final NotationParser<Project, ? extends ProjectDependency> projectNotationParser;

    public static DependencyNotationParser create(Instantiator instantiator, DefaultProjectDependencyFactory dependencyFactory, ClassPathRegistry classPathRegistry, FileCollectionFactory fileCollectionFactory, RuntimeShadedJarFactory runtimeShadedJarFactory, CurrentGradleInstallation currentGradleInstallation, Interner<String> stringInterner, ImmutableAttributesFactory attributesFactory, NotationParser<Object, Capability> capabilityNotationParser) {
        DependencyStringNotationConverter<DefaultExternalModuleDependency> stringNotationConverter = new DependencyStringNotationConverter<DefaultExternalModuleDependency>(instantiator, DefaultExternalModuleDependency.class, stringInterner);
        MinimalExternalDependencyNotationConverter minimalExternalDependencyNotationConverter = new MinimalExternalDependencyNotationConverter(instantiator, attributesFactory, capabilityNotationParser);
        DependencyMapNotationConverter<DefaultExternalModuleDependency> mapNotationConverter = new DependencyMapNotationConverter<DefaultExternalModuleDependency>(instantiator, DefaultExternalModuleDependency.class);
        DependencyFilesNotationConverter filesNotationConverter = new DependencyFilesNotationConverter(instantiator);
        DependencyProjectNotationConverter projectNotationConverter = new DependencyProjectNotationConverter(dependencyFactory);
        DependencyClassPathNotationConverter dependencyClassPathNotationConverter = new DependencyClassPathNotationConverter(instantiator, classPathRegistry, fileCollectionFactory, runtimeShadedJarFactory, currentGradleInstallation);
        NotationParser notationParser = NotationParserBuilder.toType(Dependency.class).noImplicitConverters().fromCharSequence(stringNotationConverter).fromType(MinimalExternalModuleDependency.class, (NotationConverter)minimalExternalDependencyNotationConverter).converter(mapNotationConverter).fromType(FileCollection.class, (NotationConverter)filesNotationConverter).fromType(Project.class, (NotationConverter)projectNotationConverter).fromType(DependencyFactoryInternal.ClassPathNotation.class, (NotationConverter)dependencyClassPathNotationConverter).invalidNotationMessage("Comprehensive documentation on dependency notations is available in DSL reference for DependencyHandler type.").toComposite();
        return new DependencyNotationParser((NotationParser<Object, Dependency>)notationParser, (NotationParser<String, ? extends ExternalModuleDependency>)new NotationConverterToNotationParserAdapter(stringNotationConverter), (NotationParser<MinimalExternalModuleDependency, ? extends MinimalExternalModuleDependency>)new NotationConverterToNotationParserAdapter((NotationConverter)minimalExternalDependencyNotationConverter), (NotationParser<Map<String, ?>, ? extends ExternalModuleDependency>)new NotationConverterToNotationParserAdapter(mapNotationConverter), (NotationParser<FileCollection, ? extends FileCollectionDependency>)new NotationConverterToNotationParserAdapter((NotationConverter)filesNotationConverter), (NotationParser<Project, ? extends ProjectDependency>)new NotationConverterToNotationParserAdapter((NotationConverter)projectNotationConverter));
    }

    private DependencyNotationParser(NotationParser<Object, Dependency> notationParser, NotationParser<String, ? extends ExternalModuleDependency> stringNotationParser, NotationParser<MinimalExternalModuleDependency, ? extends MinimalExternalModuleDependency> minimalExternalModuleDependencyNotationParser, NotationParser<Map<String, ?>, ? extends ExternalModuleDependency> mapNotationParser, NotationParser<FileCollection, ? extends FileCollectionDependency> fileCollectionNotationParser, NotationParser<Project, ? extends ProjectDependency> projectNotationParser) {
        this.notationParser = notationParser;
        this.stringNotationParser = stringNotationParser;
        this.minimalExternalModuleDependencyNotationParser = minimalExternalModuleDependencyNotationParser;
        this.mapNotationParser = mapNotationParser;
        this.fileCollectionNotationParser = fileCollectionNotationParser;
        this.projectNotationParser = projectNotationParser;
    }

    public NotationParser<Object, Dependency> getNotationParser() {
        return this.notationParser;
    }

    public NotationParser<String, ? extends ExternalModuleDependency> getStringNotationParser() {
        return this.stringNotationParser;
    }

    public NotationParser<MinimalExternalModuleDependency, ? extends MinimalExternalModuleDependency> getMinimalExternalModuleDependencyNotationParser() {
        return this.minimalExternalModuleDependencyNotationParser;
    }

    public NotationParser<Map<String, ?>, ? extends ExternalModuleDependency> getMapNotationParser() {
        return this.mapNotationParser;
    }

    public NotationParser<FileCollection, ? extends FileCollectionDependency> getFileCollectionNotationParser() {
        return this.fileCollectionNotationParser;
    }

    public NotationParser<Project, ? extends ProjectDependency> getProjectNotationParser() {
        return this.projectNotationParser;
    }

    private static class MinimalExternalDependencyNotationConverter
    implements NotationConverter<MinimalExternalModuleDependency, MinimalExternalModuleDependency> {
        private final Instantiator instantiator;
        private final ImmutableAttributesFactory attributesFactory;
        private final NotationParser<Object, Capability> capabilityNotationParser;

        public MinimalExternalDependencyNotationConverter(Instantiator instantiator, ImmutableAttributesFactory attributesFactory, NotationParser<Object, Capability> capabilityNotationParser) {
            this.instantiator = instantiator;
            this.attributesFactory = attributesFactory;
            this.capabilityNotationParser = capabilityNotationParser;
        }

        public void convert(MinimalExternalModuleDependency notation, NotationConvertResult<? super MinimalExternalModuleDependency> result) throws TypeConversionException {
            DefaultMutableMinimalDependency moduleDependency = (DefaultMutableMinimalDependency)this.instantiator.newInstance(DefaultMutableMinimalDependency.class, new Object[]{notation.getModule(), notation.getVersionConstraint()});
            if (notation instanceof DependencyVariant) {
                moduleDependency.setAttributesFactory(this.attributesFactory);
                moduleDependency.setCapabilityNotationParser(this.capabilityNotationParser);
                DependencyVariant dependencyVariant = (DependencyVariant)notation;
                moduleDependency.attributes(dependencyVariant::mutateAttributes);
                moduleDependency.capabilities(dependencyVariant::mutateCapabilities);
                String classifier = dependencyVariant.getClassifier();
                String artifactType = dependencyVariant.getArtifactType();
                if (classifier != null || artifactType != null) {
                    ModuleFactoryHelper.addExplicitArtifactsIfDefined((ExternalDependency)moduleDependency, artifactType, classifier);
                }
            }
            result.converted((Object)moduleDependency);
        }

        public void describe(DiagnosticsVisitor visitor) {
        }
    }
}

