/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.transaction;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.GeneratedResource;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.Deleter;
import org.gradle.language.base.internal.tasks.StaleOutputCleaner;

public class CompileTransaction {
    private final Deleter deleter;
    private final FileOperations fileOperations;
    private final PatternSet classesToDelete;
    private final JavaCompileSpec spec;
    private final Map<GeneratedResource.Location, PatternSet> resourcesToDelete;
    private final File stashDirectory;
    private final File tempDir;

    public CompileTransaction(JavaCompileSpec spec, PatternSet classesToDelete, Map<GeneratedResource.Location, PatternSet> resourcesToDelete, FileOperations fileOperations, Deleter deleter) {
        this.spec = spec;
        this.tempDir = new File(spec.getTempDir(), "compileTransaction");
        this.stashDirectory = new File(this.tempDir, "stash-dir");
        this.classesToDelete = classesToDelete;
        this.resourcesToDelete = resourcesToDelete;
        this.fileOperations = fileOperations;
        this.deleter = deleter;
    }

    public <T> T execute(Function<WorkResult, T> function) {
        List<StagedOutput> stagedOutputs = this.collectOutputsToStage();
        this.ensureEmptyDirectoriesBeforeExecution(stagedOutputs);
        StashResult stashResult = this.stashFilesThatShouldBeDeleted();
        try {
            this.setupSpecOutputs(stagedOutputs);
            T result = function.apply(stashResult.mapToWorkResult());
            this.deletePotentiallyEmptyDirectories(stashResult);
            this.moveCompileOutputToOriginalFolders(stagedOutputs);
            T t = result;
            return t;
        }
        catch (CompilationFailedException t) {
            if (this.spec.getCompileOptions().supportsIncrementalCompilationAfterFailure()) {
                this.rollbackStash(stashResult.stashedFiles);
            }
            throw t;
        }
        finally {
            this.restoreSpecOutputs(stagedOutputs);
        }
    }

    private void ensureEmptyDirectoriesBeforeExecution(List<StagedOutput> stagedOutputs) {
        try {
            this.tempDir.mkdirs();
            HashSet<File> ensureEmptyDirectories = new HashSet<File>();
            this.deleter.ensureEmptyDirectory(this.stashDirectory);
            ensureEmptyDirectories.add(this.stashDirectory);
            for (StagedOutput output : stagedOutputs) {
                this.ensureEmptyKeepingFolderStructure(output);
                ensureEmptyDirectories.add(output.stagingDirectory);
            }
            try (Stream<Path> dirStream = Files.list(this.tempDir.toPath());){
                dirStream.map(Path::toFile).filter(file -> !ensureEmptyDirectories.contains(file)).forEach(this::deleteRecursively);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private void ensureEmptyKeepingFolderStructure(StagedOutput output) throws IOException {
        Path currentDir = output.stagingDirectory.toPath();
        if (!Files.exists(currentDir, new LinkOption[0])) {
            Files.createDirectory(currentDir, new FileAttribute[0]);
            return;
        }
        try (Stream<Path> dirStream = Files.walk(currentDir, new FileVisitOption[0]);){
            dirStream.sorted(Comparator.reverseOrder()).filter(path -> !Files.isDirectory(path, new LinkOption[0]) || !this.isDirectoryAlsoInOtherRoot((Path)path, currentDir, output.sourceDirectory)).forEach(path -> path.toFile().delete());
        }
    }

    private boolean isDirectoryAlsoInOtherRoot(Path directory, Path root, File otherRoot) {
        Path relativePath = root.relativize(directory);
        File fileInOtherRoot = new File(otherRoot, relativePath.toString());
        return fileInOtherRoot.isDirectory();
    }

    private void deleteRecursively(File file) {
        try {
            this.deleter.deleteRecursively(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private List<StagedOutput> collectOutputsToStage() {
        ArrayList<StagedOutput> stagedOutputs = new ArrayList<StagedOutput>();
        stagedOutputs.add(new StagedOutput(this.spec.getDestinationDir(), new File(this.tempDir, "compile-output"), arg_0 -> ((JavaCompileSpec)this.spec).setDestinationDir(arg_0)));
        File annotationOutputDir = this.spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory();
        if (annotationOutputDir != null) {
            StagedOutput stagedOutput = new StagedOutput(annotationOutputDir, new File(this.tempDir, "annotation-output"), file -> this.spec.getCompileOptions().setAnnotationProcessorGeneratedSourcesDirectory((File)file));
            stagedOutputs.add(stagedOutput);
        }
        File headerOutputDir = this.spec.getCompileOptions().getHeaderOutputDirectory();
        if (this.spec.getCompileOptions().getHeaderOutputDirectory() != null) {
            StagedOutput stagedOutput = new StagedOutput(headerOutputDir, new File(this.tempDir, "header-output"), file -> this.spec.getCompileOptions().setHeaderOutputDirectory((File)file));
            stagedOutputs.add(stagedOutput);
        }
        return stagedOutputs;
    }

    private StashResult stashFilesThatShouldBeDeleted() {
        int uniqueId = 0;
        File compileOutput = this.spec.getDestinationDir();
        File annotationProcessorOutput = this.spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory();
        File headerOutput = this.spec.getCompileOptions().getHeaderOutputDirectory();
        ArrayList<StashedFile> stashedFiles = new ArrayList<StashedFile>();
        for (File sourceFile : this.collectFilesToStash(compileOutput, annotationProcessorOutput, headerOutput)) {
            File stashedFile = new File(this.stashDirectory, sourceFile.getName() + ".uniqueId" + uniqueId++);
            CompileTransaction.moveFile(sourceFile, stashedFile);
            stashedFiles.add(new StashedFile(sourceFile, stashedFile));
        }
        List sourceDirectories = Stream.of(compileOutput, annotationProcessorOutput, headerOutput).filter(Objects::nonNull).collect(Collectors.toList());
        return new StashResult(sourceDirectories, stashedFiles);
    }

    private Set<File> collectFilesToStash(File compileOutput, @Nullable File annotationProcessorOutput, @Nullable File headerOutput) {
        HashSet<File> filesToStash = new HashSet<File>();
        filesToStash.addAll(this.collectFilesToStash(this.classesToDelete, compileOutput));
        filesToStash.addAll(this.collectFilesToStash(this.classesToDelete, annotationProcessorOutput));
        filesToStash.addAll(this.collectFilesToStash(this.classesToDelete, headerOutput));
        filesToStash.addAll(this.collectFilesToStash(this.resourcesToDelete.get((Object)GeneratedResource.Location.CLASS_OUTPUT), compileOutput));
        filesToStash.addAll(this.collectFilesToStash(this.resourcesToDelete.get((Object)GeneratedResource.Location.SOURCE_OUTPUT), (File)MoreObjects.firstNonNull((Object)annotationProcessorOutput, (Object)compileOutput)));
        filesToStash.addAll(this.collectFilesToStash(this.resourcesToDelete.get((Object)GeneratedResource.Location.NATIVE_HEADER_OUTPUT), headerOutput));
        return filesToStash;
    }

    private Set<File> collectFilesToStash(PatternSet patternSet, File sourceDirectory) {
        if (patternSet != null && !patternSet.isEmpty() && sourceDirectory != null && sourceDirectory.exists()) {
            return this.fileOperations.fileTree((Object)sourceDirectory).matching((PatternFilterable)patternSet).getFiles();
        }
        return Collections.emptySet();
    }

    private void deletePotentiallyEmptyDirectories(StashResult stashResult) {
        Set potentiallyEmptyFolders = stashResult.stashedFiles.stream().map(file -> ((StashedFile)file).sourceFile.getParentFile()).collect(Collectors.toSet());
        StaleOutputCleaner.cleanEmptyOutputDirectories((Deleter)this.deleter, potentiallyEmptyFolders, (Collection)stashResult.sourceDirectories);
    }

    private void moveCompileOutputToOriginalFolders(List<StagedOutput> stagedOutputs) {
        stagedOutputs.forEach(StagedOutput::unstage);
    }

    private void rollbackStash(List<StashedFile> stashedFiles) {
        stashedFiles.forEach(StashedFile::unstash);
    }

    private void setupSpecOutputs(List<StagedOutput> stagedOutputs) {
        stagedOutputs.forEach(StagedOutput::setupSpecOutput);
    }

    private void restoreSpecOutputs(List<StagedOutput> stagedOutputs) {
        stagedOutputs.forEach(StagedOutput::restoreSpecOutput);
    }

    private static void moveFile(File sourceFile, File destinationFile) {
        try {
            destinationFile.getParentFile().mkdirs();
            Files.move(sourceFile.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private static class StashedFile {
        private final File sourceFile;
        private final File stashFile;

        private StashedFile(File sourceFile, File stashFile) {
            this.sourceFile = sourceFile;
            this.stashFile = stashFile;
        }

        public void unstash() {
            CompileTransaction.moveFile(this.stashFile, this.sourceFile);
        }
    }

    private static class StagedOutput {
        private final File sourceDirectory;
        private final File stagingDirectory;
        private final Consumer<File> setSpecOutput;

        private StagedOutput(File sourceDirectory, File stagingDirectory, Consumer<File> setSpecOutput) {
            this.sourceDirectory = sourceDirectory;
            this.stagingDirectory = stagingDirectory;
            this.setSpecOutput = setSpecOutput;
        }

        public void setupSpecOutput() {
            this.setSpecOutput.accept(this.stagingDirectory);
        }

        public void restoreSpecOutput() {
            this.setSpecOutput.accept(this.sourceDirectory);
        }

        public void unstage() {
            Path stagingPath = this.stagingDirectory.toPath();
            try (Stream<Path> dirStream = Files.walk(stagingPath, new FileVisitOption[0]);){
                dirStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                    File newFile = new File(this.sourceDirectory, stagingPath.relativize((Path)path).toString());
                    CompileTransaction.moveFile(path.toFile(), newFile);
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
    }

    private static class StashResult {
        private final List<File> sourceDirectories;
        private final List<StashedFile> stashedFiles;

        private StashResult(List<File> sourceDirectories, List<StashedFile> stashedFiles) {
            this.sourceDirectories = sourceDirectories;
            this.stashedFiles = stashedFiles;
        }

        public WorkResult mapToWorkResult() {
            return WorkResults.didWork((!this.stashedFiles.isEmpty() ? 1 : 0) != 0);
        }
    }
}

