/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeLocalVariableNoTypeOrInitializer;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001aF\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0016\u001a\u00020\u0001H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0017"}, d2={"hasAccessorImplementation", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getHasAccessorImplementation", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Z", "checkExpectDeclarationVisibilityAndBody", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "checkPropertyInitializer", "containingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "property", "modifierList", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "isInitialized", "reachable", "checkers"})
public final class FirTopLevelPropertiesCheckerKt {
    public static final void checkExpectDeclarationVisibilityAndBody(@NotNull FirMemberDeclaration declaration2, @NotNull KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirMemberDeclaration $this$isExpect$iv = declaration2;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            FirMemberDeclaration $this$visibility$iv = declaration2;
            boolean $i$f$getVisibility = false;
            if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_PRIVATE_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
            }
            if (declaration2 instanceof FirSimpleFunction) {
                FirFunction $this$hasBody$iv = (FirFunction)declaration2;
                boolean $i$f$getHasBody = false;
                if ($this$hasBody$iv.getBody() != null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
    }

    public static final void checkPropertyInitializer(@Nullable FirClass containingClass, @NotNull FirProperty property2, @Nullable FirModifierList modifierList2, boolean isInitialized, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2, boolean reachable) {
        boolean isAbstract;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirClass firClass = containingClass;
        if (firClass != null) {
            FirClass $this$isInterface$iv = firClass;
            boolean $i$f$isInterface = false;
            ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
            boolean $i$f$isInterface2 = false;
            bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        } else {
            bl = false;
        }
        boolean inInterface = bl;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"ABSTRACT_KEYWORD");
        boolean hasAbstractModifier = FirKeywordUtilsKt.contains(modifierList2, ktModifierKeywordToken);
        FirMemberDeclaration $this$isAbstract$iv = property2;
        boolean $i$f$isAbstract = false;
        boolean bl2 = isAbstract = $this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT || hasAbstractModifier;
        if (isAbstract) {
            FirTypeRef returnTypeRef = property2.getReturnTypeRef();
            if (property2.getInitializer() == null && property2.getDelegate() == null && returnTypeRef instanceof FirErrorTypeRef && ((FirErrorTypeRef)returnTypeRef).getDiagnostic() instanceof ConeLocalVariableNoTypeOrInitializer) {
                KtSourceElement ktSourceElement = property2.getSource();
                if (ktSourceElement != null) {
                    KtSourceElement it = ktSourceElement;
                    boolean bl3 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getPROPERTY_WITH_NO_TYPE_NO_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
                }
            }
            return;
        }
        boolean backingFieldRequired = DeclarationAttributesKt.getHasBackingField(property2);
        if (inInterface && backingFieldRequired && FirTopLevelPropertiesCheckerKt.getHasAccessorImplementation(property2)) {
            KtSourceElement ktSourceElement = property2.getSource();
            if (ktSourceElement != null) {
                KtSourceElement it = ktSourceElement;
                boolean bl4 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getBACKING_FIELD_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        boolean isExpect = DeclarationUtilsKt.isEffectivelyExpect(property2, containingClass, context2);
        if (property2.getInitializer() != null) {
            Object object = property2.getInitializer();
            if (object != null && (object = ((FirExpression)object).getSource()) != null) {
                Object it = object;
                boolean bl5 = false;
                if (inInterface) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getPROPERTY_INITIALIZER_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
                } else if (isExpect) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getEXPECTED_PROPERTY_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
                } else if (!backingFieldRequired) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getPROPERTY_INITIALIZER_NO_BACKING_FIELD(), (DiagnosticContext)context2, null, 8, null);
                } else if (property2.getReceiverTypeRef() != null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getEXTENSION_PROPERTY_WITH_BACKING_FIELD(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        } else if (property2.getDelegate() != null) {
            Object object = property2.getDelegate();
            if (object != null && (object = ((FirExpression)object).getSource()) != null) {
                Object it = object;
                boolean bl6 = false;
                if (inInterface) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getDELEGATED_PROPERTY_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
                } else if (isExpect) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getEXPECTED_DELEGATED_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        } else {
            boolean $i$f$isLateInit;
            KtSourceElement ktSourceElement = property2.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement propertySource = ktSourceElement;
            boolean isExternal = DeclarationUtilsKt.isEffectivelyExternal(property2, containingClass, context2);
            if (backingFieldRequired && !inInterface) {
                FirMemberDeclaration $this$isLateInit$iv = property2;
                $i$f$isLateInit = false;
                if (!($this$isLateInit$iv.getStatus().isLateInit() || isExpect || isInitialized || isExternal || DeclarationAttributesKt.getHasExplicitBackingField(property2))) {
                    if (property2.getReceiverTypeRef() != null && !FirTopLevelPropertiesCheckerKt.getHasAccessorImplementation(property2)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertySource, FirErrors.INSTANCE.getEXTENSION_PROPERTY_MUST_HAVE_ACCESSORS_OR_BE_ABSTRACT(), (DiagnosticContext)context2, null, 8, null);
                    } else if (reachable) {
                        if (containingClass == null || FirTopLevelPropertiesCheckerKt.getHasAccessorImplementation(property2)) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertySource, FirErrors.INSTANCE.getMUST_BE_INITIALIZED(), (DiagnosticContext)context2, null, 8, null);
                        } else {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertySource, FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_ABSTRACT(), (DiagnosticContext)context2, null, 8, null);
                        }
                    }
                }
            }
            FirMemberDeclaration $this$isLateInit$iv = property2;
            $i$f$isLateInit = false;
            if ($this$isLateInit$iv.getStatus().isLateInit()) {
                if (isExpect) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertySource, FirErrors.INSTANCE.getEXPECTED_LATEINIT_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
                }
                if (backingFieldRequired && !inInterface && isInitialized) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertySource, FirErrors.INSTANCE.getUNNECESSARY_LATEINIT(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
    }

    public static /* synthetic */ void checkPropertyInitializer$default(FirClass firClass, FirProperty firProperty, FirModifierList firModifierList, boolean bl, DiagnosticReporter diagnosticReporter, CheckerContext checkerContext, boolean bl2, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        FirTopLevelPropertiesCheckerKt.checkPropertyInitializer(firClass, firProperty, firModifierList, bl, diagnosticReporter, checkerContext, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getHasAccessorImplementation(FirProperty $this$hasAccessorImplementation) {
        boolean $i$f$getHasBody;
        FirPropertyAccessor $this$hasBody$iv;
        if (!($this$hasAccessorImplementation.getGetter() instanceof FirDefaultPropertyAccessor)) {
            boolean bl;
            FirPropertyAccessor firPropertyAccessor = $this$hasAccessorImplementation.getGetter();
            if (firPropertyAccessor != null) {
                $this$hasBody$iv = firPropertyAccessor;
                $i$f$getHasBody = false;
                if ($this$hasBody$iv.getBody() != null) {
                    return true;
                }
                boolean bl2 = false;
                if (bl2) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
        }
        if ($this$hasAccessorImplementation.getSetter() instanceof FirDefaultPropertyAccessor) return false;
        FirPropertyAccessor firPropertyAccessor = $this$hasAccessorImplementation.getSetter();
        if (firPropertyAccessor == null) return false;
        $this$hasBody$iv = firPropertyAccessor;
        $i$f$getHasBody = false;
        if ($this$hasBody$iv.getBody() == null) return false;
        return true;
    }
}

