/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.NullableNotNullManager;
import org.jetbrains.kotlin.com.intellij.lang.java.beans.PropertyKind;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.VariableKind;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class PropertyUtilBase {
    @NonNls
    protected static final String GET_PREFIX = PropertyKind.GETTER.prefix;
    @NonNls
    protected static final String IS_PREFIX = PropertyKind.BOOLEAN_GETTER.prefix;
    @NotNull
    protected static final String SET_PREFIX = PropertyKind.SETTER.prefix;

    @Nullable
    public static String getPropertyName(@NonNls @NotNull String methodName) {
        if (methodName == null) {
            PropertyUtilBase.$$$reportNull$$$0(0);
        }
        return StringUtil.getPropertyName(methodName);
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(@NotNull PsiClass psiClass, boolean acceptSetters, boolean acceptGetters) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(1);
        }
        return PropertyUtilBase.getAllProperties(psiClass, acceptSetters, acceptGetters, true);
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(@NotNull PsiClass psiClass, boolean acceptSetters, boolean acceptGetters, boolean includeSuperClass) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(2);
        }
        return PropertyUtilBase.getAllProperties(acceptSetters, acceptGetters, includeSuperClass ? psiClass.getAllMethods() : psiClass.getMethods());
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(boolean acceptSetters, boolean acceptGetters, PsiMethod[] methods2) {
        HashMap<String, PsiMethod> map = new HashMap<String, PsiMethod>();
        for (PsiMethod method : methods2) {
            if (PropertyUtilBase.filterMethods(method) || (!acceptSetters || !PropertyUtilBase.isSimplePropertySetter(method)) && (!acceptGetters || !PropertyUtilBase.isSimplePropertyGetter(method))) continue;
            map.put(PropertyUtilBase.getPropertyName(method), method);
        }
        HashMap<String, PsiMethod> hashMap = map;
        if (hashMap == null) {
            PropertyUtilBase.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    private static boolean filterMethods(PsiMethod method) {
        if (method.hasModifierProperty("static") || !method.hasModifierProperty("public")) {
            return true;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        String className2 = psiClass.getQualifiedName();
        return "java.lang.Object".equals(className2);
    }

    @NotNull
    public static List<PsiMethod> getSetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(4);
        }
        String setterName = PropertyUtilBase.suggestSetterName(propertyName);
        PsiMethod[] psiMethods = psiClass.findMethodsByName(setterName, true);
        ArrayList<PsiMethod> list2 = new ArrayList<PsiMethod>(psiMethods.length);
        for (PsiMethod method : psiMethods) {
            if (PropertyUtilBase.filterMethods(method) || !PropertyUtilBase.isSimplePropertySetter(method)) continue;
            list2.add(method);
        }
        ArrayList<PsiMethod> arrayList = list2;
        if (arrayList == null) {
            PropertyUtilBase.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiMethod> getGetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(6);
        }
        String[] names2 = PropertyUtilBase.suggestGetterNames(propertyName);
        ArrayList<PsiMethod> list2 = new ArrayList<PsiMethod>();
        for (String name : names2) {
            PsiMethod[] psiMethods;
            for (PsiMethod method : psiMethods = psiClass.findMethodsByName(name, true)) {
                if (PropertyUtilBase.filterMethods(method) || !PropertyUtilBase.isSimplePropertyGetter(method)) continue;
                list2.add(method);
            }
        }
        ArrayList<PsiMethod> arrayList = list2;
        if (arrayList == null) {
            PropertyUtilBase.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiMethod> getAccessors(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(8);
        }
        List<PsiMethod> list2 = ContainerUtil.concat(PropertyUtilBase.getGetters(psiClass, propertyName), PropertyUtilBase.getSetters(psiClass, propertyName));
        if (list2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(9);
        }
        return list2;
    }

    public static String @NotNull [] getReadableProperties(@NotNull PsiClass aClass, boolean includeSuperClass) {
        PsiMethod[] methods2;
        if (aClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(10);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (PsiMethod method : methods2 = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods()) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtilBase.isSimplePropertyGetter(method)) continue;
            result2.add(PropertyUtilBase.getPropertyName(method));
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result2);
        if (stringArray == null) {
            PropertyUtilBase.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    public static String @NotNull [] getWritableProperties(@NotNull PsiClass aClass, boolean includeSuperClass) {
        PsiMethod[] methods2;
        if (aClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(12);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (PsiMethod method : methods2 = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods()) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtilBase.isSimplePropertySetter(method)) continue;
            result2.add(PropertyUtilBase.getPropertyName(method));
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result2);
        if (stringArray == null) {
            PropertyUtilBase.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    @Nullable
    public static PsiType getPropertyType(PsiMember member2) {
        if (member2 instanceof PsiField) {
            return ((PsiField)member2).getType();
        }
        if (member2 instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member2;
            if (PropertyUtilBase.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnType();
            }
            if (PropertyUtilBase.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getType();
            }
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        PsiMethod[] methods2;
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(14);
        }
        if (aClass == null) {
            return null;
        }
        String setterName = PropertyUtilBase.suggestSetterName(propertyName);
        for (PsiMethod method : methods2 = aClass.findMethodsByName(setterName, checkSuperClasses)) {
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtilBase.isSimplePropertySetter(method) || !PropertyUtilBase.getPropertyNameBySetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyField(PsiClass aClass, String propertyName, boolean isStatic) {
        PsiField[] fields2;
        for (PsiField field2 : fields2 = aClass.getAllFields()) {
            if (field2.hasModifierProperty("static") != isStatic || !propertyName.equals(PropertyUtilBase.suggestPropertyName(field2))) continue;
            return field2;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        String[] getterCandidateNames;
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(15);
        }
        if (aClass == null) {
            return null;
        }
        for (String getterCandidateName : getterCandidateNames = PropertyUtilBase.suggestGetterNames(propertyName)) {
            PsiMethod[] getterCandidates;
            for (PsiMethod method : getterCandidates = aClass.findMethodsByName(getterCandidateName, checkSuperClasses)) {
                if (method.hasModifierProperty("static") != isStatic || !PropertyUtilBase.isSimplePropertyGetter(method) || !PropertyUtilBase.getPropertyNameByGetter(method).equals(propertyName)) continue;
                return method;
            }
        }
        return null;
    }

    public static PsiMethod findPropertyGetterWithType(@NotNull String propertyName, boolean isStatic, PsiType type2, @NotNull Collection<? extends PsiMethod> methods2) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(16);
        }
        if (methods2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(17);
        }
        return ContainerUtil.find(methods2, method -> method.hasModifierProperty("static") == isStatic && PropertyUtilBase.isSimplePropertyGetter(method) && PropertyUtilBase.getPropertyNameByGetter(method).equals(propertyName) && type2.equals(method.getReturnType()));
    }

    public static boolean isSimplePropertyAccessor(PsiMethod method) {
        return PropertyUtilBase.isSimplePropertyGetter(method) || PropertyUtilBase.isSimplePropertySetter(method);
    }

    public static PsiMethod findPropertySetterWithType(@NotNull String propertyName, boolean isStatic, PsiType type2, @NotNull Collection<? extends PsiMethod> methods2) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(18);
        }
        if (methods2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(19);
        }
        return ContainerUtil.find(methods2, method -> method.hasModifierProperty("static") == isStatic && PropertyUtilBase.isSimplePropertySetter(method) && PropertyUtilBase.getPropertyNameBySetter(method).equals(propertyName) && type2.equals(method.getParameterList().getParameters()[0].getType()));
    }

    @NotNull
    public static GetterFlavour getMethodNameGetterFlavour(@NotNull String methodName) {
        if (methodName == null) {
            PropertyUtilBase.$$$reportNull$$$0(20);
        }
        if (PropertyUtilBase.checkPrefix(methodName, GET_PREFIX)) {
            GetterFlavour getterFlavour = GetterFlavour.GENERIC;
            if (getterFlavour == null) {
                PropertyUtilBase.$$$reportNull$$$0(21);
            }
            return getterFlavour;
        }
        if (PropertyUtilBase.checkPrefix(methodName, IS_PREFIX)) {
            GetterFlavour getterFlavour = GetterFlavour.BOOLEAN;
            if (getterFlavour == null) {
                PropertyUtilBase.$$$reportNull$$$0(22);
            }
            return getterFlavour;
        }
        GetterFlavour getterFlavour = GetterFlavour.NOT_A_GETTER;
        if (getterFlavour == null) {
            PropertyUtilBase.$$$reportNull$$$0(23);
        }
        return getterFlavour;
    }

    @Contract(value="null -> false")
    public static boolean isSimplePropertyGetter(@Nullable PsiMethod method) {
        return PropertyUtilBase.hasGetterName(method) && method.getParameterList().isEmpty();
    }

    public static boolean hasGetterName(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        GetterFlavour flavour = PropertyUtilBase.getMethodNameGetterFlavour(methodName);
        switch (flavour) {
            case GENERIC: {
                PsiType returnType2 = method.getReturnType();
                return !PsiType.VOID.equals(returnType2);
            }
            case BOOLEAN: {
                return PropertyUtilBase.isBoolean(method.getReturnType());
            }
        }
        return false;
    }

    private static boolean isBoolean(@Nullable PsiType propertyType) {
        return PsiType.BOOLEAN.equals(propertyType);
    }

    public static String suggestPropertyName(@NotNull PsiField field2) {
        if (field2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(24);
        }
        return PropertyUtilBase.suggestPropertyName(field2, field2.getName());
    }

    @NotNull
    public static String suggestPropertyName(@NotNull PsiField field2, @NotNull String fieldName) {
        if (field2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(25);
        }
        if (fieldName == null) {
            PropertyUtilBase.$$$reportNull$$$0(26);
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(field2.getProject());
        VariableKind kind = codeStyleManager.getVariableKind(field2);
        String name = codeStyleManager.variableNameToPropertyName(fieldName, kind);
        if (!field2.hasModifierProperty("static") && PropertyUtilBase.isBoolean(field2.getType()) && name.startsWith(IS_PREFIX) && name.length() > IS_PREFIX.length() && Character.isUpperCase(name.charAt(IS_PREFIX.length()))) {
            name = Introspector.decapitalize(name.substring(IS_PREFIX.length()));
        }
        String string2 = name;
        if (string2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(27);
        }
        return string2;
    }

    public static String suggestGetterName(PsiField field2) {
        String propertyName = PropertyUtilBase.suggestPropertyName(field2);
        return PropertyUtilBase.suggestGetterName(propertyName, field2.getType());
    }

    public static String suggestSetterName(PsiField field2) {
        String propertyName = PropertyUtilBase.suggestPropertyName(field2);
        return PropertyUtilBase.suggestSetterName(propertyName);
    }

    @Nullable
    public static String getPropertyName(PsiMember member2) {
        if (member2 instanceof PsiMethod) {
            return PropertyUtilBase.getPropertyName((PsiMethod)member2);
        }
        if (member2 instanceof PsiField) {
            return member2.getName();
        }
        return null;
    }

    public static boolean isSimplePropertySetter(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        if (!PropertyUtilBase.isSetterName(methodName)) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        PsiType returnType2 = method.getReturnType();
        if (returnType2 == null || PsiType.VOID.equals(returnType2)) {
            return true;
        }
        return Comparing.equal(PsiUtil.resolveClassInType(TypeConversionUtil.erasure(returnType2)), method.getContainingClass());
    }

    public static boolean isSetterName(@NotNull String methodName) {
        if (methodName == null) {
            PropertyUtilBase.$$$reportNull$$$0(28);
        }
        return PropertyUtilBase.checkPrefix(methodName, SET_PREFIX);
    }

    @Nullable
    public static String getPropertyName(@NotNull PsiMethod method) {
        if (method == null) {
            PropertyUtilBase.$$$reportNull$$$0(29);
        }
        if (PropertyUtilBase.isSimplePropertyGetter(method)) {
            return PropertyUtilBase.getPropertyNameByGetter(method);
        }
        if (PropertyUtilBase.isSimplePropertySetter(method)) {
            return PropertyUtilBase.getPropertyNameBySetter(method);
        }
        return null;
    }

    @NotNull
    public static String getPropertyNameByGetter(PsiMethod getterMethod) {
        @NonNls String methodName = getterMethod.getName();
        if (methodName.startsWith(GET_PREFIX)) {
            String string2 = StringUtil.decapitalize(methodName.substring(3));
            if (string2 == null) {
                PropertyUtilBase.$$$reportNull$$$0(30);
            }
            return string2;
        }
        if (methodName.startsWith(IS_PREFIX)) {
            String string3 = StringUtil.decapitalize(methodName.substring(2));
            if (string3 == null) {
                PropertyUtilBase.$$$reportNull$$$0(31);
            }
            return string3;
        }
        String string4 = methodName;
        if (string4 == null) {
            PropertyUtilBase.$$$reportNull$$$0(32);
        }
        return string4;
    }

    @NotNull
    public static String getPropertyNameBySetter(@NotNull PsiMethod setterMethod) {
        if (setterMethod == null) {
            PropertyUtilBase.$$$reportNull$$$0(33);
        }
        String methodName = setterMethod.getName();
        String string2 = Introspector.decapitalize(methodName.substring(3));
        if (string2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(34);
        }
        return string2;
    }

    private static boolean checkPrefix(@NotNull String methodName, @NotNull String prefix) {
        if (methodName == null) {
            PropertyUtilBase.$$$reportNull$$$0(35);
        }
        if (prefix == null) {
            PropertyUtilBase.$$$reportNull$$$0(36);
        }
        boolean hasPrefix = methodName.startsWith(prefix) && methodName.length() > prefix.length();
        return hasPrefix && (!Character.isLowerCase(methodName.charAt(prefix.length())) || methodName.length() != prefix.length() + 1 && !Character.isLowerCase(methodName.charAt(prefix.length() + 1)));
    }

    public static @NonNls String @NotNull [] suggestGetterNames(@NotNull String propertyName) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(37);
        }
        String str = StringUtil.capitalizeWithJavaBeanConvention(StringUtil.sanitizeJavaIdentifier(propertyName));
        String[] stringArray = new String[]{IS_PREFIX + str, GET_PREFIX + str};
        if (stringArray == null) {
            PropertyUtilBase.$$$reportNull$$$0(38);
        }
        return stringArray;
    }

    public static String suggestGetterName(@NonNls @NotNull String propertyName, @Nullable PsiType propertyType) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(39);
        }
        return PropertyUtilBase.suggestGetterName(propertyName, propertyType, null);
    }

    public static String suggestGetterName(@NotNull String propertyName, @Nullable PsiType propertyType, @NonNls String existingGetterName) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(40);
        }
        @NonNls StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention(StringUtil.sanitizeJavaIdentifier(propertyName)));
        if (PropertyUtilBase.isBoolean(propertyType)) {
            if (existingGetterName == null || !existingGetterName.startsWith(GET_PREFIX)) {
                name.insert(0, IS_PREFIX);
            } else {
                name.insert(0, GET_PREFIX);
            }
        } else {
            name.insert(0, GET_PREFIX);
        }
        return name.toString();
    }

    public static String suggestSetterName(@NonNls @NotNull String propertyName) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(41);
        }
        return PropertyUtilBase.suggestSetterName(propertyName, SET_PREFIX);
    }

    public static String suggestSetterName(@NonNls @NotNull String propertyName, String setterPrefix) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(42);
        }
        String sanitizeJavaIdentifier = StringUtil.sanitizeJavaIdentifier(propertyName);
        if (StringUtil.isEmpty(setterPrefix)) {
            return sanitizeJavaIdentifier;
        }
        @NonNls StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention(sanitizeJavaIdentifier));
        name.insert(0, setterPrefix);
        return name.toString();
    }

    @NotNull
    public static PsiMethod generateGetterPrototype(@NotNull PsiField field2) {
        if (field2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(43);
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(field2.getProject());
        Project project = field2.getProject();
        String name = field2.getName();
        String getName = PropertyUtilBase.suggestGetterName(field2);
        PsiMethod getMethod = factory2.createMethod(getName, field2.getType());
        PsiUtil.setModifierProperty(getMethod, "public", true);
        if (field2.hasModifierProperty("static")) {
            PsiUtil.setModifierProperty(getMethod, "static", true);
        }
        NullableNotNullManager.getInstance(project).copyNullableOrNotNullAnnotation(field2, getMethod);
        PsiCodeBlock body2 = factory2.createCodeBlockFromText("{\nreturn " + name + ";\n}", null);
        Objects.requireNonNull(getMethod.getBody()).replace(body2);
        PsiMethod psiMethod = getMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(getMethod);
        if (psiMethod == null) {
            PropertyUtilBase.$$$reportNull$$$0(44);
        }
        return psiMethod;
    }

    @NotNull
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field2) {
        if (field2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(45);
        }
        return PropertyUtilBase.generateSetterPrototype(field2, field2.getContainingClass());
    }

    @NotNull
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field2, @NotNull PsiClass containingClass) {
        if (field2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(46);
        }
        if (containingClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(47);
        }
        return PropertyUtilBase.generateSetterPrototype(field2, containingClass, false);
    }

    @NotNull
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field2, @NotNull PsiClass containingClass, boolean returnSelf) {
        if (field2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(48);
        }
        if (containingClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(49);
        }
        Project project = field2.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(field2.getProject());
        String name = field2.getName();
        boolean isStatic = field2.hasModifierProperty("static");
        VariableKind kind = codeStyleManager.getVariableKind(field2);
        String propertyName = codeStyleManager.variableNameToPropertyName(name, kind);
        String setName = PropertyUtilBase.suggestSetterName(field2);
        PsiMethod setMethod = factory2.createMethodFromText(factory2.createMethod(setName, returnSelf ? factory2.createType(containingClass) : PsiType.VOID).getText(), field2);
        String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
        PsiParameter param = factory2.createParameter(parameterName, field2.getType());
        NullableNotNullManager.getInstance(project).copyNullableOrNotNullAnnotation(field2, param);
        setMethod.getParameterList().add(param);
        PsiUtil.setModifierProperty(setMethod, "public", true);
        PsiUtil.setModifierProperty(setMethod, "static", isStatic);
        @NonNls StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        if (name.equals(parameterName)) {
            if (!isStatic) {
                buffer.append("this.");
            } else {
                String className2 = containingClass.getName();
                if (className2 != null) {
                    buffer.append(className2);
                    buffer.append(".");
                }
            }
        }
        buffer.append(name);
        buffer.append("=");
        buffer.append(parameterName);
        buffer.append(";\n");
        if (returnSelf) {
            buffer.append("return this;\n");
        }
        buffer.append("}");
        PsiCodeBlock body2 = factory2.createCodeBlockFromText(buffer.toString(), null);
        Objects.requireNonNull(setMethod.getBody()).replace(body2);
        PsiMethod psiMethod = setMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(setMethod);
        if (psiMethod == null) {
            PropertyUtilBase.$$$reportNull$$$0(50);
        }
        return psiMethod;
    }

    @Nullable
    public static PsiTypeElement getPropertyTypeElement(PsiMember member2) {
        if (member2 instanceof PsiField) {
            return ((PsiField)member2).getTypeElement();
        }
        if (member2 instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member2;
            if (PropertyUtilBase.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnTypeElement();
            }
            if (PropertyUtilBase.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getTypeElement();
            }
        }
        return null;
    }

    @Nullable
    public static PsiIdentifier getPropertyNameIdentifier(PsiMember member2) {
        if (member2 instanceof PsiField) {
            return ((PsiField)member2).getNameIdentifier();
        }
        if (member2 instanceof PsiMethod) {
            return ((PsiMethod)member2).getNameIdentifier();
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyFieldByMember(PsiMember psiMember) {
        if (psiMember instanceof PsiField) {
            return (PsiField)psiMember;
        }
        if (psiMember instanceof PsiMethod) {
            PsiElement resolved;
            PsiExpression target;
            PsiStatement statement2;
            PsiMethod psiMethod = (PsiMethod)psiMember;
            PsiType returnType2 = psiMethod.getReturnType();
            if (returnType2 == null) {
                return null;
            }
            PsiCodeBlock body2 = psiMethod.getBody();
            PsiStatement[] statements2 = body2 == null ? null : body2.getStatements();
            PsiStatement psiStatement = statement2 = statements2 == null || statements2.length != 1 ? null : statements2[0];
            if (PsiType.VOID.equals(returnType2)) {
                PsiExpression expression2 = statement2 instanceof PsiExpressionStatement ? ((PsiExpressionStatement)statement2).getExpression() : null;
                target = expression2 instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)expression2).getLExpression() : null;
            } else {
                target = statement2 instanceof PsiReturnStatement ? ((PsiReturnStatement)statement2).getReturnValue() : null;
            }
            PsiElement psiElement = resolved = target instanceof PsiReferenceExpression ? ((PsiReferenceExpression)target).resolve() : null;
            if (resolved instanceof PsiField) {
                PsiField field2 = (PsiField)resolved;
                PsiClass memberClass = psiMember.getContainingClass();
                PsiClass fieldClass = field2.getContainingClass();
                if (memberClass != null && fieldClass != null && (memberClass == fieldClass || memberClass.isInheritor(fieldClass, true))) {
                    return field2;
                }
            }
        }
        return null;
    }

    public static PsiMethod findSetterForField(PsiField field2) {
        PsiClass containingClass = field2.getContainingClass();
        String propertyName = PropertyUtilBase.suggestPropertyName(field2);
        boolean isStatic = field2.hasModifierProperty("static");
        return PropertyUtilBase.findPropertySetter(containingClass, propertyName, isStatic, true);
    }

    public static PsiMethod findGetterForField(PsiField field2) {
        PsiClass containingClass = field2.getContainingClass();
        String propertyName = PropertyUtilBase.suggestPropertyName(field2);
        boolean isStatic = field2.hasModifierProperty("static");
        return PropertyUtilBase.findPropertyGetter(containingClass, propertyName, isStatic, true);
    }

    @Nullable
    public static PsiExpression getGetterReturnExpression(@Nullable PsiMethod method) {
        return method != null && PropertyUtilBase.hasGetterSignature(method) ? PropertyUtilBase.getSingleReturnValue(method) : null;
    }

    private static boolean hasGetterSignature(@NotNull PsiMethod method) {
        if (method == null) {
            PropertyUtilBase.$$$reportNull$$$0(51);
        }
        return PropertyUtilBase.isSimplePropertyGetter(method);
    }

    @Nullable
    public static PsiExpression getSingleReturnValue(@NotNull PsiMethod method) {
        PsiCodeBlock body2;
        if (method == null) {
            PropertyUtilBase.$$$reportNull$$$0(52);
        }
        if ((body2 = method.getBody()) == null) {
            return null;
        }
        PsiStatement[] statements2 = body2.getStatements();
        PsiStatement statement2 = statements2.length != 1 ? null : statements2[0];
        return statement2 instanceof PsiReturnStatement ? ((PsiReturnStatement)statement2).getReturnValue() : null;
    }

    @Contract(pure=true)
    @Nullable
    public static PropertyKind getPropertyKind(@NotNull String accessorName) {
        if (accessorName == null) {
            PropertyUtilBase.$$$reportNull$$$0(53);
        }
        for (PropertyKind kind : PropertyKind.values()) {
            String prefix = kind.prefix;
            int prefixLength = prefix.length();
            if (!accessorName.startsWith(prefix) || accessorName.length() <= prefixLength) continue;
            return kind;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static Pair<String, PropertyKind> getPropertyNameAndKind(@NotNull String accessorName) {
        PropertyKind kind;
        if (accessorName == null) {
            PropertyUtilBase.$$$reportNull$$$0(54);
        }
        if ((kind = PropertyUtilBase.getPropertyKind(accessorName)) == null) {
            return null;
        }
        String baseName = accessorName.substring(kind.prefix.length());
        String propertyName = Introspector.decapitalize(baseName);
        return Pair.create(propertyName, kind);
    }

    @Contract(pure=true)
    @NotNull
    public static String getAccessorName(@NotNull String propertyName, @NotNull PropertyKind kind) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(55);
        }
        if (kind == null) {
            PropertyUtilBase.$$$reportNull$$$0(56);
        }
        String string2 = kind.prefix + StringUtil.capitalizeWithJavaBeanConvention(propertyName);
        if (string2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(57);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 44: 
            case 50: 
            case 57: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 44: 
            case 50: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 44: 
            case 50: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtilBase";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 24: 
            case 25: 
            case 43: 
            case 45: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 29: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setterMethod";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorName";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtilBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProperties";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGetters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableProperties";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getWritableProperties";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodNameGetterFlavour";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPropertyName";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNameByGetter";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNameBySetter";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestGetterNames";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "generateGetterPrototype";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSetterPrototype";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllProperties";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 44: 
            case 50: 
            case 57: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSetters";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGetters";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAccessors";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReadableProperties";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getWritableProperties";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findPropertySetter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyGetter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyGetterWithType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findPropertySetterWithType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMethodNameGetterFlavour";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "suggestPropertyName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isSetterName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameBySetter";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkPrefix";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "suggestGetterNames";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "suggestGetterName";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "suggestSetterName";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "generateGetterPrototype";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "generateSetterPrototype";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "hasGetterSignature";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getSingleReturnValue";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyKind";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameAndKind";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getAccessorName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 44: 
            case 50: 
            case 57: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum GetterFlavour {
        BOOLEAN,
        GENERIC,
        NOT_A_GETTER;

    }
}

