/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt;
import org.jetbrains.kotlin.backend.wasm.lower.JsInteropFunctionsLoweringKt;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001fH\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0019J\u000e\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0019J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\rH\u0016J\u000e\u0010*\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0019J\u000e\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020\u0007J\u000e\u00100\u001a\u00020$2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020$2\u0006\u00104\u001a\u00020\u0015J.\u00105\u001a\u00020$2\u0006\u00104\u001a\u00020\u00142\u0006\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u00020!2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u001fJ\u0014\u0010;\u001a\u00020$*\u00020<2\u0006\u0010'\u001a\u00020\u0019H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsToTopLevelFunctionsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "addedDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getAddedDeclarations", "()Ljava/util/List;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "currentFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getCurrentFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "setCurrentFile", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "externalFunToTopLevelMapping", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getExternalFunToTopLevelMapping", "()Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "externalObjectToGetInstanceFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getExternalObjectToGetInstanceFunction", "createExternalJsFunction", "originalName", "Lorg/jetbrains/kotlin/name/Name;", "suffix", "", "resultType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "jsCode", "generateExternalObjectInstanceGetter", "", "obj", "generateInstanceCheckForExternalClass", "klass", "lower", "irFile", "lowerExternalClass", "processExternalConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "processExternalDeclaration", "declaration", "processExternalProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "processExternalSimpleFunction", "function", "processFunctionOrConstructor", "name", "returnType", "isConstructor", "", "jsFunctionReference", "appendExternalClassReference", "Ljava/lang/StringBuilder;", "backend.wasm"})
public final class ComplexExternalDeclarationsToTopLevelFunctionsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    public IrFile currentFile;
    @NotNull
    private final List<IrDeclaration> addedDeclarations;
    @NotNull
    private final Mapping.Delegate<IrFunction, IrSimpleFunction> externalFunToTopLevelMapping;
    @NotNull
    private final Mapping.Delegate<IrClass, IrSimpleFunction> externalObjectToGetInstanceFunction;

    public ComplexExternalDeclarationsToTopLevelFunctionsLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.addedDeclarations = new ArrayList();
        this.externalFunToTopLevelMapping = this.context.getMapping().getWasmNestedExternalToNewTopLevelFunction();
        this.externalObjectToGetInstanceFunction = this.context.getMapping().getWasmExternalObjectToGetInstanceFunction();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrFile getCurrentFile() {
        IrFile irFile = this.currentFile;
        if (irFile != null) {
            return irFile;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentFile");
        return null;
    }

    public final void setCurrentFile(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"<set-?>");
        this.currentFile = irFile;
    }

    @NotNull
    public final List<IrDeclaration> getAddedDeclarations() {
        return this.addedDeclarations;
    }

    @NotNull
    public final Mapping.Delegate<IrFunction, IrSimpleFunction> getExternalFunToTopLevelMapping() {
        return this.externalFunToTopLevelMapping;
    }

    @NotNull
    public final Mapping.Delegate<IrClass, IrSimpleFunction> getExternalObjectToGetInstanceFunction() {
        return this.externalObjectToGetInstanceFunction;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.setCurrentFile(irFile);
        for (IrDeclaration declaration2 : irFile.getDeclarations()) {
            if (!IrUtilsKt.isEffectivelyExternal(declaration2)) continue;
            this.processExternalDeclaration(declaration2);
        }
        CollectionsKt.addAll((Collection)irFile.getDeclarations(), (Iterable)this.addedDeclarations);
        this.addedDeclarations.clear();
    }

    public final void processExternalDeclaration(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        IrElementVisitorVoidKt.acceptVoid(declaration2, new IrElementVisitorVoid(this){
            final /* synthetic */ ComplexExternalDeclarationsToTopLevelFunctionsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                throw new IllegalStateException(("Unknown external element " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            }

            public void visitClass(@NotNull IrClass declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                IrElementVisitorVoidKt.acceptChildrenVoid(declaration2, this);
                this.this$0.lowerExternalClass(declaration2);
            }

            public void visitProperty(@NotNull IrProperty declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                this.this$0.processExternalProperty(declaration2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                this.this$0.processExternalConstructor(declaration2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                this.this$0.processExternalSimpleFunction(declaration2);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
            }

            public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
            }

            public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            public void visitCall(@NotNull IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
            }

            public void visitField(@NotNull IrField declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
            }

            public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            public void visitFile(@NotNull IrFile declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
            }

            public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
            }

            public void visitFunction(@NotNull IrFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
            }

            public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
            }

            public void visitScript(@NotNull IrScript declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
            }

            public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
            }

            public void visitVariable(@NotNull IrVariable declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
            }

            public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
            }

            public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
            }
        });
    }

    public final void lowerExternalClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (klass.getKind() == ClassKind.OBJECT) {
            this.generateExternalObjectInstanceGetter(klass);
        }
        if (klass.getKind() != ClassKind.INTERFACE) {
            this.generateInstanceCheckForExternalClass(klass);
        }
    }

    public final void processExternalProperty(@NotNull IrProperty property2) {
        block4: {
            IrSimpleFunction res2;
            String jsCode2;
            IrValueParameter dispatchReceiver;
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            if (property2.isFakeOverride()) {
                return;
            }
            String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(property2).getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"property.getJsNameOrKotlinName().identifier");
            String propName = string2;
            IrSimpleFunction irSimpleFunction = property2.getGetter();
            if (irSimpleFunction != null) {
                IrSimpleFunction getter2 = irSimpleFunction;
                boolean bl = false;
                dispatchReceiver = getter2.getDispatchReceiverParameter();
                jsCode2 = dispatchReceiver == null ? "() => " + propName : "(_this) => _this." + propName;
                res2 = this.createExternalJsFunction(property2.getName(), "_$external_prop_getter", getter2.getReturnType(), jsCode2);
                if (dispatchReceiver != null) {
                    DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "_this", dispatchReceiver.getType(), null, 4, null);
                }
                this.externalFunToTopLevelMapping.set((IrFunction)((IrDeclaration)getter2), res2);
            }
            IrSimpleFunction irSimpleFunction2 = property2.getSetter();
            if (irSimpleFunction2 == null) break block4;
            IrSimpleFunction setter2 = irSimpleFunction2;
            boolean bl = false;
            dispatchReceiver = setter2.getDispatchReceiverParameter();
            jsCode2 = dispatchReceiver == null ? "(v) => " + propName + " = v" : "(_this, v) => _this." + propName + " = v";
            res2 = this.createExternalJsFunction(property2.getName(), "_$external_prop_setter", setter2.getReturnType(), jsCode2);
            if (dispatchReceiver != null) {
                DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "_this", dispatchReceiver.getType(), null, 4, null);
            }
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "v", setter2.getValueParameters().get(0).getType(), null, 4, null);
            this.externalFunToTopLevelMapping.set((IrFunction)((IrDeclaration)setter2), res2);
        }
    }

    private final void appendExternalClassReference(StringBuilder $this$appendExternalClassReference, IrClass klass) {
        IrDeclarationParent parent2 = klass.getParent();
        if (parent2 instanceof IrClass) {
            this.appendExternalClassReference($this$appendExternalClassReference, (IrClass)parent2);
            if (klass.isCompanion()) {
                return;
            }
            $this$appendExternalClassReference.append('.');
        }
        $this$appendExternalClassReference.append(AnnotationUtilsKt.getJsNameOrKotlinName(klass));
    }

    /*
     * WARNING - void declaration
     */
    public final void processExternalConstructor(@NotNull IrConstructor constructor2) {
        void $this$processExternalConstructor_u24lambda_u2d2;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        IrClass klass = AdditionalIrUtilsKt.getConstructedClass(constructor2);
        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
        boolean bl = true;
        IrType irType = IrUtilsKt.getDefaultType(klass);
        Name name = klass.getName();
        IrFunction irFunction2 = constructor2;
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        boolean bl2 = false;
        this.appendExternalClassReference((StringBuilder)$this$processExternalConstructor_u24lambda_u2d2, klass);
        Unit unit2 = Unit.INSTANCE;
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        complexExternalDeclarationsToTopLevelFunctionsLowering2.processFunctionOrConstructor(irFunction2, name, irType, bl, string2);
    }

    /*
     * WARNING - void declaration
     */
    public final void processExternalSimpleFunction(@NotNull IrSimpleFunction function2) {
        String string2;
        boolean bl;
        IrType irType;
        Name name;
        IrFunction irFunction2;
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2;
        block11: {
            block10: {
                void it;
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                String jsFun = AnnotationsKt.getJsFunAnnotation(function2);
                if (jsFun != null) {
                    boolean bl2;
                    block9: {
                        Iterable $this$all$iv = function2.getValueParameters();
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                IrValueParameter it2 = (IrValueParameter)element$iv;
                                boolean bl3 = false;
                                if (it2.getDefaultValue() == null) continue;
                                bl2 = false;
                                break block9;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        return;
                    }
                }
                complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
                irFunction2 = function2;
                name = function2.getName();
                irType = function2.getReturnType();
                bl = false;
                string2 = jsFun;
                if (string2 == null) break block10;
                String string3 = string2;
                boolean bl4 = bl;
                IrType irType2 = irType;
                Name name2 = name;
                IrFunction irFunction3 = irFunction2;
                ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering3 = complexExternalDeclarationsToTopLevelFunctionsLowering2;
                boolean bl5 = false;
                String string4 = '(' + (String)it + ')';
                complexExternalDeclarationsToTopLevelFunctionsLowering2 = complexExternalDeclarationsToTopLevelFunctionsLowering3;
                irFunction2 = irFunction3;
                name = name2;
                irType = irType2;
                bl = bl4;
                String string5 = string4;
                string2 = string5;
                if (string5 != null) break block11;
            }
            String string6 = AnnotationUtilsKt.getJsNameOrKotlinName(function2).getIdentifier();
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"function.getJsNameOrKotlinName().identifier");
        }
        complexExternalDeclarationsToTopLevelFunctionsLowering2.processFunctionOrConstructor(irFunction2, name, irType, bl, string2);
    }

    public final void processFunctionOrConstructor(@NotNull IrFunction function2, @NotNull Name name, @NotNull IrType returnType2, boolean isConstructor, @NotNull String jsFunctionReference) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)returnType2, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)jsFunctionReference, (String)"jsFunctionReference");
        IrValueParameter dispatchReceiver = function2.getDispatchReceiverParameter();
        int numValueParameters = function2.getValueParameters().size();
        int numDefaultParameters = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.access$numDefaultParametersForExternalFunction(function2);
        StringBuilder $this$processFunctionOrConstructor_u24lambda_u2d6 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$processFunctionOrConstructor_u24lambda_u2d6.append("(");
        if (dispatchReceiver != null) {
            $this$processFunctionOrConstructor_u24lambda_u2d6.append("_this, ");
        }
        JsInteropFunctionsLoweringKt.appendParameterList$default($this$processFunctionOrConstructor_u24lambda_u2d6, numValueParameters, null, numDefaultParameters == 0, 2, null);
        JsInteropFunctionsLoweringKt.appendParameterList($this$processFunctionOrConstructor_u24lambda_u2d6, numDefaultParameters, "isDefault", true);
        $this$processFunctionOrConstructor_u24lambda_u2d6.append(") => ");
        if (isConstructor) {
            $this$processFunctionOrConstructor_u24lambda_u2d6.append("new ");
        }
        if (dispatchReceiver != null) {
            $this$processFunctionOrConstructor_u24lambda_u2d6.append("_this.");
        }
        $this$processFunctionOrConstructor_u24lambda_u2d6.append(jsFunctionReference);
        $this$processFunctionOrConstructor_u24lambda_u2d6.append("(");
        JsInteropFunctionsLoweringKt.appendParameterList$default($this$processFunctionOrConstructor_u24lambda_u2d6, numValueParameters - numDefaultParameters, null, numDefaultParameters == 0, 2, null);
        int n = 0;
        while (n < numDefaultParameters) {
            int it = n++;
            boolean bl2 = false;
            $this$processFunctionOrConstructor_u24lambda_u2d6.append("isDefault" + it + " ? undefined : p" + (numValueParameters - numDefaultParameters + it) + ", ");
        }
        $this$processFunctionOrConstructor_u24lambda_u2d6.append(")");
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String jsCode2 = string2;
        IrSimpleFunction res2 = this.createExternalJsFunction(name, "_$external_fun", returnType2, jsCode2);
        if (dispatchReceiver != null) {
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "_this", dispatchReceiver.getType(), null, 4, null);
        }
        Iterable $this$forEach$iv = function2.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl3 = false;
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, it.getName(), it.getType(), null, 4, null);
        }
        int n2 = 0;
        while (n2 < numDefaultParameters) {
            int it = n2++;
            boolean bl4 = false;
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "isDefault" + it, this.context.getIrBuiltIns().getIntType(), null, 4, null);
        }
        this.externalFunToTopLevelMapping.set((IrFunction)((IrDeclaration)function2), res2);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateExternalObjectInstanceGetter(@NotNull IrClass obj) {
        void $this$generateExternalObjectInstanceGetter_u24lambda_u2d9;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
        IrType irType = IrUtilsKt.getDefaultType(obj);
        String string2 = "_$external_object_getInstance";
        Name name = obj.getName();
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        IrDeclaration irDeclaration2 = obj;
        Mapping.Delegate<IrClass, IrSimpleFunction> delegate2 = this.context.getMapping().getWasmExternalObjectToGetInstanceFunction();
        boolean bl = false;
        $this$generateExternalObjectInstanceGetter_u24lambda_u2d9.append("() => ");
        this.appendExternalClassReference((StringBuilder)$this$generateExternalObjectInstanceGetter_u24lambda_u2d9, obj);
        Unit unit2 = Unit.INSTANCE;
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        delegate2.set((IrClass)irDeclaration2, complexExternalDeclarationsToTopLevelFunctionsLowering2.createExternalJsFunction(name, string2, irType, string3));
    }

    /*
     * WARNING - void declaration
     */
    public final void generateInstanceCheckForExternalClass(@NotNull IrClass klass) {
        void it;
        Object $this$generateInstanceCheckForExternalClass_u24lambda_u2d10;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Object object = new StringBuilder();
        StringBuilder stringBuilder2 = object;
        IrType irType = this.context.getIrBuiltIns().getBooleanType();
        String string2 = "_$external_class_instanceof";
        Name name = klass.getName();
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        IrDeclaration irDeclaration2 = klass;
        Mapping.Delegate<IrClass, IrSimpleFunction> delegate2 = this.context.getMapping().getWasmExternalClassToInstanceCheck();
        boolean bl = false;
        ((StringBuilder)$this$generateInstanceCheckForExternalClass_u24lambda_u2d10).append("(x) => x instanceof ");
        this.appendExternalClassReference((StringBuilder)$this$generateInstanceCheckForExternalClass_u24lambda_u2d10, klass);
        Unit unit2 = Unit.INSTANCE;
        String string3 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        $this$generateInstanceCheckForExternalClass_u24lambda_u2d10 = object = complexExternalDeclarationsToTopLevelFunctionsLowering2.createExternalJsFunction(name, string2, irType, string3);
        boolean bl2 = false;
        DeclarationBuildersKt.addValueParameter$default((IrFunction)it, "x", this.context.getIrBuiltIns().getAnyType(), null, 4, null);
        complexExternalDeclarationsToTopLevelFunctionsLowering2 = Unit.INSTANCE;
        delegate2.set((IrClass)irDeclaration2, (IrSimpleFunction)object);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createExternalJsFunction(Name originalName, String suffix, IrType resultType, String jsCode2) {
        void it;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        Object $this$buildFun_u24lambda_u2d16$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createExternalJsFunction_u24lambda_u2d12 = $this$buildFun_u24lambda_u2d16$iv;
        boolean bl2 = false;
        Name name = Name.identifier(originalName.asStringStripSpecialMarkers() + suffix);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(originalName.\u2026pecialMarkers() + suffix)");
        $this$createExternalJsFunction_u24lambda_u2d12.setName(name);
        $this$createExternalJsFunction_u24lambda_u2d12.setReturnType(resultType);
        $this$createExternalJsFunction_u24lambda_u2d12.setExternal(true);
        IrSimpleFunction res2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2d16$iv);
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)res2.getSymbol(), 0, 0, 6, null);
        IrConstructorCall irConstructorCall = ExpressionHelpersKt.irCallConstructor(builder2, this.context.getWasmSymbols().getJsFunConstructor(), CollectionsKt.emptyList());
        $this$buildFun_u24lambda_u2d16$iv = irConstructorCall;
        Collection collection = res2.getAnnotations();
        IrSimpleFunction irSimpleFunction = res2;
        boolean bl3 = false;
        it.putValueArgument(0, ExpressionHelpersKt.irString(builder2, jsCode2));
        Unit unit2 = Unit.INSTANCE;
        irSimpleFunction.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)irConstructorCall));
        res2.setParent(this.getCurrentFile());
        ((Collection)this.addedDeclarations).add(res2);
        return res2;
    }
}

