/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.PartialDirectoryNode;
import org.gradle.internal.snapshot.ReadOnlyFileSystemNode;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.UnknownFileSystemNode;
import org.gradle.internal.snapshot.VfsRelativePath;

public abstract class AbstractIncompleteFileSystemNode
implements FileSystemNode {
    protected final ChildMap<FileSystemNode> children;

    public AbstractIncompleteFileSystemNode(ChildMap<? extends FileSystemNode> children) {
        this.children = children;
    }

    @Override
    public ReadOnlyFileSystemNode getNode(VfsRelativePath targetPath, CaseSensitivity caseSensitivity) {
        return SnapshotUtil.getChild(this.children, targetPath, caseSensitivity);
    }

    @Override
    public Optional<FileSystemNode> invalidate(VfsRelativePath targetPath, final CaseSensitivity caseSensitivity, final SnapshotHierarchy.NodeDiffListener diffListener) {
        ChildMap<FileSystemNode> newChildren = this.children.invalidate(targetPath, caseSensitivity, new ChildMap.InvalidationHandler<FileSystemNode, FileSystemNode>(){

            @Override
            public Optional<FileSystemNode> handleAsDescendantOfChild(VfsRelativePath pathInChild, FileSystemNode child) {
                return child.invalidate(pathInChild, caseSensitivity, diffListener);
            }

            @Override
            public void handleAsAncestorOfChild(String childPath, FileSystemNode child) {
                diffListener.nodeRemoved(child);
            }

            @Override
            public void handleExactMatchWithChild(FileSystemNode child) {
                diffListener.nodeRemoved(child);
            }

            @Override
            public void handleUnrelatedToAnyChild() {
            }
        });
        if (newChildren.isEmpty()) {
            return this.withAllChildrenRemoved();
        }
        if (newChildren == this.children) {
            return Optional.of(this.withIncompleteChildren());
        }
        return Optional.of(this.withIncompleteChildren(newChildren));
    }

    @Override
    public FileSystemNode store(VfsRelativePath targetPath, final CaseSensitivity caseSensitivity, final MetadataSnapshot snapshot, final SnapshotHierarchy.NodeDiffListener diffListener) {
        ChildMap<FileSystemNode> newChildren = this.children.store(targetPath, caseSensitivity, new ChildMap.StoreHandler<FileSystemNode>(){

            @Override
            public FileSystemNode handleAsDescendantOfChild(VfsRelativePath pathInChild, FileSystemNode child) {
                return child.store(pathInChild, caseSensitivity, snapshot, diffListener);
            }

            @Override
            public FileSystemNode handleAsAncestorOfChild(String childPath, FileSystemNode child) {
                FileSystemNode newChild = snapshot.asFileSystemNode();
                diffListener.nodeRemoved(child);
                diffListener.nodeAdded(newChild);
                return newChild;
            }

            @Override
            public FileSystemNode mergeWithExisting(FileSystemNode child) {
                if (snapshot instanceof FileSystemLocationSnapshot || !child.getSnapshot().map(oldSnapshot -> oldSnapshot instanceof FileSystemLocationSnapshot).orElse(false).booleanValue()) {
                    FileSystemNode newChild = snapshot.asFileSystemNode();
                    diffListener.nodeRemoved(child);
                    diffListener.nodeAdded(newChild);
                    return newChild;
                }
                return child;
            }

            @Override
            public FileSystemNode createChild() {
                FileSystemNode newChild = snapshot.asFileSystemNode();
                diffListener.nodeAdded(newChild);
                return newChild;
            }

            @Override
            public FileSystemNode createNodeFromChildren(ChildMap<FileSystemNode> children) {
                boolean isDirectory = AbstractIncompleteFileSystemNode.anyChildMatches(children, node -> node.getSnapshot().map(this::isRegularFileOrDirectory).orElse(false));
                return isDirectory ? new PartialDirectoryNode(children) : new UnknownFileSystemNode(children);
            }

            private boolean isRegularFileOrDirectory(MetadataSnapshot metadataSnapshot) {
                return metadataSnapshot.getType() != FileType.Missing;
            }
        });
        if (newChildren == this.children) {
            return this;
        }
        return this.withIncompleteChildren(newChildren);
    }

    @Override
    public Optional<MetadataSnapshot> getSnapshot(VfsRelativePath targetPath, CaseSensitivity caseSensitivity) {
        return SnapshotUtil.getMetadataFromChildren(this.children, targetPath, caseSensitivity, Optional::empty);
    }

    protected abstract FileSystemNode withIncompleteChildren();

    protected abstract FileSystemNode withIncompleteChildren(ChildMap<? extends FileSystemNode> var1);

    protected abstract Optional<FileSystemNode> withAllChildrenRemoved();

    @Override
    public Stream<FileSystemLocationSnapshot> rootSnapshots() {
        return this.children.stream().map(ChildMap.Entry::getValue).flatMap(ReadOnlyFileSystemNode::rootSnapshots);
    }

    @Override
    public boolean hasDescendants() {
        return AbstractIncompleteFileSystemNode.anyChildMatches(this.children, ReadOnlyFileSystemNode::hasDescendants);
    }

    private static boolean anyChildMatches(ChildMap<FileSystemNode> children, Predicate<FileSystemNode> predicate) {
        return children.stream().map(ChildMap.Entry::getValue).anyMatch(predicate);
    }
}

