/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImplKt;
import org.jetbrains.kotlin.incremental.SerializedJavaClass;
import org.jetbrains.kotlin.metadata.ProtoBuf;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u0006H\u0002J\u0014\u0010\u000e\u001a\u00020\b*\u00020\n2\u0006\u0010\u000f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/JavaClassProtoMapValueExternalizer;", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/incremental/SerializedJavaClass;", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "value", "readBytesWithSize", "", "writeBytesWithSize", "bytes", "kotlin-build-common"})
public final class JavaClassProtoMapValueExternalizer
implements DataExternalizer<SerializedJavaClass> {
    @NotNull
    public static final JavaClassProtoMapValueExternalizer INSTANCE = new JavaClassProtoMapValueExternalizer();

    private JavaClassProtoMapValueExternalizer() {
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull SerializedJavaClass value2) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        byte[] byArray = value2.getProto().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.proto.toByteArray()");
        this.writeBytesWithSize(output, byArray);
        byArray = value2.getStringTable().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.stringTable.toByteArray()");
        this.writeBytesWithSize(output, byArray);
        byArray = value2.getQualifiedNameTable().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.qualifiedNameTable.toByteArray()");
        this.writeBytesWithSize(output, byArray);
    }

    private final void writeBytesWithSize(DataOutput $this$writeBytesWithSize, byte[] bytes) {
        $this$writeBytesWithSize.writeInt(bytes.length);
        $this$writeBytesWithSize.write(bytes);
    }

    private final byte[] readBytesWithSize(DataInput $this$readBytesWithSize) {
        int bytesLength = $this$readBytesWithSize.readInt();
        byte[] byArray = new byte[bytesLength];
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        $this$readBytesWithSize.readFully(it, 0, bytesLength);
        return byArray;
    }

    @Override
    @NotNull
    public SerializedJavaClass read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ProtoBuf.Class proto = ProtoBuf.Class.parseFrom(this.readBytesWithSize(input), JavaClassesTrackerImplKt.getJAVA_CLASS_PROTOBUF_REGISTRY());
        ProtoBuf.StringTable stringTable = ProtoBuf.StringTable.parseFrom(this.readBytesWithSize(input), JavaClassesTrackerImplKt.getJAVA_CLASS_PROTOBUF_REGISTRY());
        ProtoBuf.QualifiedNameTable qualifiedNameTable = ProtoBuf.QualifiedNameTable.parseFrom(this.readBytesWithSize(input), JavaClassesTrackerImplKt.getJAVA_CLASS_PROTOBUF_REGISTRY());
        Intrinsics.checkNotNullExpressionValue((Object)proto, (String)"proto");
        Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"stringTable");
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"qualifiedNameTable");
        return new SerializedJavaClass(proto, stringTable, qualifiedNameTable);
    }
}

