/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;

public class PsiClassReferenceListStubImpl
extends StubBase<PsiReferenceList>
implements PsiClassReferenceListStub {
    private final String[] myNames;
    private volatile PsiClassType[] myTypes;

    public PsiClassReferenceListStubImpl(@NotNull JavaClassReferenceListElementType type2, StubElement parent2, String @NotNull [] names2) {
        if (type2 == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(0);
        }
        if (names2 == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(1);
        }
        super(parent2, type2);
        ObjectUtils.assertAllElementsNotNull(names2);
        this.myNames = names2;
    }

    @Override
    public PsiClassType @NotNull [] getReferencedTypes() {
        PsiClassType[] types2 = this.myTypes;
        if (types2 == null) {
            this.myTypes = types2 = this.createTypes();
        }
        PsiClassType[] psiClassTypeArray = (PsiClassType[])types2.clone();
        if (psiClassTypeArray == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(2);
        }
        return psiClassTypeArray;
    }

    private PsiClassType @NotNull [] createTypes() {
        PsiClassType[] types2 = this.myNames.length == 0 ? PsiClassType.EMPTY_ARRAY : new PsiClassType[this.myNames.length];
        boolean compiled = ((JavaClassReferenceListElementType)this.getStubType()).isCompiled(this);
        if (compiled) {
            for (int i = 0; i < types2.length; ++i) {
                types2[i] = new PsiClassReferenceType(new ClsJavaCodeReferenceElementImpl((PsiElement)this.getPsi(), this.myNames[i]), null);
            }
        } else {
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(this.getProject());
            int nullCount = 0;
            PsiReferenceList psi = (PsiReferenceList)this.getPsi();
            for (int i = 0; i < types2.length; ++i) {
                try {
                    PsiJavaCodeReferenceElement ref = factory2.createReferenceFromText(this.myNames[i], psi);
                    ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(PsiJavaCodeReferenceElementImpl.Kind.CLASS_NAME_KIND);
                    types2[i] = factory2.createType(ref);
                    continue;
                }
                catch (IncorrectOperationException e) {
                    types2[i] = null;
                    ++nullCount;
                }
            }
            if (nullCount > 0) {
                PsiClassType[] newTypes = new PsiClassType[types2.length - nullCount];
                int cnt = 0;
                for (PsiClassType type2 : types2) {
                    if (type2 == null) continue;
                    newTypes[cnt++] = type2;
                }
                types2 = newTypes;
            }
        }
        if (types2 == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(3);
        }
        return types2;
    }

    @Override
    public String @NotNull [] getReferencedNames() {
        String[] stringArray = (String[])this.myNames.clone();
        if (stringArray == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public PsiReferenceList.Role getRole() {
        PsiReferenceList.Role role = JavaClassReferenceListElementType.elementTypeToRole(this.getStubType());
        if (role == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(5);
        }
        return role;
    }

    @Override
    public String toString() {
        return "PsiRefListStub[" + (Object)((Object)this.getRole()) + ':' + String.join((CharSequence)", ", this.myNames) + ']';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

