/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.Permits;
import org.gradle.groovy.scripts.internal.RestrictiveCodeVisitor;
import org.gradle.groovy.scripts.internal.ScriptBlock;

public class PluginUseScriptBlockMetadataCompiler {
    public static final String NEED_SINGLE_BOOLEAN = "argument list must be exactly 1 literal boolean";
    public static final String NEED_LITERAL_STRING = "argument list must be exactly 1 literal String or String with property replacement";
    public static final String NEED_INTERPOLATED_STRING = "argument list must be exactly 1 literal String or String with property replacement";
    public static final String BASE_MESSAGE = "only id(String) method calls allowed in plugins {} script block";
    public static final String EXTENDED_MESSAGE = "only version(String) and apply(boolean) method calls allowed in plugins {} script block";
    public static final String DISALLOWED_ALIAS_NOTATION = "only alias(libs.plugins.someAlias) plugin identifiers where `libs` is a valid version catalog";
    private static final String NOT_LITERAL_METHOD_NAME = "method name must be literal (i.e. not a variable)";
    private static final String NOT_LITERAL_ID_METHOD_NAME = "only id(String) method calls allowed in plugins {} script block - method name must be literal (i.e. not a variable)";
    private final DocumentationRegistry documentationRegistry;
    private final Permits pluginsBlockPermits;

    public PluginUseScriptBlockMetadataCompiler(DocumentationRegistry documentationRegistry, Permits pluginsBlockPermits) {
        this.documentationRegistry = documentationRegistry;
        this.pluginsBlockPermits = pluginsBlockPermits;
    }

    public void compile(SourceUnit sourceUnit, ScriptBlock scriptBlock) {
        ClosureExpression closureArg = scriptBlock.getClosureExpression();
        closureArg.getCode().visit((GroovyCodeVisitor)new RestrictiveCodeVisitor(sourceUnit, this.formatErrorMessage(BASE_MESSAGE)){

            public void visitBlockStatement(BlockStatement block) {
                for (Statement statement : block.getStatements()) {
                    statement.visit((GroovyCodeVisitor)this);
                }
            }

            public void visitMethodCallExpression(MethodCallExpression call) {
                block27: {
                    block25: {
                        ConstantExpression methodName;
                        block26: {
                            String methodNameText;
                            if (!call.isImplicitThis()) {
                                Expression target = call.getObjectExpression();
                                if (!(target instanceof MethodCallExpression)) {
                                    this.restrict((ASTNode)target, PluginUseScriptBlockMetadataCompiler.this.formatErrorMessage(PluginUseScriptBlockMetadataCompiler.BASE_MESSAGE));
                                    return;
                                }
                                this.visitMethodCallExpression((MethodCallExpression)target);
                            }
                            if (!(call.getMethod() instanceof ConstantExpression)) break block25;
                            methodName = (ConstantExpression)call.getMethod();
                            if (!AstUtils.isOfType((ConstantExpression)methodName, String.class)) break block26;
                            switch (methodNameText = methodName.getText()) {
                                case "alias": {
                                    PropertyExpression fullExpression = AstUtils.hasSinglePropertyExpressionArgument((MethodCallExpression)call);
                                    if (fullExpression != null) {
                                        String fullExpressionText = fullExpression.getText();
                                        if (PluginUseScriptBlockMetadataCompiler.this.pluginsBlockPermits.getAllowedExtensions().stream().anyMatch(ext -> fullExpressionText.startsWith(ext + ".plugins."))) {
                                            return;
                                        }
                                    }
                                    this.restrict((ASTNode)call, PluginUseScriptBlockMetadataCompiler.this.formatErrorMessage(PluginUseScriptBlockMetadataCompiler.DISALLOWED_ALIAS_NOTATION));
                                    return;
                                }
                                case "id": {
                                    ConstantExpression argumentExpression = AstUtils.hasSingleConstantArgOfType((MethodCallExpression)call, String.class);
                                    if (argumentExpression == null) {
                                        this.restrict((ASTNode)call, PluginUseScriptBlockMetadataCompiler.this.formatErrorMessage("argument list must be exactly 1 literal String or String with property replacement"));
                                        return;
                                    }
                                    if (!call.isImplicitThis()) {
                                        this.restrict((ASTNode)call, PluginUseScriptBlockMetadataCompiler.this.formatErrorMessage(PluginUseScriptBlockMetadataCompiler.BASE_MESSAGE));
                                        break;
                                    }
                                    ConstantExpression lineNumberExpression = new ConstantExpression((Object)call.getLineNumber(), true);
                                    call.setArguments((Expression)new ArgumentListExpression((Expression)argumentExpression, (Expression)lineNumberExpression));
                                    break;
                                }
                                case "version": {
                                    PropertyExpression fullExpression = AstUtils.hasSinglePropertyExpressionArgument((MethodCallExpression)call);
                                    if (fullExpression != null) {
                                        String fullExpressionText = fullExpression.getText();
                                        if (PluginUseScriptBlockMetadataCompiler.this.pluginsBlockPermits.getAllowedExtensions().stream().anyMatch(ext -> fullExpressionText.startsWith(ext + ".versions."))) {
                                            return;
                                        }
                                    }
                                    if (!PluginUseScriptBlockMetadataCompiler.hasSimpleInterpolatedStringType(call)) {
                                        this.restrict((ASTNode)call, PluginUseScriptBlockMetadataCompiler.this.formatErrorMessage("argument list must be exactly 1 literal String or String with property replacement"));
                                        return;
                                    }
                                    if (call.isImplicitThis()) {
                                        this.restrict((ASTNode)call, PluginUseScriptBlockMetadataCompiler.this.formatErrorMessage(PluginUseScriptBlockMetadataCompiler.BASE_MESSAGE));
                                        break;
                                    }
                                    break block27;
                                }
                                case "apply": {
                                    ConstantExpression arguments = AstUtils.hasSingleConstantArgOfType((MethodCallExpression)call, Boolean.TYPE);
                                    if (arguments == null) {
                                        this.restrict((ASTNode)call, PluginUseScriptBlockMetadataCompiler.this.formatErrorMessage(PluginUseScriptBlockMetadataCompiler.NEED_SINGLE_BOOLEAN));
                                        break;
                                    }
                                    if (call.isImplicitThis()) {
                                        this.restrict((ASTNode)call, PluginUseScriptBlockMetadataCompiler.this.formatErrorMessage(PluginUseScriptBlockMetadataCompiler.BASE_MESSAGE));
                                        break;
                                    }
                                    break block27;
                                }
                                default: {
                                    if (!call.isImplicitThis()) {
                                        this.restrict((ASTNode)methodName, PluginUseScriptBlockMetadataCompiler.this.formatErrorMessage(PluginUseScriptBlockMetadataCompiler.EXTENDED_MESSAGE));
                                        break;
                                    }
                                    this.restrict((ASTNode)methodName, PluginUseScriptBlockMetadataCompiler.this.formatErrorMessage(PluginUseScriptBlockMetadataCompiler.BASE_MESSAGE));
                                    break;
                                }
                            }
                            break block27;
                        }
                        this.restrict((ASTNode)methodName, PluginUseScriptBlockMetadataCompiler.this.formatErrorMessage(PluginUseScriptBlockMetadataCompiler.NOT_LITERAL_ID_METHOD_NAME));
                        break block27;
                    }
                    this.restrict((ASTNode)call);
                }
            }

            public void visitExpressionStatement(ExpressionStatement statement) {
                statement.getExpression().visit((GroovyCodeVisitor)this);
            }
        });
    }

    private static boolean hasSimpleInterpolatedStringType(MethodCallExpression call) {
        Expression argumentExpression;
        if (AstUtils.hasSingleConstantArgOfType((MethodCallExpression)call, String.class) != null) {
            return true;
        }
        ArgumentListExpression argumentList = (ArgumentListExpression)call.getArguments();
        if (argumentList.getExpressions().size() == 1 && (argumentExpression = (Expression)argumentList.getExpressions().get(0)) instanceof GStringExpression) {
            GStringExpression gStringExpression = (GStringExpression)argumentExpression;
            for (Expression value : gStringExpression.getValues()) {
                if (value instanceof VariableExpression) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String formatErrorMessage(String message) {
        return String.format("%s%n%nSee %s for information on the plugins {} block%n%n", message, this.documentationRegistry.getDocumentationFor("plugins", "sec:plugins_block"));
    }
}

