/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.LinkedList;
import java.util.List;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.internal.Factory;
import org.gradle.plugin.use.resolve.internal.ArtifactRepositoriesPluginResolver;
import org.gradle.plugin.use.resolve.internal.CompositePluginResolver;
import org.gradle.plugin.use.resolve.internal.CorePluginResolver;
import org.gradle.plugin.use.resolve.internal.NoopPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolverContributor;
import org.gradle.plugin.use.resolve.service.internal.ClientInjectedClasspathPluginResolver;

public class PluginResolverFactory
implements Factory<PluginResolver> {
    private final PluginRegistry pluginRegistry;
    private final DocumentationRegistry documentationRegistry;
    private final ClientInjectedClasspathPluginResolver injectedClasspathPluginResolver;
    private final DependencyResolutionServices dependencyResolutionServices;
    private final List<PluginResolverContributor> pluginResolverContributors;
    private final VersionSelectorScheme versionSelectorScheme;

    public PluginResolverFactory(PluginRegistry pluginRegistry, DocumentationRegistry documentationRegistry, ClientInjectedClasspathPluginResolver injectedClasspathPluginResolver, DependencyResolutionServices dependencyResolutionServices, List<PluginResolverContributor> pluginResolverContributors, VersionSelectorScheme versionSelectorScheme) {
        this.pluginRegistry = pluginRegistry;
        this.documentationRegistry = documentationRegistry;
        this.injectedClasspathPluginResolver = injectedClasspathPluginResolver;
        this.dependencyResolutionServices = dependencyResolutionServices;
        this.pluginResolverContributors = pluginResolverContributors;
        this.versionSelectorScheme = versionSelectorScheme;
    }

    public PluginResolver create() {
        return new CompositePluginResolver(this.createDefaultResolvers());
    }

    private List<PluginResolver> createDefaultResolvers() {
        LinkedList<PluginResolver> resolvers = new LinkedList<PluginResolver>();
        this.addDefaultResolvers(resolvers);
        return resolvers;
    }

    private void addDefaultResolvers(List<PluginResolver> resolvers) {
        resolvers.add(new NoopPluginResolver(this.pluginRegistry));
        resolvers.add(new CorePluginResolver(this.documentationRegistry, this.pluginRegistry));
        this.injectedClasspathPluginResolver.collectResolversInto(resolvers);
        this.pluginResolverContributors.forEach(contributor -> contributor.collectResolversInto(resolvers));
        resolvers.add(ArtifactRepositoriesPluginResolver.createWithDefaults(this.dependencyResolutionServices, this.versionSelectorScheme));
    }
}

