/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Predicate;
import net.rubygrapefruit.platform.file.FileWatchEvent;
import net.rubygrapefruit.platform.file.FileWatcher;
import net.rubygrapefruit.platform.internal.jni.AbstractFileEventFunctions;
import org.gradle.internal.watch.registry.FileWatcherRegistry;
import org.gradle.internal.watch.registry.FileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.DefaultFileWatcherRegistry;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;
import org.gradle.internal.watch.vfs.WatchableFileSystemDetector;

public abstract class AbstractFileWatcherRegistryFactory<T extends AbstractFileEventFunctions<W>, W extends FileWatcher>
implements FileWatcherRegistryFactory {
    private static final int FILE_EVENT_QUEUE_SIZE = 4096;
    protected final T fileEventFunctions;
    private final WatchableFileSystemDetector watchableFileSystemDetector;
    private final Predicate<String> watchFilter;

    public AbstractFileWatcherRegistryFactory(T fileEventFunctions, WatchableFileSystemDetector watchableFileSystemDetector, Predicate<String> watchFilter) {
        this.fileEventFunctions = fileEventFunctions;
        this.watchableFileSystemDetector = watchableFileSystemDetector;
        this.watchFilter = watchFilter;
    }

    @Override
    public FileWatcherRegistry createFileWatcherRegistry(FileWatcherRegistry.ChangeHandler handler) {
        ArrayBlockingQueue<FileWatchEvent> fileEvents = new ArrayBlockingQueue<FileWatchEvent>(4096);
        try {
            W watcher = this.createFileWatcher(fileEvents);
            WatchableHierarchies watchableHierarchies = new WatchableHierarchies(this.watchableFileSystemDetector, this.watchFilter);
            FileWatcherUpdater fileWatcherUpdater = this.createFileWatcherUpdater(watcher, watchableHierarchies);
            return new DefaultFileWatcherRegistry((AbstractFileEventFunctions<?>)this.fileEventFunctions, (FileWatcher)watcher, handler, fileWatcherUpdater, (BlockingQueue<FileWatchEvent>)fileEvents);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected abstract W createFileWatcher(BlockingQueue<FileWatchEvent> var1) throws InterruptedException;

    protected abstract FileWatcherUpdater createFileWatcherUpdater(W var1, WatchableHierarchies var2);
}

