/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resources.ProjectLeaseRegistry;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.provider.action.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.runner.AbstractClientProvidedBuildActionRunner;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;

public class ClientProvidedBuildActionRunner
extends AbstractClientProvidedBuildActionRunner
implements BuildActionRunner {
    private final PayloadSerializer payloadSerializer;

    public ClientProvidedBuildActionRunner(BuildCancellationToken buildCancellationToken, BuildOperationExecutor buildOperationExecutor, ProjectLeaseRegistry projectLeaseRegistry, PayloadSerializer payloadSerializer) {
        super(buildCancellationToken, buildOperationExecutor, projectLeaseRegistry);
        this.payloadSerializer = payloadSerializer;
    }

    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        if (!(action instanceof ClientProvidedBuildAction)) {
            return BuildActionRunner.Result.nothing();
        }
        ClientProvidedBuildAction clientProvidedBuildAction = (ClientProvidedBuildAction)action;
        Object clientAction = this.payloadSerializer.deserialize(clientProvidedBuildAction.getAction());
        return this.runClientAction(new ClientActionImpl(clientAction, action), buildController);
    }

    private static class ClientActionImpl
    implements AbstractClientProvidedBuildActionRunner.ClientAction {
        private final Object clientAction;
        private final BuildAction action;
        Object result;

        public ClientActionImpl(Object clientAction, BuildAction action) {
            this.clientAction = clientAction;
            this.action = action;
        }

        @Override
        public Object getProjectsEvaluatedAction() {
            return null;
        }

        @Override
        public Object getBuildFinishedAction() {
            return this.clientAction;
        }

        @Override
        public void collectActionResult(Object result, PhasedActionResult.Phase phase) {
            this.result = result;
        }

        @Override
        public boolean isRunTasks() {
            return this.action.isRunTasks();
        }

        @Override
        public Object getResult() {
            return this.result;
        }
    }
}

