/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.reflect.ProblemRecordingTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.plugin.use.PluginId;

public class DefaultWorkValidationContext
implements WorkValidationContext {
    private final Set<Class<?>> types = new HashSet();
    private final ImmutableList.Builder<TypeValidationProblem> problems = ImmutableList.builder();
    private final DocumentationRegistry documentationRegistry;
    private final WorkValidationContext.TypeOriginInspector typeOriginInspector;

    public DefaultWorkValidationContext(DocumentationRegistry documentationRegistry, WorkValidationContext.TypeOriginInspector typeOriginInspector) {
        this.documentationRegistry = documentationRegistry;
        this.typeOriginInspector = typeOriginInspector;
    }

    @Override
    public TypeValidationContext forType(Class<?> type, final boolean cacheable) {
        this.types.add(type);
        Optional<PluginId> pluginId = this.typeOriginInspector.findPluginDefining(type);
        return new ProblemRecordingTypeValidationContext(this.documentationRegistry, type, pluginId.orElse(null)){

            protected void recordProblem(TypeValidationProblem problem) {
                boolean cacheableProblemOnly = problem.isCacheabilityProblemOnly();
                if (cacheableProblemOnly && !cacheable) {
                    return;
                }
                DefaultWorkValidationContext.this.problems.add((Object)problem);
            }
        };
    }

    @Override
    public List<TypeValidationProblem> getProblems() {
        return this.problems.build();
    }

    public ImmutableSortedSet<Class<?>> getValidatedTypes() {
        return ImmutableSortedSet.copyOf(Comparator.comparing(Class::getName), this.types);
    }
}

