/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.tasks.TaskReference;
import org.gradle.composite.internal.AbstractCompositeParticipantBuildState;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.NestedBuildState;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;

public class DefaultIncludedBuild
extends AbstractCompositeParticipantBuildState
implements IncludedBuildState,
IncludedBuild,
Stoppable {
    private final BuildIdentifier buildIdentifier;
    private final Path identityPath;
    private final BuildDefinition buildDefinition;
    private final boolean isImplicit;
    private final BuildState owner;
    private final WorkerLeaseRegistry.WorkerLease parentLease;
    private final GradleLauncher gradleLauncher;

    public DefaultIncludedBuild(BuildIdentifier buildIdentifier, Path identityPath, BuildDefinition buildDefinition, boolean isImplicit, BuildState owner, WorkerLeaseRegistry.WorkerLease parentLease) {
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.buildDefinition = buildDefinition;
        this.isImplicit = isImplicit;
        this.owner = owner;
        this.parentLease = parentLease;
        this.gradleLauncher = this.createGradleLauncher();
    }

    protected GradleLauncher createGradleLauncher() {
        return this.owner.getNestedBuildFactory().nestedInstance(this.buildDefinition.newInstance(), (NestedBuildState)this);
    }

    protected BuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    protected BuildState getOwner() {
        return this.owner;
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public File getRootDirectory() {
        return this.buildDefinition.getBuildRootDir();
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public boolean isImplicitBuild() {
        return this.isImplicit;
    }

    public IncludedBuild getModel() {
        return this;
    }

    public boolean isPluginBuild() {
        return this.buildDefinition.isPluginBuild();
    }

    public File getProjectDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    public TaskReference task(String path) {
        Preconditions.checkArgument((boolean)path.startsWith(":"), (String)"Task path '%s' is not a qualified task path (e.g. ':task' or ':project:task').", (Object)path);
        return new IncludedBuildTaskReference(this, path);
    }

    public String getName() {
        return this.identityPath.getName();
    }

    public NestedBuildFactory getNestedBuildFactory() {
        return this.gradleService(NestedBuildFactory.class);
    }

    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
        if (this.isImplicit) {
            super.assertCanAdd(includedBuildSpec);
        }
    }

    public File getBuildRootDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildIdentifier.getName());
    }

    public Path getIdentityPathForProject(Path projectPath) {
        return this.getIdentityPath().append(projectPath);
    }

    public Action<? super DependencySubstitutions> getRegisteredDependencySubstitutions() {
        return this.buildDefinition.getDependencySubstitutions();
    }

    public boolean hasInjectedSettingsPlugins() {
        return !this.buildDefinition.getInjectedPluginRequests().isEmpty();
    }

    public SettingsInternal loadSettings() {
        return this.gradleLauncher.getLoadedSettings();
    }

    public SettingsInternal getLoadedSettings() {
        return this.getGradle().getSettings();
    }

    public GradleInternal getConfiguredBuild() {
        return this.gradleLauncher.getConfiguredBuild();
    }

    public GradleInternal getBuild() {
        return this.getConfiguredBuild();
    }

    public <T> T withState(Transformer<T, ? super GradleInternal> action) {
        return (T)action.transform((Object)this.getGradle());
    }

    public void finishBuild() {
        this.gradleLauncher.finishBuild();
    }

    public synchronized void addTasks(Iterable<String> taskPaths) {
        this.scheduleTasks(taskPaths);
    }

    public synchronized void execute(Iterable<String> tasks, Object listener) {
        this.gradleLauncher.addListener(listener);
        this.scheduleTasks(tasks);
        WorkerLeaseService workerLeaseService = this.gradleService(WorkerLeaseService.class);
        workerLeaseService.withSharedLease(this.parentLease, () -> ((GradleLauncher)this.gradleLauncher).executeTasks());
    }

    public void stop() {
        this.gradleLauncher.stop();
    }

    protected void scheduleTasks(Iterable<String> tasks) {
        this.gradleLauncher.scheduleTasks(tasks);
    }

    protected final GradleLauncher getGradleLauncher() {
        return this.gradleLauncher;
    }

    protected GradleInternal getGradle() {
        return this.gradleLauncher.getGradle();
    }

    private <T> T gradleService(Class<T> serviceType) {
        return (T)this.getGradle().getServices().get(serviceType);
    }
}

