/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.routes.RoutesSourceSet;
import org.gradle.language.scala.ScalaLanguageSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.internal.ScalaSourceCode;
import org.gradle.play.tasks.RoutesCompile;

@Incubating
@Deprecated
public class PlayRoutesPlugin
extends RuleSource {
    @ComponentType
    void registerRoutesLanguageType(TypeBuilder<RoutesSourceSet> builder) {
        DeprecationLogger.deprecatePlugin((String)"Play Routes").replaceWithExternalPlugin("org.gradle.playframework-routes").willBeRemovedInGradle7().withUserManual("play_plugin").nagUser();
    }

    @Mutate
    void createGeneratedScalaSourceSets(@Path(value="binaries") ModelMap<PlayApplicationBinarySpecInternal> binaries, final ObjectFactory objectFactory) {
        binaries.all((Action)new Action<PlayApplicationBinarySpecInternal>(){

            public void execute(PlayApplicationBinarySpecInternal playApplicationBinarySpec) {
                for (LanguageSourceSet languageSourceSet : playApplicationBinarySpec.getInputs().withType(RoutesSourceSet.class)) {
                    playApplicationBinarySpec.addGeneratedScala(languageSourceSet, objectFactory);
                }
            }
        });
    }

    @Mutate
    void registerLanguageTransform(LanguageTransformContainer languages) {
        languages.add((Object)new Routes());
    }

    private static class Routes
    implements LanguageTransform<RoutesSourceSet, ScalaSourceCode> {
        private Routes() {
        }

        public String getLanguageName() {
            return "routes";
        }

        public Class<RoutesSourceSet> getSourceSetType() {
            return RoutesSourceSet.class;
        }

        public Class<ScalaSourceCode> getOutputType() {
            return ScalaSourceCode.class;
        }

        public Map<String, Class<?>> getBinaryTools() {
            return Collections.emptyMap();
        }

        public SourceTransformTaskConfig getTransformTask() {
            return new SourceTransformTaskConfig(){

                public String getTaskPrefix() {
                    return "compile";
                }

                public Class<? extends DefaultTask> getTaskType() {
                    return RoutesCompile.class;
                }

                public void configureTask(Task task, BinarySpec binarySpec, LanguageSourceSet sourceSet, ServiceRegistry serviceRegistry) {
                    PlayApplicationBinarySpecInternal binary = (PlayApplicationBinarySpecInternal)binarySpec;
                    RoutesSourceSet routesSourceSet = (RoutesSourceSet)sourceSet;
                    RoutesCompile routesCompile = (RoutesCompile)task;
                    ScalaLanguageSourceSet routesScalaSources = binary.getGeneratedScala().get(routesSourceSet);
                    File generatedSourceDir = binary.getNamingScheme().getOutputDirectory(task.getProject().getBuildDir(), "src");
                    File routesCompileOutputDirectory = new File(generatedSourceDir, routesScalaSources.getName());
                    routesCompile.setDescription("Generates routes for the '" + routesSourceSet.getName() + "' source set.");
                    routesCompile.setPlatform(binary.getTargetPlatform());
                    routesCompile.setAdditionalImports(new ArrayList<String>());
                    routesCompile.setSource((FileTree)routesSourceSet.getSource());
                    routesCompile.setOutputDirectory(routesCompileOutputDirectory);
                    routesCompile.setInjectedRoutesGenerator(binary.getApplication().getInjectedRoutesGenerator());
                    routesScalaSources.getSource().srcDir((Object)routesCompileOutputDirectory);
                    routesScalaSources.builtBy(new Object[]{routesCompile});
                }
            };
        }

        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof PlayApplicationBinarySpecInternal;
        }
    }
}

