/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import gnu.trove.TObjectHashingStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.psi.EmptySubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeMapper;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.UnmodifiableHashMap;

public class PsiSubstitutorImpl
implements PsiSubstitutor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiSubstitutorImpl");
    private static final TObjectHashingStrategy<PsiTypeParameter> PSI_EQUIVALENCE = new TObjectHashingStrategy<PsiTypeParameter>(){

        public int computeHashCode(PsiTypeParameter parameter) {
            return Comparing.hashcode(parameter.getName());
        }

        public boolean equals(PsiTypeParameter element1, PsiTypeParameter element2) {
            return element1.getManager().areElementsEquivalent(element1, element2);
        }
    };
    private static final UnmodifiableHashMap<PsiTypeParameter, PsiType> EMPTY_MAP = UnmodifiableHashMap.empty(PSI_EQUIVALENCE);
    private final UnmodifiableHashMap<PsiTypeParameter, PsiType> mySubstitutionMap;
    private final SubstitutionVisitor mySimpleSubstitutionVisitor;

    PsiSubstitutorImpl(@NotNull Map<PsiTypeParameter, PsiType> map2) {
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(0);
        }
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = UnmodifiableHashMap.fromMap(PSI_EQUIVALENCE, map2);
    }

    private PsiSubstitutorImpl(@NotNull UnmodifiableHashMap<PsiTypeParameter, PsiType> map2, @NotNull PsiTypeParameter additionalKey, @Nullable PsiType additionalValue) {
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(1);
        }
        if (additionalKey == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(2);
        }
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = map2.with(additionalKey, additionalValue);
    }

    PsiSubstitutorImpl(@NotNull PsiTypeParameter typeParameter, PsiType mapping2) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(3);
        }
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = EMPTY_MAP.with(typeParameter, mapping2);
    }

    PsiSubstitutorImpl(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(4);
        }
        this(PsiSubstitutorImpl.putAllInternal(EMPTY_MAP, parentClass, mappings));
    }

    @Override
    public PsiType substitute(@NotNull PsiTypeParameter typeParameter) {
        PsiType type2;
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(5);
        }
        return PsiType.VOID.equals(type2 = this.getFromMap(typeParameter)) ? JavaPsiFacade.getElementFactory(typeParameter.getProject()).createType(typeParameter) : type2;
    }

    private PsiType getFromMap(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(6);
        }
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.getOrDefault(typeParameter, PsiType.VOID);
    }

    @Override
    public PsiType substitute(PsiType type2) {
        if (type2 == null) {
            return null;
        }
        PsiUtil.ensureValidType(type2);
        PsiType substituted = type2.accept(this.mySimpleSubstitutionVisitor);
        return this.correctExternalSubstitution(substituted, type2);
    }

    @Override
    public PsiType substituteWithBoundsPromotion(@NotNull PsiTypeParameter typeParameter) {
        PsiType substituted;
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(7);
        }
        if ((substituted = this.substitute(typeParameter)) instanceof PsiWildcardType && !((PsiWildcardType)substituted).isSuper()) {
            PsiWildcardType wildcard;
            PsiWildcardType wildcardType = (PsiWildcardType)substituted;
            PsiType glb = PsiCapturedWildcardType.captureUpperBound(typeParameter, wildcardType, this);
            if (glb instanceof PsiWildcardType) {
                return glb;
            }
            if (glb instanceof PsiCapturedWildcardType && !(wildcard = ((PsiCapturedWildcardType)glb).getWildcard()).isSuper()) {
                return wildcard;
            }
            if (glb != null) {
                return PsiWildcardType.createExtends(typeParameter.getManager(), glb);
            }
        }
        return substituted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof PsiSubstitutorImpl && Objects.equals(this.mySubstitutionMap, ((PsiSubstitutorImpl)o).mySubstitutionMap);
    }

    public int hashCode() {
        return this.mySubstitutionMap != null ? this.mySubstitutionMap.hashCode() : 0;
    }

    private PsiType rawTypeForTypeParameter(@NotNull PsiTypeParameter typeParameter) {
        PsiClassType[] extendsTypes;
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(8);
        }
        if ((extendsTypes = typeParameter.getExtendsListTypes()).length > 0) {
            return RecursionManager.doPreventingRecursion(extendsTypes[0], true, () -> this.substitute(extendsTypes[0]));
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    @NotNull
    private static TypeAnnotationProvider getMergedProvider(@NotNull PsiType type1, @NotNull PsiType type2) {
        if (type1 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(9);
        }
        if (type2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(10);
        }
        if (type1.getAnnotationProvider() == TypeAnnotationProvider.EMPTY && !(type1 instanceof PsiClassReferenceType)) {
            TypeAnnotationProvider typeAnnotationProvider = type2.getAnnotationProvider();
            if (typeAnnotationProvider == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(11);
            }
            return typeAnnotationProvider;
        }
        if (type2.getAnnotationProvider() == TypeAnnotationProvider.EMPTY && !(type2 instanceof PsiClassReferenceType)) {
            TypeAnnotationProvider typeAnnotationProvider = type1.getAnnotationProvider();
            if (typeAnnotationProvider == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(12);
            }
            return typeAnnotationProvider;
        }
        TypeAnnotationProvider typeAnnotationProvider = () -> ArrayUtil.mergeArrays(type1.getAnnotations(), type2.getAnnotations());
        if (typeAnnotationProvider == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(13);
        }
        return typeAnnotationProvider;
    }

    private PsiType correctExternalSubstitution(PsiType substituted, @NotNull PsiType original) {
        if (original == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(14);
        }
        if (substituted != null) {
            return substituted;
        }
        return original.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            public PsiType visitArrayType(PsiArrayType arrayType) {
                return new PsiArrayType(arrayType.getComponentType().accept(this));
            }

            @Override
            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                return new PsiEllipsisType(ellipsisType.getComponentType().accept(this));
            }

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                PsiClass aClass2 = classType.resolve();
                if (aClass2 == null) {
                    return classType;
                }
                if (aClass2 instanceof PsiTypeParameter) {
                    return PsiSubstitutorImpl.this.rawTypeForTypeParameter((PsiTypeParameter)aClass2);
                }
                return JavaPsiFacade.getElementFactory(aClass2.getProject()).createType(aClass2);
            }

            @Override
            public PsiType visitType(PsiType type2) {
                return null;
            }
        });
    }

    protected PsiSubstitutorImpl clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiSubstitutor put(@NotNull PsiTypeParameter typeParameter, PsiType mapping2) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(15);
        }
        if (mapping2 != null && !mapping2.isValid()) {
            LOG.error("Invalid type in substitutor: " + mapping2 + "; " + mapping2.getClass());
        }
        return new PsiSubstitutorImpl(this.mySubstitutionMap, typeParameter, mapping2);
    }

    private static UnmodifiableHashMap<PsiTypeParameter, PsiType> putAllInternal(UnmodifiableHashMap<PsiTypeParameter, PsiType> originalMap, @NotNull PsiClass parentClass, PsiType[] mappings) {
        PsiTypeParameter[] params;
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(16);
        }
        if ((params = parentClass.getTypeParameters()).length == 0) {
            return originalMap;
        }
        UnmodifiableHashMap<PsiTypeParameter, PsiType> newMap2 = originalMap;
        for (int i = 0; i < params.length; ++i) {
            PsiTypeParameter param = params[i];
            assert (param != null);
            if (mappings != null && mappings.length > i) {
                PsiType mapping2 = mappings[i];
                newMap2 = newMap2.with(param, mapping2);
                if (mapping2 == null || mapping2.isValid()) continue;
                LOG.error("Invalid type in substitutor: " + mapping2);
                continue;
            }
            newMap2 = newMap2.with(param, null);
        }
        return newMap2;
    }

    @Override
    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(17);
        }
        return new PsiSubstitutorImpl(PsiSubstitutorImpl.putAllInternal(this.mySubstitutionMap, parentClass, mappings));
    }

    @Override
    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiSubstitutor another) {
        if (another == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(18);
        }
        if (another instanceof EmptySubstitutor) {
            PsiSubstitutorImpl psiSubstitutorImpl = this;
            if (psiSubstitutorImpl == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(19);
            }
            return psiSubstitutorImpl;
        }
        PsiSubstitutorImpl anotherImpl = (PsiSubstitutorImpl)another;
        PsiSubstitutor psiSubstitutor = this.putAll(anotherImpl.mySubstitutionMap);
        if (psiSubstitutor == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(20);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor putAll(@NotNull Map<PsiTypeParameter, PsiType> map2) {
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(21);
        }
        if (map2.isEmpty()) {
            PsiSubstitutorImpl psiSubstitutorImpl = this;
            if (psiSubstitutorImpl == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(22);
            }
            return psiSubstitutorImpl;
        }
        return new PsiSubstitutorImpl(this.mySubstitutionMap.withAll(map2));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<PsiTypeParameter, PsiType>> set = this.mySubstitutionMap.entrySet();
        for (Map.Entry<PsiTypeParameter, PsiType> entry : set) {
            PsiTypeParameter typeParameter = entry.getKey();
            buffer.append(typeParameter.getName());
            PsiTypeParameterListOwner owner = typeParameter.getOwner();
            if (owner instanceof PsiClass) {
                buffer.append(" of ");
                buffer.append(((PsiClass)owner).getQualifiedName());
            } else if (owner instanceof PsiMethod) {
                buffer.append(" of ");
                buffer.append(((PsiMethod)owner).getName());
                buffer.append(" in ");
                PsiClass aClass2 = ((PsiMethod)owner).getContainingClass();
                buffer.append(aClass2 != null ? aClass2.getQualifiedName() : "<no class>");
            }
            buffer.append(" -> ");
            if (entry.getValue() != null) {
                buffer.append(entry.getValue().getCanonicalText());
            } else {
                buffer.append("null");
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    @Override
    public boolean isValid() {
        for (PsiType type2 : this.mySubstitutionMap.values()) {
            if (type2 == null || type2.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureValid() {
        for (PsiType type2 : this.mySubstitutionMap.values()) {
            if (type2 == null) continue;
            PsiUtil.ensureValidType(type2);
        }
    }

    @Override
    @NotNull
    public Map<PsiTypeParameter, PsiType> getSubstitutionMap() {
        UnmodifiableHashMap<PsiTypeParameter, PsiType> unmodifiableHashMap = this.mySubstitutionMap;
        if (unmodifiableHashMap == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(23);
        }
        return unmodifiableHashMap;
    }

    @Deprecated
    public static PsiSubstitutor createSubstitutor(@Nullable Map<PsiTypeParameter, PsiType> map2) {
        return PsiSubstitutor.createSubstitutor(map2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalKey";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 4: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiSubstitutorImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiSubstitutorImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedProvider";
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "putAll";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFromMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substituteWithBoundsPromotion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "rawTypeForTypeParameter";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMergedProvider";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "correctExternalSubstitution";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putAllInternal";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class SubstitutionVisitor
    extends PsiTypeMapper {
        private SubstitutionVisitor() {
        }

        @Override
        public PsiType visitType(PsiType type2) {
            return null;
        }

        @Override
        public PsiType visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound == null) {
                return wildcardType;
            }
            PsiType newBound = bound.accept(this);
            if (newBound == null) {
                return null;
            }
            assert (newBound.isValid()) : newBound.getClass() + "; " + bound.isValid();
            if (newBound instanceof PsiWildcardType) {
                PsiType newBoundBound = ((PsiWildcardType)newBound).getBound();
                return !((PsiWildcardType)newBound).isBounded() ? PsiWildcardType.createUnbounded(wildcardType.getManager()) : this.rebound(wildcardType, newBoundBound);
            }
            return newBound == PsiType.NULL ? newBound : this.rebound(wildcardType, newBound);
        }

        @NotNull
        private PsiWildcardType rebound(@NotNull PsiWildcardType type2, @NotNull PsiType newBound) {
            if (type2 == null) {
                SubstitutionVisitor.$$$reportNull$$$0(0);
            }
            if (newBound == null) {
                SubstitutionVisitor.$$$reportNull$$$0(1);
            }
            LOG.assertTrue(type2.getBound() != null);
            LOG.assertTrue(newBound.isValid());
            if (type2.isExtends()) {
                if (newBound.equalsToText("java.lang.Object")) {
                    PsiWildcardType psiWildcardType = PsiWildcardType.createUnbounded(type2.getManager());
                    if (psiWildcardType == null) {
                        SubstitutionVisitor.$$$reportNull$$$0(2);
                    }
                    return psiWildcardType;
                }
                PsiWildcardType psiWildcardType = PsiWildcardType.createExtends(type2.getManager(), newBound);
                if (psiWildcardType == null) {
                    SubstitutionVisitor.$$$reportNull$$$0(3);
                }
                return psiWildcardType;
            }
            PsiWildcardType psiWildcardType = PsiWildcardType.createSuper(type2.getManager(), newBound);
            if (psiWildcardType == null) {
                SubstitutionVisitor.$$$reportNull$$$0(4);
            }
            return psiWildcardType;
        }

        @Override
        public PsiType visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass2 = resolveResult.getElement();
            if (aClass2 == null) {
                return classType;
            }
            PsiUtilCore.ensureValid(aClass2);
            if (aClass2 instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)aClass2;
                PsiType result2 = PsiSubstitutorImpl.this.getFromMap(typeParameter);
                if (PsiType.VOID.equals(result2)) {
                    return classType;
                }
                if (result2 != null) {
                    PsiUtil.ensureValidType(result2);
                    if (result2 instanceof PsiClassType || result2 instanceof PsiArrayType || result2 instanceof PsiWildcardType) {
                        return result2.annotate(PsiSubstitutorImpl.getMergedProvider(classType, result2));
                    }
                }
                return result2;
            }
            HashMap<PsiTypeParameter, PsiType> hashMap = new HashMap<PsiTypeParameter, PsiType>(2);
            if (!this.processClass(aClass2, resolveResult.getSubstitutor(), hashMap)) {
                return null;
            }
            PsiClassType result3 = JavaPsiFacade.getElementFactory(aClass2.getProject()).createType(aClass2, PsiSubstitutor.createSubstitutor(hashMap), classType.getLanguageLevel());
            PsiUtil.ensureValidType(result3);
            return result3.annotate(classType.getAnnotationProvider());
        }

        private PsiType substituteInternal(@NotNull PsiType type2) {
            if (type2 == null) {
                SubstitutionVisitor.$$$reportNull$$$0(5);
            }
            return type2.accept(this);
        }

        private boolean processClass(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor originalSubstitutor, @NotNull Map<PsiTypeParameter, PsiType> substMap) {
            PsiTypeParameter[] params;
            if (resolve2 == null) {
                SubstitutionVisitor.$$$reportNull$$$0(6);
            }
            if (originalSubstitutor == null) {
                SubstitutionVisitor.$$$reportNull$$$0(7);
            }
            if (substMap == null) {
                SubstitutionVisitor.$$$reportNull$$$0(8);
            }
            for (PsiTypeParameter param : params = resolve2.getTypeParameters()) {
                PsiType original = originalSubstitutor.substitute(param);
                if (original == null) {
                    substMap.put(param, null);
                    continue;
                }
                substMap.put(param, this.substituteInternal(original));
            }
            if (resolve2.hasModifierProperty("static")) {
                return true;
            }
            PsiClass containingClass = resolve2.getContainingClass();
            return containingClass == null || this.processClass(containingClass, originalSubstitutor, substMap);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newBound";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolve";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalSubstitutor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rebound";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rebound";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteInternal";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "processClass";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

