/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import org.gradle.api.internal.file.AbstractFileResolver;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;

public abstract class AbstractBaseDirFileResolver
extends AbstractFileResolver {
    protected abstract File getBaseDir();

    public String resolveAsRelativePath(Object path) {
        return GFileUtils.relativePathOf((File)this.resolve(path), (File)this.getBaseDir());
    }

    @Override
    protected File doResolve(Object path) {
        if (!GUtil.isTrue((Object)path)) {
            throw new IllegalArgumentException(String.format("path may not be null or empty string. path='%s'", path));
        }
        File file = this.convertObjectToFile(path);
        if (file == null) {
            throw new IllegalArgumentException(String.format("Cannot convert path to File. path='%s'", path));
        }
        if (!file.isAbsolute()) {
            File baseDir = this.getBaseDir();
            if (!GUtil.isTrue((Object)baseDir)) {
                throw new IllegalArgumentException(String.format("baseDir may not be null or empty string. basedir='%s'", baseDir));
            }
            file = new File(baseDir, file.getPath());
        }
        return file;
    }

    public boolean canResolveRelativePath() {
        return true;
    }
}

