/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateApplicability;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStageRunner;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001aJ\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\tH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateCollector;", "", "components", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "resolutionStageRunner", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStageRunner;", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStageRunner;)V", "candidates", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "getCandidates", "()Ljava/util/List;", "getComponents", "()Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "currentApplicability", "Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateApplicability;", "getCurrentApplicability", "()Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateApplicability;", "setCurrentApplicability", "(Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateApplicability;)V", "groupNumbers", "", "getGroupNumbers", "getResolutionStageRunner", "()Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStageRunner;", "bestCandidates", "", "consumeCandidate", "group", "candidate", "isSuccess", "", "newDataSet", "", "resolve"})
public class CandidateCollector {
    @NotNull
    private final List<Integer> groupNumbers;
    @NotNull
    private final List<Candidate> candidates;
    @NotNull
    private CandidateApplicability currentApplicability;
    @NotNull
    private final BodyResolveComponents components;
    @NotNull
    private final ResolutionStageRunner resolutionStageRunner;

    @NotNull
    public final List<Integer> getGroupNumbers() {
        return this.groupNumbers;
    }

    @NotNull
    public final List<Candidate> getCandidates() {
        return this.candidates;
    }

    @NotNull
    public final CandidateApplicability getCurrentApplicability() {
        return this.currentApplicability;
    }

    public final void setCurrentApplicability(@NotNull CandidateApplicability candidateApplicability) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)candidateApplicability), (String)"<set-?>");
        this.currentApplicability = candidateApplicability;
    }

    public final void newDataSet() {
        this.groupNumbers.clear();
        this.candidates.clear();
        this.currentApplicability = CandidateApplicability.HIDDEN;
    }

    @NotNull
    public CandidateApplicability consumeCandidate(int group, @NotNull Candidate candidate2) {
        Intrinsics.checkParameterIsNotNull((Object)candidate2, (String)"candidate");
        CandidateApplicability applicability = this.resolutionStageRunner.processCandidate(candidate2);
        if (applicability.compareTo((Enum)this.currentApplicability) > 0) {
            this.groupNumbers.clear();
            this.candidates.clear();
            this.currentApplicability = applicability;
        }
        if (applicability == this.currentApplicability) {
            this.candidates.add(candidate2);
            this.groupNumbers.add(group);
        }
        return applicability;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Candidate> bestCandidates() {
        if (this.groupNumbers.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (this.groupNumbers.size() == 1) {
            return this.candidates;
        }
        boolean bl = false;
        List result2 = new ArrayList();
        int bestGroup = ((Number)CollectionsKt.first(this.groupNumbers)).intValue();
        boolean bl2 = false;
        for (Candidate candidate2 : (Iterable)this.candidates) {
            void index2;
            int group = ((Number)this.groupNumbers.get((int)index2)).intValue();
            if (bestGroup > group) {
                bestGroup = group;
                result2.clear();
            }
            if (bestGroup == group) {
                result2.add(candidate2);
            }
            ++index2;
        }
        return result2;
    }

    public final boolean isSuccess() {
        return this.currentApplicability == CandidateApplicability.RESOLVED;
    }

    @NotNull
    public final BodyResolveComponents getComponents() {
        return this.components;
    }

    @NotNull
    public final ResolutionStageRunner getResolutionStageRunner() {
        return this.resolutionStageRunner;
    }

    public CandidateCollector(@NotNull BodyResolveComponents components, @NotNull ResolutionStageRunner resolutionStageRunner) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)components, (String)"components");
        Intrinsics.checkParameterIsNotNull((Object)resolutionStageRunner, (String)"resolutionStageRunner");
        this.components = components;
        this.resolutionStageRunner = resolutionStageRunner;
        CandidateCollector candidateCollector = this;
        boolean bl = false;
        candidateCollector.groupNumbers = list2 = (List)new ArrayList();
        candidateCollector = this;
        bl = false;
        candidateCollector.candidates = list2 = (List)new ArrayList();
        this.currentApplicability = CandidateApplicability.HIDDEN;
    }
}

