/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.invocation.Gradle;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.InstantExecution;
import org.gradle.initialization.InternalBuildFinishedListener;
import org.gradle.initialization.SettingsPreparer;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.initialization.buildsrc.BuildSourceBuilder;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.scopes.BuildScopeServices;

public class DefaultGradleLauncher
implements GradleLauncher {
    private final ProjectsPreparer projectsPreparer;
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildListener buildListener;
    private final BuildCompletionListener buildCompletionListener;
    private final InternalBuildFinishedListener buildFinishedListener;
    private final BuildWorkExecutor buildExecuter;
    private final BuildScopeServices buildServices;
    private final List<?> servicesToStop;
    private final IncludedBuildControllers includedBuildControllers;
    private final GradleInternal gradle;
    private final InstantExecution instantExecution;
    private final SettingsPreparer settingsPreparer;
    private final TaskExecutionPreparer taskExecutionPreparer;
    private final BuildSourceBuilder buildSourceBuilder;
    private Stage stage;

    public DefaultGradleLauncher(GradleInternal gradle, ProjectsPreparer projectsPreparer, ExceptionAnalyser exceptionAnalyser, BuildListener buildListener, BuildCompletionListener buildCompletionListener, InternalBuildFinishedListener buildFinishedListener, BuildWorkExecutor buildExecuter, BuildScopeServices buildServices, List<?> servicesToStop, IncludedBuildControllers includedBuildControllers, SettingsPreparer settingsPreparer, TaskExecutionPreparer taskExecutionPreparer, InstantExecution instantExecution, BuildSourceBuilder buildSourceBuilder) {
        this.gradle = gradle;
        this.projectsPreparer = projectsPreparer;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.buildExecuter = buildExecuter;
        this.buildCompletionListener = buildCompletionListener;
        this.buildFinishedListener = buildFinishedListener;
        this.buildServices = buildServices;
        this.servicesToStop = servicesToStop;
        this.includedBuildControllers = includedBuildControllers;
        this.instantExecution = instantExecution;
        this.settingsPreparer = settingsPreparer;
        this.taskExecutionPreparer = taskExecutionPreparer;
        this.buildSourceBuilder = buildSourceBuilder;
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        this.doBuildStages(Stage.LoadSettings);
        return this.gradle.getSettings();
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        this.doBuildStages(Stage.Configure);
        return this.gradle;
    }

    @Override
    public GradleInternal executeTasks() {
        this.doBuildStages(Stage.RunTasks);
        return this.gradle;
    }

    @Override
    public void finishBuild() {
        if (this.stage != null) {
            this.finishBuild(this.stage.getDisplayName(), null);
        }
    }

    private void doBuildStages(Stage upTo) {
        Preconditions.checkArgument((upTo != Stage.Finished ? 1 : 0) != 0, (Object)"Stage.Finished is not supported by doBuildStages.");
        try {
            if (upTo == Stage.RunTasks && this.instantExecution.canExecuteInstantaneously()) {
                this.doInstantExecution();
            } else {
                this.doClassicBuildStages(upTo);
            }
        }
        catch (Throwable t) {
            this.finishBuild(upTo.getDisplayName(), t);
        }
    }

    private void doClassicBuildStages(Stage upTo) {
        if (this.stage == null) {
            this.instantExecution.prepareForBuildLogicExecution();
        }
        this.prepareSettings();
        if (upTo == Stage.LoadSettings) {
            return;
        }
        this.prepareProjects();
        if (upTo == Stage.Configure) {
            return;
        }
        this.prepareTaskExecution();
        if (upTo == Stage.TaskGraph) {
            return;
        }
        this.instantExecution.saveScheduledWork();
        this.runWork();
    }

    private void doInstantExecution() {
        this.buildListener.buildStarted((Gradle)this.gradle);
        this.instantExecution.loadScheduledWork();
        this.stage = Stage.TaskGraph;
        this.runWork();
    }

    private void finishBuild(String action, @Nullable Throwable stageFailure) {
        if (this.stage == Stage.Finished) {
            return;
        }
        RuntimeException reportableFailure = stageFailure == null ? null : this.exceptionAnalyser.transform(stageFailure);
        BuildResult buildResult = new BuildResult(action, (Gradle)this.gradle, (Throwable)reportableFailure);
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        this.includedBuildControllers.finishBuild(failures);
        try {
            this.buildListener.buildFinished(buildResult);
            this.buildFinishedListener.buildFinished((GradleInternal)buildResult.getGradle());
        }
        catch (Throwable t) {
            failures.add(t);
        }
        this.stage = Stage.Finished;
        if (failures.isEmpty() && reportableFailure != null) {
            throw reportableFailure;
        }
        if (!failures.isEmpty()) {
            if (stageFailure instanceof MultipleBuildFailures) {
                failures.addAll(0, ((MultipleBuildFailures)((Object)stageFailure)).getCauses());
            } else if (stageFailure != null) {
                failures.add(0, stageFailure);
            }
            throw this.exceptionAnalyser.transform((Throwable)((Object)new MultipleBuildFailures(failures)));
        }
    }

    private void prepareSettings() {
        if (this.stage == null) {
            this.buildListener.buildStarted((Gradle)this.gradle);
            this.settingsPreparer.prepareSettings(this.gradle);
            this.stage = Stage.LoadSettings;
        }
    }

    private void prepareProjects() {
        if (this.stage == Stage.LoadSettings) {
            ClassLoaderScope baseProjectClassLoaderScope = this.buildSourceBuilder.buildAndCreateClassLoader(this.gradle);
            this.gradle.setBaseProjectClassLoaderScope(baseProjectClassLoaderScope);
            this.projectsPreparer.prepareProjects(this.gradle);
            this.stage = Stage.Configure;
        }
    }

    private void prepareTaskExecution() {
        if (this.stage == Stage.Configure) {
            this.taskExecutionPreparer.prepareForTaskExecution(this.gradle);
            this.stage = Stage.TaskGraph;
        }
    }

    @Override
    public void scheduleTasks(Iterable<String> taskPaths) {
        GradleInternal gradle = this.getConfiguredBuild();
        LinkedHashSet allTasks = Sets.newLinkedHashSet((Iterable)gradle.getStartParameter().getTaskNames());
        boolean added = allTasks.addAll(Lists.newArrayList(taskPaths));
        if (!added) {
            return;
        }
        gradle.getStartParameter().setTaskNames((Iterable)allTasks);
        this.stage = Stage.Configure;
        this.doBuildStages(Stage.TaskGraph);
    }

    private void runWork() {
        if (this.stage != Stage.TaskGraph) {
            throw new IllegalStateException("Cannot execute tasks: current stage = " + (Object)((Object)this.stage));
        }
        ArrayList taskFailures = new ArrayList();
        this.buildExecuter.execute(this.gradle, taskFailures);
        if (!taskFailures.isEmpty()) {
            throw new MultipleBuildFailures(taskFailures);
        }
        this.stage = Stage.RunTasks;
    }

    @Override
    public void addListener(Object listener) {
        this.gradle.addListener(listener);
    }

    public void stop() {
        try {
            CompositeStoppable.stoppable((Object[])new Object[]{this.buildServices}).add(this.servicesToStop).stop();
        }
        finally {
            this.buildCompletionListener.completed();
        }
    }

    private static enum Stage {
        LoadSettings,
        Configure,
        TaskGraph,
        RunTasks{

            @Override
            String getDisplayName() {
                return "Build";
            }
        }
        ,
        Finished;


        String getDisplayName() {
            return this.name();
        }
    }
}

