/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.initialization.DefaultPlannedTask;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.taskgraph.CalculateTaskGraphBuildOperationType;

public class BuildOperatingFiringTaskExecutionPreparer
implements TaskExecutionPreparer {
    private final TaskExecutionPreparer delegate;
    private final BuildOperationExecutor buildOperationExecutor;

    public BuildOperatingFiringTaskExecutionPreparer(TaskExecutionPreparer delegate, BuildOperationExecutor buildOperationExecutor) {
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void prepareForTaskExecution(GradleInternal gradle) {
        this.buildOperationExecutor.run((RunnableBuildOperation)new CalculateTaskGraph(gradle));
    }

    private static class PlannedTaskIdentity
    implements CalculateTaskGraphBuildOperationType.TaskIdentity {
        private final TaskIdentity delegate;

        public PlannedTaskIdentity(TaskIdentity delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getBuildPath() {
            return this.delegate.getBuildPath();
        }

        @Override
        public String getTaskPath() {
            return this.delegate.getTaskPath();
        }

        @Override
        public long getTaskId() {
            return this.delegate.getId();
        }
    }

    private class CalculateTaskGraph
    implements RunnableBuildOperation {
        private final GradleInternal gradle;

        public CalculateTaskGraph(GradleInternal gradle) {
            this.gradle = gradle;
        }

        public void run(BuildOperationContext buildOperationContext) {
            final TaskExecutionGraphInternal taskGraph = this.populateTaskGraph();
            buildOperationContext.setResult((Object)new CalculateTaskGraphBuildOperationType.Result(){

                @Override
                public List<String> getRequestedTaskPaths() {
                    return this.toTaskPaths(taskGraph.getRequestedTasks());
                }

                @Override
                public List<String> getExcludedTaskPaths() {
                    return this.toTaskPaths(taskGraph.getFilteredTasks());
                }

                @Override
                public List<CalculateTaskGraphBuildOperationType.PlannedTask> getTaskPlan() {
                    List<Node> scheduledWork = taskGraph.getScheduledWork();
                    return this.toPlannedTasks(scheduledWork);
                }

                private List<CalculateTaskGraphBuildOperationType.PlannedTask> toPlannedTasks(List<Node> scheduledWork) {
                    ArrayList<CalculateTaskGraphBuildOperationType.PlannedTask> plannedTasks = new ArrayList<CalculateTaskGraphBuildOperationType.PlannedTask>();
                    for (Node node : scheduledWork) {
                        if (!(node instanceof TaskNode)) continue;
                        TaskNode taskNode = (TaskNode)node;
                        plannedTasks.add(this.toPlannedTask(taskNode));
                    }
                    return plannedTasks;
                }

                private CalculateTaskGraphBuildOperationType.PlannedTask toPlannedTask(TaskNode taskNode) {
                    TaskIdentity<?> taskIdentity = taskNode.getTask().getTaskIdentity();
                    return new DefaultPlannedTask(new PlannedTaskIdentity(taskIdentity), this.transformToIdentities(taskNode.getDependencySuccessors(), (Function<Node, Set<Node>>)((Function)node -> node.getDependencySuccessors())), this.transformToIdentities(taskNode.getMustSuccessors(), (Function<Node, Set<Node>>)((Function)node -> Collections.emptySet())), this.transformToIdentities(taskNode.getShouldSuccessors(), (Function<Node, Set<Node>>)((Function)node -> Collections.emptySet())), this.transformToIdentities(taskNode.getFinalizers(), (Function<Node, Set<Node>>)((Function)node -> Collections.emptySet())));
                }

                private List<CalculateTaskGraphBuildOperationType.TaskIdentity> transformToIdentities(Set<Node> nodes, Function<Node, Set<Node>> nestedNodesResolver) {
                    return CalculateTaskGraph.this.toOnlyTaskNodes(nodes, (Function<Node, Set<Node>>)nestedNodesResolver).stream().map(node -> ((TaskNode)node).getTask().getTaskIdentity()).map(id -> new PlannedTaskIdentity((TaskIdentity)id)).collect(Collectors.toList());
                }

                private List<String> toTaskPaths(Set<Task> tasks) {
                    return ImmutableSortedSet.copyOf((Collection)Collections2.transform(tasks, task -> task.getPath())).asList();
                }
            });
        }

        private List<Node> toOnlyTaskNodes(Set<Node> nodes, Function<Node, Set<Node>> nestedNodesResolver) {
            return nodes.stream().flatMap(node -> node instanceof TaskNode ? Stream.of(node) : this.toOnlyTaskNodes((Set)nestedNodesResolver.apply(node), nestedNodesResolver).stream()).filter(node -> node instanceof TaskNode).collect(Collectors.toList());
        }

        TaskExecutionGraphInternal populateTaskGraph() {
            BuildOperatingFiringTaskExecutionPreparer.this.delegate.prepareForTaskExecution(this.gradle);
            return this.gradle.getTaskGraph();
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.gradle.contextualize("Calculate task graph")).details((Object)new CalculateTaskGraphBuildOperationType.Details(){

                @Override
                public String getBuildPath() {
                    return CalculateTaskGraph.this.gradle.getIdentityPath().getPath();
                }
            });
        }
    }
}

