/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.ProjectBackedModule;
import org.gradle.api.internal.artifacts.ProjectModuleFactory;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectRegistry;

public class DefaultProjectModuleFactory
implements ProjectModuleFactory {
    public static final String DUPLICATE_DETECTION_SYSPROP = "org.gradle.dependency.duplicate.project.detection";
    private static final Splitter SPLITTER = Splitter.on((char)':').omitEmptyStrings();
    private final Map<Project, Module> projectToModule = Maps.newConcurrentMap();
    private final Set<String> projectsWithSameName;
    private final boolean detectDuplicates;

    public static boolean isDuplicateDetectionEnabled() {
        return Boolean.parseBoolean(System.getProperty(DUPLICATE_DETECTION_SYSPROP, "true"));
    }

    public DefaultProjectModuleFactory(ProjectRegistry<? extends ProjectIdentifier> registry) {
        Map uniqueNames = registry.getAllProjects().stream().map(ProjectIdentifier::getName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        uniqueNames.entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        this.projectsWithSameName = builder.build();
        this.detectDuplicates = DefaultProjectModuleFactory.isDuplicateDetectionEnabled();
    }

    private List<Project> findDuplicates(Project project) {
        Set projects = project.getRootProject().getAllprojects();
        String current = DefaultProjectModuleFactory.toGroupAndArtifact(project);
        ArrayList duplicates = null;
        for (Project projectIdentifier : projects) {
            String ga;
            if (project == projectIdentifier || !current.equals(ga = DefaultProjectModuleFactory.toGroupAndArtifact(projectIdentifier))) continue;
            if (duplicates == null) {
                duplicates = Lists.newArrayList();
            }
            duplicates.add(projectIdentifier);
        }
        return duplicates == null ? Collections.emptyList() : duplicates;
    }

    private static String toGroupAndArtifact(Project projectIdentifier) {
        return projectIdentifier.getGroup() + ":" + projectIdentifier.getName();
    }

    @Override
    public Module getModule(Project project) {
        return this.projectToModule.computeIfAbsent(project, this::createId);
    }

    private Module createId(Project project) {
        return new DynamicDeduplicatingModuleProjectIdentifier(project);
    }

    private class DynamicDeduplicatingModuleProjectIdentifier
    extends AbstractProjectBackedModule {
        private final Project project;
        private volatile String lazyName;

        private DynamicDeduplicatingModuleProjectIdentifier(Project project) {
            super(project);
            this.project = project;
        }

        @Override
        public String getName() {
            if (this.lazyName == null) {
                this.computeName();
            }
            return this.lazyName;
        }

        private void computeName() {
            List strings;
            String name = this.project.getName();
            if (DefaultProjectModuleFactory.this.detectDuplicates && DefaultProjectModuleFactory.this.projectsWithSameName.contains(name) && (strings = SPLITTER.splitToList((CharSequence)this.project.getPath())).size() > 1) {
                this.lazyName = String.join((CharSequence)"-", strings.subList(0, strings.size() - 1)) + "-" + name;
                return;
            }
            this.lazyName = name;
        }
    }

    private abstract class AbstractProjectBackedModule
    implements ProjectBackedModule {
        private final Project project;

        @Override
        public Project getProject() {
            return this.project;
        }

        public AbstractProjectBackedModule(Project project) {
            this.project = project;
        }

        @Override
        public List<Project> getProjectsWithSameCoordinates() {
            List ids = DefaultProjectModuleFactory.this.findDuplicates(this.project);
            if (ids.isEmpty()) {
                return Collections.emptyList();
            }
            return ids.stream().filter(id -> id != this.project).collect(Collectors.toList());
        }

        @Override
        public String getGroup() {
            return String.valueOf(this.project.getGroup());
        }

        @Override
        public String getVersion() {
            return this.project.getVersion().toString();
        }

        @Override
        public String getStatus() {
            return this.project.getStatus().toString();
        }

        @Override
        public String getProjectPath() {
            return this.project.getPath();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractProjectBackedModule that = (AbstractProjectBackedModule)o;
            return this.project.equals(that.project);
        }

        public int hashCode() {
            return this.project.hashCode();
        }
    }
}

