/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;

public class LineTokenizer {
    private int myOffset;
    private int myLength;
    private int myLineSeparatorLength;
    private boolean atEnd;
    private final CharSequence myText;

    @NotNull
    public static String[] tokenize(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        List<String> strings2 = LineTokenizer.tokenizeIntoList(chars, includeSeparators, skipLastEmptyLine);
        String[] stringArray = strings2.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : ArrayUtilRt.toStringArray(strings2);
        if (stringArray == null) {
            LineTokenizer.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public static List<String> tokenizeIntoList(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null || chars.length() == 0) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                LineTokenizer.$$$reportNull$$$0(3);
            }
            return list2;
        }
        LineTokenizer tokenizer = new LineTokenizer(chars);
        ArrayList<String> lines = new ArrayList<String>();
        while (!tokenizer.atEnd()) {
            int offset2 = tokenizer.getOffset();
            String line = includeSeparators ? chars.subSequence(offset2, offset2 + tokenizer.getLength() + tokenizer.getLineSeparatorLength()).toString() : chars.subSequence(offset2, offset2 + tokenizer.getLength()).toString();
            lines.add(line);
            tokenizer.advance();
        }
        if (!skipLastEmptyLine && LineTokenizer.stringEndsWithSeparator(tokenizer)) {
            lines.add("");
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            LineTokenizer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static boolean stringEndsWithSeparator(@NotNull LineTokenizer tokenizer) {
        if (tokenizer == null) {
            LineTokenizer.$$$reportNull$$$0(12);
        }
        return tokenizer.getLineSeparatorLength() > 0;
    }

    public LineTokenizer(@NotNull CharSequence text2) {
        if (text2 == null) {
            LineTokenizer.$$$reportNull$$$0(15);
        }
        this.myText = text2;
        this.myOffset = 0;
        this.advance();
    }

    public final boolean atEnd() {
        return this.atEnd;
    }

    public final int getOffset() {
        return this.myOffset;
    }

    public final int getLength() {
        return this.myLength;
    }

    public final int getLineSeparatorLength() {
        return this.myLineSeparatorLength;
    }

    public void advance() {
        char c;
        int i = this.myOffset + this.myLength + this.myLineSeparatorLength;
        int textLength = this.myText.length();
        if (i >= textLength) {
            this.atEnd = true;
            return;
        }
        while (i < textLength && (c = this.myText.charAt(i)) != '\r' && c != '\n') {
            ++i;
        }
        this.myOffset += this.myLength + this.myLineSeparatorLength;
        this.myLength = i - this.myOffset;
        this.myLineSeparatorLength = 0;
        if (i == textLength) {
            return;
        }
        char first2 = this.myText.charAt(i);
        if (first2 == '\r' || first2 == '\n') {
            this.myLineSeparatorLength = 1;
        }
        if (++i == textLength) {
            return;
        }
        char second = this.myText.charAt(i);
        if (first2 == '\r' && second == '\n') {
            this.myLineSeparatorLength = 2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/LineTokenizer";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenizeIntoList";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/LineTokenizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcLineCount";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "stringEndsWithSeparator";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

