/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.CollectionPropertyInternal;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.Collectors;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValidatingValueCollector;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;

public abstract class AbstractCollectionProperty<T, C extends Collection<T>>
extends AbstractProperty<C>
implements CollectionPropertyInternal<T, C> {
    private static final CollectionSupplier<Object, Collection<Object>> NO_VALUE = new NoValueSupplier<Object, Object>(ValueSupplier.Value.missing());
    private final Class<? extends Collection> collectionType;
    private final Class<T> elementType;
    private final ValueCollector<T> valueCollector;
    private CollectionSupplier<T, C> convention = this.noValueSupplier();
    private CollectionSupplier<T, C> defaultValue = this.emptySupplier();
    private CollectionSupplier<T, C> value;

    AbstractCollectionProperty(Class<? extends Collection> collectionType, Class<T> elementType) {
        this.applyDefaultValue();
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.valueCollector = new ValidatingValueCollector<T>(collectionType, elementType, ValueSanitizers.forType(elementType));
    }

    private CollectionSupplier<T, C> emptySupplier() {
        return new EmptySupplier();
    }

    private CollectionSupplier<T, C> noValueSupplier() {
        return (CollectionSupplier)Cast.uncheckedCast(NO_VALUE);
    }

    @Override
    protected ValueSupplier getSupplier() {
        return this.value;
    }

    protected abstract ImmutableCollection.Builder<T> builder();

    protected abstract C emptyCollection();

    public void add(T element) {
        Preconditions.checkNotNull(element, (Object)String.format("Cannot add a null element to a property of type %s.", this.collectionType.getSimpleName()));
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.SingleElement<T>(element));
    }

    public void add(Provider<? extends T> providerOfElement) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.ElementFromProvider<T>(Providers.internal(providerOfElement)));
    }

    public void addAll(T ... elements) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.ElementsFromArray<T>(elements));
    }

    public void addAll(Iterable<? extends T> elements) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.ElementsFromCollection<T>(elements));
    }

    public void addAll(Provider<? extends Iterable<? extends T>> provider) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.ElementsFromCollectionProvider(Providers.internal(provider)));
    }

    private void addCollector(Collector<T> collector) {
        this.value = this.value.plus(collector);
    }

    @Override
    @Nullable
    public Class<C> getType() {
        return this.collectionType;
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    public List<ProviderInternal<? extends Iterable<? extends T>>> getProviders() {
        ArrayList sources = new ArrayList();
        this.value.visit(sources);
        return sources;
    }

    public void providers(List<ProviderInternal<? extends Iterable<? extends T>>> providers) {
        if (!this.beforeMutate()) {
            return;
        }
        this.value = this.defaultValue;
        for (ProviderInternal<Iterable<T>> providerInternal : providers) {
            this.value = this.value.plus(new Collectors.ElementsFromCollectionProvider<T>(providerInternal));
        }
    }

    @Override
    public boolean isPresent() {
        this.beforeRead();
        return this.value.isPresent();
    }

    @Override
    protected ValueSupplier.Value<? extends C> calculateOwnValue() {
        this.beforeRead();
        return this.doCalculateOwnValue();
    }

    private ValueSupplier.Value<? extends C> doCalculateOwnValue() {
        return this.value.calculateValue();
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            if (object != null && !(object instanceof Iterable)) {
                throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", this.collectionType.getName(), object.getClass().getName()));
            }
            this.set((Iterable)object);
        }
    }

    public void set(@Nullable Iterable<? extends T> elements) {
        if (elements == null) {
            if (this.beforeReset()) {
                this.set(this.convention);
                this.defaultValue = this.noValueSupplier();
            }
            return;
        }
        if (this.beforeMutate()) {
            this.set(new CollectingSupplier(new Collectors.ElementsFromCollection<T>(elements)));
        }
    }

    public void set(Provider<? extends Iterable<? extends T>> provider) {
        CollectionPropertyInternal collectionProp;
        if (!this.beforeMutate()) {
            return;
        }
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        ProviderInternal<Iterable<T>> p = Providers.internal(provider);
        if (p.getType() != null && !Iterable.class.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using a provider of type %s.", this.collectionType.getName(), p.getType().getName()));
        }
        if (p instanceof CollectionPropertyInternal && !this.elementType.isAssignableFrom((collectionProp = (CollectionPropertyInternal)p).getElementType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s with element type %s using a provider with element type %s.", this.collectionType.getName(), this.elementType.getName(), collectionProp.getElementType().getName()));
        }
        this.set(new CollectingSupplier(new Collectors.ElementsFromCollectionProvider(p)));
    }

    public HasMultipleValues<T> value(@Nullable Iterable<? extends T> elements) {
        this.set(elements);
        return this;
    }

    public HasMultipleValues<T> value(Provider<? extends Iterable<? extends T>> provider) {
        this.set(provider);
        return this;
    }

    public HasMultipleValues<T> empty() {
        if (!this.beforeMutate()) {
            return this;
        }
        this.set(this.emptySupplier());
        return this;
    }

    @Override
    protected void applyDefaultValue() {
        this.value = this.defaultValue;
    }

    @Override
    protected void makeFinal() {
        ValueSupplier.Value<C> result = this.doCalculateOwnValue();
        if (!result.isMissing()) {
            this.set(new FixedSupplier((Collection)result.get()));
        } else if (result.getPathToOrigin().isEmpty()) {
            this.set(this.noValueSupplier());
        } else {
            this.set(new NoValueSupplier(result));
        }
        this.convention = this.noValueSupplier();
    }

    private void set(CollectionSupplier<T, C> supplier) {
        this.value = supplier;
    }

    public HasMultipleValues<T> convention(@Nullable Iterable<? extends T> elements) {
        if (elements == null) {
            this.convention(this.noValueSupplier());
        } else {
            this.convention(new CollectingSupplier(new Collectors.ElementsFromCollection<T>(elements)));
        }
        return this;
    }

    public HasMultipleValues<T> convention(Provider<? extends Iterable<? extends T>> provider) {
        this.convention(new CollectingSupplier(new Collectors.ElementsFromCollectionProvider(Providers.internal(provider))));
        return this;
    }

    private void convention(CollectionSupplier<T, C> collector) {
        if (this.shouldApplyConvention()) {
            this.value = collector;
        }
        this.convention = collector;
    }

    @Override
    protected String describeContents() {
        return String.format("%s(%s, %s)", this.collectionType.getSimpleName().toLowerCase(), this.elementType, this.value.toString());
    }

    private static class PlusCollector<T>
    implements Collector<T> {
        private final Collector<T> left;
        private final Collector<T> right;

        public PlusCollector(Collector<T> left, Collector<T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean isPresent() {
            return this.left.isPresent() && this.right.isPresent();
        }

        @Override
        public int size() {
            return this.left.size() + this.right.size();
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueCollector<T> collector, ImmutableCollection.Builder<T> dest) {
            ValueSupplier.Value<Void> value = this.left.collectEntries(collector, dest);
            if (value.isMissing()) {
                return value;
            }
            return this.right.collectEntries(collector, dest);
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            this.left.visit(sources);
            this.right.visit(sources);
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            if (this.left.maybeVisitBuildDependencies(context)) {
                return this.right.maybeVisitBuildDependencies(context);
            }
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            this.left.visitProducerTasks(visitor);
            this.right.visitProducerTasks(visitor);
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.left.isValueProducedByTask() || this.right.isValueProducedByTask();
        }
    }

    private class CollectingSupplier
    implements CollectionSupplier<T, C> {
        private final Collector<T> value;

        public CollectingSupplier(Collector<T> value) {
            this.value = value;
        }

        @Override
        public boolean isPresent() {
            return this.value.isPresent();
        }

        @Override
        public ValueSupplier.Value<C> calculateValue() {
            ImmutableCollection.Builder builder = AbstractCollectionProperty.this.builder();
            ValueSupplier.Value<Void> result = this.value.collectEntries(AbstractCollectionProperty.this.valueCollector, builder);
            if (result.isMissing()) {
                return result.asType();
            }
            return ValueSupplier.Value.of((Collection)Cast.uncheckedCast((Object)builder.build()));
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector) {
            return new CollectingSupplier(new PlusCollector(this.value, collector));
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            this.value.visit(sources);
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.value.isValueProducedByTask();
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return this.value.maybeVisitBuildDependencies(context);
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            this.value.visitProducerTasks(visitor);
        }
    }

    private static class FixedSupplier<T, C extends Collection<? extends T>>
    implements CollectionSupplier<T, C> {
        private final C value;

        public FixedSupplier(C value) {
            this.value = value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateValue() {
            return ValueSupplier.Value.of(this.value);
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            sources.add(Providers.of(this.value));
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return true;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }
    }

    private class EmptySupplier
    implements CollectionSupplier<T, C> {
        private EmptySupplier() {
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateValue() {
            return ValueSupplier.Value.of(AbstractCollectionProperty.this.emptyCollection());
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector) {
            return new CollectingSupplier(collector);
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return true;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }
    }

    private static class NoValueSupplier<T, C extends Collection<? extends T>>
    implements CollectionSupplier<T, C> {
        private final ValueSupplier.Value<? extends C> value;

        public NoValueSupplier(ValueSupplier.Value<? extends C> value) {
            assert (value.isMissing());
            this.value = value.asType();
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateValue() {
            return this.value;
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector) {
            return this;
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return true;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }
    }

    private static interface CollectionSupplier<T, C extends Collection<? extends T>>
    extends ValueSupplier {
        public ValueSupplier.Value<? extends C> calculateValue();

        public CollectionSupplier<T, C> plus(Collector<T> var1);

        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> var1);
    }
}

