/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.serialize.CausePlaceholder;
import org.gradle.internal.serialize.ContextualPlaceholderException;
import org.gradle.internal.serialize.ExceptionReplacingObjectInputStream;
import org.gradle.internal.serialize.ExceptionReplacingObjectOutputStream;
import org.gradle.internal.serialize.PlaceholderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExceptionPlaceholder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionPlaceholder.class);
    private final String type;
    private byte[] serializedException;
    private String message;
    private String toString;
    private final boolean contextual;
    private final List<ExceptionPlaceholder> causes;
    private StackTraceElement[] stackTrace;
    private Throwable toStringRuntimeExec;
    private Throwable getMessageExec;

    public ExceptionPlaceholder(Throwable throwable, Transformer<ExceptionReplacingObjectOutputStream, OutputStream> objectOutputStreamCreator) {
        this.type = throwable.getClass().getName();
        this.contextual = throwable.getClass().getAnnotation(Contextual.class) != null;
        try {
            this.stackTrace = throwable.getStackTrace() == null ? new StackTraceElement[]{} : throwable.getStackTrace();
        }
        catch (Throwable ignored) {
            this.stackTrace = new StackTraceElement[0];
        }
        try {
            this.message = throwable.getMessage();
        }
        catch (Throwable failure) {
            this.getMessageExec = failure;
        }
        try {
            this.toString = throwable.toString();
        }
        catch (Throwable failure) {
            this.toStringRuntimeExec = failure;
        }
        final List<? extends Throwable> causes = this.extractCauses(throwable);
        StreamByteBuffer buffer = new StreamByteBuffer();
        ExceptionReplacingObjectOutputStream oos = (ExceptionReplacingObjectOutputStream)objectOutputStreamCreator.transform((Object)buffer.getOutputStream());
        oos.setObjectTransformer(new Transformer<Object, Object>(){
            boolean seenFirst;

            public Object transform(Object obj) {
                if (!this.seenFirst) {
                    this.seenFirst = true;
                    return obj;
                }
                int causeIndex = causes.indexOf(obj);
                if (causeIndex >= 0) {
                    return new CausePlaceholder(causeIndex);
                }
                return obj;
            }
        });
        try {
            oos.writeObject(throwable);
            oos.close();
            this.serializedException = buffer.readAsByteArray();
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        if (causes.isEmpty()) {
            this.causes = Collections.emptyList();
        } else if (causes.size() == 1) {
            this.causes = Collections.singletonList(new ExceptionPlaceholder(causes.get(0), objectOutputStreamCreator));
        } else {
            ArrayList<ExceptionPlaceholder> placeholders = new ArrayList<ExceptionPlaceholder>(causes.size());
            for (Throwable throwable2 : causes) {
                placeholders.add(new ExceptionPlaceholder(throwable2, objectOutputStreamCreator));
            }
            this.causes = placeholders;
        }
    }

    public Throwable read(Transformer<Class<?>, String> classNameTransformer, Transformer<ExceptionReplacingObjectInputStream, InputStream> objectInputStreamCreator) throws IOException {
        final List<Throwable> causes = this.recreateCauses(classNameTransformer, objectInputStreamCreator);
        if (this.serializedException != null) {
            ExceptionReplacingObjectInputStream ois = (ExceptionReplacingObjectInputStream)((Object)objectInputStreamCreator.transform((Object)new ByteArrayInputStream(this.serializedException)));
            ois.setObjectTransformer(new Transformer<Object, Object>(){

                public Object transform(Object obj) {
                    if (obj instanceof CausePlaceholder) {
                        CausePlaceholder placeholder = (CausePlaceholder)obj;
                        return causes.get(placeholder.getCauseIndex());
                    }
                    return obj;
                }
            });
            try {
                return (Throwable)ois.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Throwable failure) {
                LOGGER.debug("Ignoring failure to de-serialize throwable.", failure);
            }
        }
        try {
            Class clazz = (Class)classNameTransformer.transform((Object)this.type);
            if (clazz != null && causes.size() <= 1) {
                Constructor constructor = clazz.getConstructor(String.class);
                Throwable reconstructed = (Throwable)constructor.newInstance(this.message);
                if (!causes.isEmpty()) {
                    reconstructed.initCause(causes.get(0));
                }
                reconstructed.setStackTrace(this.stackTrace);
                return reconstructed;
            }
        }
        catch (UncheckedException clazz) {
        }
        catch (NoSuchMethodException clazz) {
        }
        catch (Throwable ignored) {
            LOGGER.debug("Ignoring failure to recreate throwable.", ignored);
        }
        Object placeholder = causes.size() <= 1 ? (this.contextual ? new ContextualPlaceholderException(this.type, this.message, this.getMessageExec, this.toString, this.toStringRuntimeExec, causes.isEmpty() ? null : causes.get(0)) : new PlaceholderException(this.type, this.message, this.getMessageExec, this.toString, this.toStringRuntimeExec, causes.isEmpty() ? null : causes.get(0))) : new DefaultMultiCauseException(this.message, causes);
        try {
            placeholder.setStackTrace(this.stackTrace);
        }
        catch (NullPointerException e) {
            this.diagnoseNullPointerException(e);
            throw e;
        }
        return placeholder;
    }

    private void diagnoseNullPointerException(NullPointerException e) {
        StringBuilder sb = new StringBuilder("Malicious stack traces\n");
        for (StackTraceElement element : this.stackTrace) {
            sb.append(element).append("\n");
        }
        LOGGER.error(sb.toString(), (Throwable)e);
    }

    private List<? extends Throwable> extractCauses(Throwable throwable) {
        Throwable causeTmp;
        if (throwable instanceof MultiCauseException) {
            return ((MultiCauseException)throwable).getCauses();
        }
        try {
            causeTmp = throwable.getCause();
        }
        catch (Throwable ignored) {
            causeTmp = null;
        }
        return causeTmp == null ? Collections.emptyList() : Collections.singletonList(causeTmp);
    }

    private List<Throwable> recreateCauses(Transformer<Class<?>, String> classNameTransformer, Transformer<ExceptionReplacingObjectInputStream, InputStream> objectInputStreamCreator) throws IOException {
        if (this.causes.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.causes.size() == 1) {
            return Collections.singletonList(this.causes.get(0).read(classNameTransformer, objectInputStreamCreator));
        }
        ArrayList<Throwable> result = new ArrayList<Throwable>();
        for (ExceptionPlaceholder placeholder : this.causes) {
            result.add(placeholder.read(classNameTransformer, objectInputStreamCreator));
        }
        return result;
    }
}

