/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.AbstractReadOnlyProvider;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.MapCollector;
import org.gradle.api.internal.provider.MapCollectors;
import org.gradle.api.internal.provider.MapEntryCollector;
import org.gradle.api.internal.provider.MapProviderInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValidatingMapEntryCollector;
import org.gradle.api.internal.provider.ValidatingValueCollector;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.DisplayName;

public class DefaultMapProperty<K, V>
extends AbstractProperty<Map<K, V>>
implements MapProperty<K, V>,
MapProviderInternal<K, V> {
    private static final MapCollectors.EmptyMap EMPTY_MAP = new MapCollectors.EmptyMap();
    private static final MapCollectors.NoValue NO_VALUE = new MapCollectors.NoValue();
    private static final String NULL_KEY_FORBIDDEN_MESSAGE = String.format("Cannot add an entry with a null key to a property of type %s.", Map.class.getSimpleName());
    private static final String NULL_VALUE_FORBIDDEN_MESSAGE = String.format("Cannot add an entry with a null value to a property of type %s.", Map.class.getSimpleName());
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final ValueCollector<K> keyCollector;
    private final MapEntryCollector<K, V> entryCollector;
    private MapCollector<K, V> convention = (MapCollector)Cast.uncheckedCast((Object)NO_VALUE);
    private MapCollector<K, V> defaultValue = (MapCollector)Cast.uncheckedCast((Object)EMPTY_MAP);
    private MapCollector<K, V> value;

    public DefaultMapProperty(Class<K> keyType, Class<V> valueType) {
        this.applyDefaultValue();
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyCollector = new ValidatingValueCollector<K>(Set.class, keyType, ValueSanitizers.forType(keyType));
        this.entryCollector = new ValidatingMapEntryCollector<K, V>(keyType, valueType, ValueSanitizers.forType(keyType), ValueSanitizers.forType(valueType));
    }

    @Override
    protected ValueSupplier getSupplier() {
        return this.value;
    }

    @Override
    @Nullable
    public Class<Map<K, V>> getType() {
        return Map.class;
    }

    @Override
    public Class<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public Class<?> publicType() {
        return MapProperty.class;
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.MapPropertyManagedFactory.FACTORY_ID;
    }

    @Override
    public boolean isPresent() {
        this.beforeRead();
        return this.value.present();
    }

    public Map<K, V> get() {
        this.beforeRead();
        LinkedHashMap entries = new LinkedHashMap();
        this.value.collectInto(this.getDisplayName(), this.entryCollector, entries);
        return ImmutableMap.copyOf(entries);
    }

    @Override
    @Nullable
    public Map<K, V> getOrNull() {
        this.beforeRead();
        return this.doGetOrNull();
    }

    @Nullable
    private Map<K, V> doGetOrNull() {
        LinkedHashMap entries = new LinkedHashMap();
        if (!this.value.maybeCollectInto(this.entryCollector, entries)) {
            return null;
        }
        return ImmutableMap.copyOf(entries);
    }

    public Provider<V> getting(final K key) {
        return new DefaultProvider(new Callable<V>(){

            @Override
            @Nullable
            public V call() {
                DefaultMapProperty.this.beforeRead();
                LinkedHashMap dest = new LinkedHashMap();
                if (DefaultMapProperty.this.value.maybeCollectInto(DefaultMapProperty.this.entryCollector, dest)) {
                    return dest.get(key);
                }
                return null;
            }
        });
    }

    public MapProperty<K, V> empty() {
        if (this.beforeMutate()) {
            this.set(EMPTY_MAP);
        }
        return this;
    }

    @Override
    public void setFromAnyValue(@Nullable Object object) {
        if (object == null || object instanceof Map) {
            this.set((Map)object);
        } else if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", Map.class.getName(), object.getClass().getName()));
        }
    }

    public void set(@Nullable Map<? extends K, ? extends V> entries) {
        if (entries == null) {
            if (this.beforeReset()) {
                this.set(this.convention);
                this.defaultValue = NO_VALUE;
            }
            return;
        }
        if (this.beforeMutate()) {
            this.set(new MapCollectors.EntriesFromMap<K, V>(entries));
        }
    }

    public void set(Provider<? extends Map<? extends K, ? extends V>> provider) {
        if (!this.beforeMutate()) {
            return;
        }
        ProviderInternal<Map<K, V>> p = this.checkMapProvider(provider);
        this.set(new MapCollectors.EntriesFromMapProvider<K, V>(p));
    }

    public MapProperty<K, V> value(@Nullable Map<? extends K, ? extends V> entries) {
        this.set(entries);
        return this;
    }

    public MapProperty<K, V> value(Provider<? extends Map<? extends K, ? extends V>> provider) {
        this.set(provider);
        return this;
    }

    private void set(MapCollector<K, V> collector) {
        this.value = collector;
    }

    public void put(K key, V value) {
        Preconditions.checkNotNull(key, (Object)NULL_KEY_FORBIDDEN_MESSAGE);
        Preconditions.checkNotNull(value, (Object)NULL_VALUE_FORBIDDEN_MESSAGE);
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new MapCollectors.SingleEntry<K, V>(key, value));
    }

    public void put(K key, Provider<? extends V> providerOfValue) {
        Preconditions.checkNotNull(key, (Object)NULL_KEY_FORBIDDEN_MESSAGE);
        Preconditions.checkNotNull(providerOfValue, (Object)NULL_VALUE_FORBIDDEN_MESSAGE);
        if (!this.beforeMutate()) {
            return;
        }
        ProviderInternal<V> p = Providers.internal(providerOfValue);
        if (p.getType() != null && !this.valueType.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot add an entry to a property of type %s with values of type %s using a provider of type %s.", Map.class.getName(), this.valueType.getName(), p.getType().getName()));
        }
        this.addCollector(new MapCollectors.EntryWithValueFromProvider<K, V>(key, p));
    }

    public void putAll(Map<? extends K, ? extends V> entries) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new MapCollectors.EntriesFromMap<K, V>(entries));
    }

    public void putAll(Provider<? extends Map<? extends K, ? extends V>> provider) {
        if (!this.beforeMutate()) {
            return;
        }
        ProviderInternal<Map<K, V>> p = this.checkMapProvider(provider);
        this.addCollector(new MapCollectors.EntriesFromMapProvider<K, V>(p));
    }

    private void addCollector(MapCollector<K, V> collector) {
        this.value = new PlusCollector<K, V>(this.value, collector);
    }

    private ProviderInternal<? extends Map<? extends K, ? extends V>> checkMapProvider(@Nullable Provider<? extends Map<? extends K, ? extends V>> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        ProviderInternal<Map<K, V>> p = Providers.internal(provider);
        if (p.getType() != null && !Map.class.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using a provider of type %s.", Map.class.getName(), p.getType().getName()));
        }
        if (p instanceof MapProviderInternal) {
            Class providerKeyType = ((MapProviderInternal)p).getKeyType();
            Class providerValueType = ((MapProviderInternal)p).getValueType();
            if (!this.keyType.isAssignableFrom(providerKeyType) || !this.valueType.isAssignableFrom(providerValueType)) {
                throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s with key type %s and value type %s using a provider with key type %s and value type %s.", Map.class.getName(), this.keyType.getName(), this.valueType.getName(), providerKeyType.getName(), providerValueType.getName()));
            }
        }
        return p;
    }

    public MapProperty<K, V> convention(Map<? extends K, ? extends V> value) {
        this.convention(new MapCollectors.EntriesFromMap<K, V>(value));
        return this;
    }

    public MapProperty<K, V> convention(Provider<? extends Map<? extends K, ? extends V>> valueProvider) {
        this.convention(new MapCollectors.EntriesFromMapProvider(Providers.internal(valueProvider)));
        return this;
    }

    private void convention(MapCollector<K, V> collector) {
        if (this.shouldApplyConvention()) {
            this.value = collector;
        }
        this.convention = collector;
    }

    public List<? extends ProviderInternal<? extends Map<? extends K, ? extends V>>> getProviders() {
        ArrayList providers = new ArrayList();
        this.value.visit(providers);
        return providers;
    }

    public void providers(List<? extends ProviderInternal<? extends Map<? extends K, ? extends V>>> providers) {
        if (!this.beforeMutate()) {
            return;
        }
        this.value = this.defaultValue;
        for (ProviderInternal<Map<K, V>> providerInternal : providers) {
            this.value = new PlusCollector<K, V>(this.value, new MapCollectors.EntriesFromMapProvider<K, V>(providerInternal));
        }
    }

    public Provider<Set<K>> keySet() {
        return new KeySetProvider();
    }

    @Override
    protected String describeContents() {
        return String.format("Map(%s->%s, %s)", this.keyType.getSimpleName().toLowerCase(), this.valueType.getSimpleName(), this.value.toString());
    }

    @Override
    protected void applyDefaultValue() {
        this.value = this.defaultValue;
    }

    @Override
    protected void makeFinal() {
        Map<K, V> entries = this.doGetOrNull();
        if (entries != null) {
            if (entries.isEmpty()) {
                this.set(EMPTY_MAP);
            } else {
                this.set(new MapCollectors.EntriesFromMap<K, V>(entries));
            }
        } else {
            this.set(NO_VALUE);
        }
    }

    private static class PlusCollector<K, V>
    implements MapCollector<K, V> {
        private final MapCollector<K, V> left;
        private final MapCollector<K, V> right;

        public PlusCollector(MapCollector<K, V> left, MapCollector<K, V> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean present() {
            return this.left.present() && this.right.present();
        }

        @Override
        public void collectInto(DisplayName owner, MapEntryCollector<K, V> collector, Map<K, V> dest) {
            this.left.collectInto(owner, collector, dest);
            this.right.collectInto(owner, collector, dest);
        }

        @Override
        public boolean maybeCollectInto(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            if (this.left.maybeCollectInto(collector, dest)) {
                return this.right.maybeCollectInto(collector, dest);
            }
            return false;
        }

        @Override
        public void collectKeysInto(ValueCollector<K> collector, Collection<K> dest) {
            this.left.collectKeysInto(collector, dest);
            this.right.collectKeysInto(collector, dest);
        }

        @Override
        public boolean maybeCollectKeysInto(ValueCollector<K> collector, Collection<K> dest) {
            if (this.left.maybeCollectKeysInto(collector, dest)) {
                return this.right.maybeCollectKeysInto(collector, dest);
            }
            return false;
        }

        @Override
        public void visit(List<ProviderInternal<? extends Map<? extends K, ? extends V>>> sources) {
            this.left.visit(sources);
            this.right.visit(sources);
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            if (this.left.maybeVisitBuildDependencies(context)) {
                return this.right.maybeVisitBuildDependencies(context);
            }
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            this.left.visitProducerTasks(visitor);
            this.right.visitProducerTasks(visitor);
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.left.isValueProducedByTask() || this.right.isValueProducedByTask();
        }
    }

    private class KeySetProvider
    extends AbstractReadOnlyProvider<Set<K>> {
        private KeySetProvider() {
        }

        @Override
        @Nullable
        public Class<Set<K>> getType() {
            return Set.class;
        }

        @Override
        public Set<K> get() {
            DefaultMapProperty.this.beforeRead();
            LinkedHashSet keys = new LinkedHashSet();
            DefaultMapProperty.this.value.collectKeysInto(DefaultMapProperty.this.keyCollector, keys);
            return ImmutableSet.copyOf(keys);
        }

        @Override
        @Nullable
        public Set<K> getOrNull() {
            DefaultMapProperty.this.beforeRead();
            LinkedHashSet keys = new LinkedHashSet();
            if (!DefaultMapProperty.this.value.maybeCollectKeysInto(DefaultMapProperty.this.keyCollector, keys)) {
                return null;
            }
            return ImmutableSet.copyOf(keys);
        }
    }
}

