/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.keyFMap;

import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.ArrayBackedFMap;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.KeyFMap;

final class MapBackedFMap
extends TIntObjectHashMap<Object>
implements KeyFMap {
    private MapBackedFMap(@NotNull MapBackedFMap oldMap, final int exclude) {
        if (oldMap == null) {
            MapBackedFMap.$$$reportNull$$$0(0);
        }
        super(oldMap.size());
        oldMap.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Object>(){

            public boolean execute(int key, Object val) {
                if (key != exclude) {
                    MapBackedFMap.this.put(key, val);
                }
                assert (key >= 0) : key;
                return true;
            }
        });
        assert (this.size() > 8);
    }

    MapBackedFMap(@NotNull int[] keys, int newKey, @NotNull Object[] values, @NotNull Object newValue2) {
        if (keys == null) {
            MapBackedFMap.$$$reportNull$$$0(1);
        }
        if (values == null) {
            MapBackedFMap.$$$reportNull$$$0(2);
        }
        if (newValue2 == null) {
            MapBackedFMap.$$$reportNull$$$0(3);
        }
        super(keys.length + 1);
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            Object value = values[i];
            this.put(key, value);
            assert (key >= 0) : key;
        }
        this.put(newKey, newValue2);
        assert (newKey >= 0) : newKey;
        assert (this.size() > 8);
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(4);
        }
        if (value == null) {
            MapBackedFMap.$$$reportNull$$$0(5);
        }
        int keyCode = key.hashCode();
        assert (keyCode >= 0) : key;
        Object oldValue = this.get(keyCode);
        if (value == oldValue) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                MapBackedFMap.$$$reportNull$$$0(6);
            }
            return mapBackedFMap;
        }
        MapBackedFMap newMap = new MapBackedFMap(this, -1);
        newMap.put(keyCode, value);
        MapBackedFMap mapBackedFMap = newMap;
        if (mapBackedFMap == null) {
            MapBackedFMap.$$$reportNull$$$0(7);
        }
        return mapBackedFMap;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(8);
        }
        int oldSize = this.size();
        int keyCode = key.hashCode();
        if (!this.containsKey(keyCode)) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                MapBackedFMap.$$$reportNull$$$0(9);
            }
            return mapBackedFMap;
        }
        if (oldSize == 9) {
            int[] keys = this.keys();
            keys = ArrayUtil.remove(keys, ArrayUtil.indexOf(keys, keyCode));
            Arrays.sort(keys);
            Object[] values = new Object[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                values[i] = this.get(keys[i]);
            }
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(keys, values);
            if (arrayBackedFMap == null) {
                MapBackedFMap.$$$reportNull$$$0(10);
            }
            return arrayBackedFMap;
        }
        MapBackedFMap mapBackedFMap = new MapBackedFMap(this, keyCode);
        if (mapBackedFMap == null) {
            MapBackedFMap.$$$reportNull$$$0(11);
        }
        return mapBackedFMap;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(12);
        }
        return (V)this.get(key.hashCode());
    }

    @Override
    @NotNull
    public Key[] getKeys() {
        Key[] keyArray = ArrayBackedFMap.getKeysByIndices(this.keys());
        if (keyArray == null) {
            MapBackedFMap.$$$reportNull$$$0(13);
        }
        return keyArray;
    }

    public String toString() {
        final StringBuilder s = new StringBuilder();
        this.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Object>(){

            public boolean execute(int key, Object value) {
                s.append(s.length() == 0 ? "" : ", ").append(Key.getKeyByIndex(key)).append(" -> ").append(value);
                return true;
            }
        });
        return "[" + s.toString() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/keyFMap/MapBackedFMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/keyFMap/MapBackedFMap";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "plus";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

