/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.annotations.impl;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.reflect.ParameterValidationContext;
import org.gradle.internal.reflect.annotations.PropertyAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadata;

public class DefaultTypeAnnotationMetadata
implements TypeAnnotationMetadata {
    private final ImmutableBiMap<Class<? extends Annotation>, Annotation> annotations;
    private final ImmutableSortedSet<PropertyAnnotationMetadata> properties;
    private final ImmutableList<String> problems;

    public DefaultTypeAnnotationMetadata(Iterable<? extends Annotation> annotations, Iterable<? extends PropertyAnnotationMetadata> properties, Iterable<String> problems) {
        this.annotations = ImmutableBiMap.copyOf((Map)Maps.uniqueIndex(annotations, annotation -> annotation.annotationType()));
        this.properties = ImmutableSortedSet.copyOf(properties);
        this.problems = ImmutableList.copyOf(problems);
    }

    @Override
    public ImmutableSet<Annotation> getAnnotations() {
        return this.annotations.values();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotations.containsKey(annotationType);
    }

    @Override
    public ImmutableSortedSet<PropertyAnnotationMetadata> getPropertiesAnnotationMetadata() {
        return this.properties;
    }

    @Override
    public void visitValidationFailures(@Nullable String ownerPath, ParameterValidationContext validationContext) {
        this.problems.forEach(problem -> validationContext.visitError((String)problem));
        this.properties.forEach(property -> property.visitValidationFailures(ownerPath, validationContext));
    }
}

