/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.base.Strings;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ModuleVersionSelectorStrictSpec;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;

public abstract class AbstractExternalModuleDependency
extends AbstractModuleDependency
implements ExternalModuleDependency {
    private final ModuleIdentifier moduleIdentifier;
    private boolean changing;
    private boolean force;
    private final DefaultMutableVersionConstraint versionConstraint;

    public AbstractExternalModuleDependency(ModuleIdentifier module, String version, String configuration) {
        super(configuration);
        if (module == null) {
            throw new InvalidUserDataException("Module must not be null!");
        }
        this.moduleIdentifier = module;
        this.versionConstraint = new DefaultMutableVersionConstraint(version);
    }

    protected void copyTo(AbstractExternalModuleDependency target) {
        super.copyTo((AbstractModuleDependency)target);
        target.setForce(this.isForce());
        target.setChanging(this.isChanging());
    }

    protected boolean isContentEqualsFor(ExternalModuleDependency dependencyRhs) {
        if (!this.isKeyEquals((ModuleDependency)dependencyRhs) || !this.isCommonContentEquals((ModuleDependency)dependencyRhs)) {
            return false;
        }
        return this.force == dependencyRhs.isForce() && this.changing == dependencyRhs.isChanging();
    }

    public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
        return new ModuleVersionSelectorStrictSpec((ModuleVersionSelector)this).isSatisfiedBy(identifier);
    }

    public String getGroup() {
        return this.moduleIdentifier.getGroup();
    }

    public String getName() {
        return this.moduleIdentifier.getName();
    }

    public String getVersion() {
        return Strings.emptyToNull((String)this.versionConstraint.getVersion());
    }

    public boolean isForce() {
        return this.force;
    }

    public ExternalModuleDependency setForce(boolean force) {
        this.validateMutation(this.force, force);
        this.force = force;
        return this;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public ExternalModuleDependency setChanging(boolean changing) {
        this.validateMutation(this.changing, changing);
        this.changing = changing;
        return this;
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public void version(Action<? super MutableVersionConstraint> configureAction) {
        this.validateMutation();
        configureAction.execute((Object)this.versionConstraint);
    }

    public ModuleIdentifier getModule() {
        return this.moduleIdentifier;
    }

    static ModuleIdentifier assertModuleId(String group, String name) {
        if (name == null) {
            throw new InvalidUserDataException("Name must not be null!");
        }
        return DefaultModuleIdentifier.newId(group, name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractExternalModuleDependency that = (AbstractExternalModuleDependency)((Object)o);
        return this.isContentEqualsFor(that);
    }

    public int hashCode() {
        int result = this.getGroup() != null ? this.getGroup().hashCode() : 0;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + (this.getVersion() != null ? this.getVersion().hashCode() : 0);
        return result;
    }
}

