/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classloader.DeprecatedClassloader;
import org.gradle.util.DeprecationLogger;

public class DefaultDeprecatedClassLoader
extends ClassLoader
implements DeprecatedClassloader {
    private static final String BUILDSRC_IN_SETTINGS_DEPRECATION_WARNING = "Access to the buildSrc project and its dependencies in settings scripts";
    private final ClassLoader deprecatedUsageLoader;
    private final ClassLoader nonDeprecatedParent;
    boolean deprecationFired;

    public DefaultDeprecatedClassLoader(ClassLoader deprecatedUsageLoader, ClassLoader nonDeprecatedParent) {
        super(null);
        this.deprecatedUsageLoader = deprecatedUsageLoader;
        this.nonDeprecatedParent = nonDeprecatedParent;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    public URL getResource(String name) {
        URL resource;
        if (!this.deprecationFired && (resource = this.nonDeprecatedParent.getResource(name)) != null) {
            return resource;
        }
        resource = this.deprecatedUsageLoader.getResource(name);
        if (resource != null) {
            this.maybeEmitDeprecationWarning();
        }
        return resource;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources;
        if (!this.deprecationFired && (resources = this.nonDeprecatedParent.getResources(name)).hasMoreElements()) {
            return resources;
        }
        resources = this.deprecatedUsageLoader.getResources(name);
        if (resources.hasMoreElements()) {
            this.maybeEmitDeprecationWarning();
        }
        return resources;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.deprecationFired) {
            try {
                return this.nonDeprecatedParent.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            Class<?> deprecatedUsageClass = this.deprecatedUsageLoader.loadClass(name);
            this.maybeEmitDeprecationWarning();
            return deprecatedUsageClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotFoundException(String.format("%s not found.", name));
        }
    }

    private void maybeEmitDeprecationWarning() {
        if (!this.deprecationFired) {
            DeprecationLogger.nagUserOfDeprecated((String)BUILDSRC_IN_SETTINGS_DEPRECATION_WARNING);
            this.deprecationFired = true;
        }
    }

    public void visit(ClassLoaderVisitor visitor) {
        visitor.visit(this.deprecatedUsageLoader);
        visitor.visit(this.nonDeprecatedParent);
    }

    public void close() throws IOException {
        ClassLoaderUtils.tryClose((ClassLoader)this.deprecatedUsageLoader);
        ClassLoaderUtils.tryClose((ClassLoader)this.nonDeprecatedParent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDeprecatedClassLoader that = (DefaultDeprecatedClassLoader)o;
        if (this.deprecationFired != that.deprecationFired) {
            return false;
        }
        if (!this.deprecatedUsageLoader.equals(that.deprecatedUsageLoader)) {
            return false;
        }
        return this.nonDeprecatedParent.equals(that.nonDeprecatedParent);
    }

    public int hashCode() {
        int result = this.deprecatedUsageLoader.hashCode();
        result = 31 * result + this.nonDeprecatedParent.hashCode();
        return result;
    }
}

