/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.concurrent.DefaultParallelismConfiguration;
import org.gradle.internal.concurrent.ParallelismConfigurationManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;

public class ParallelismConfigurationBuildActionExecuter
implements BuildActionExecuter<BuildActionParameters> {
    private final BuildActionExecuter<BuildActionParameters> delegate;
    private final ParallelismConfigurationManager parallelismConfigurationManager;

    public ParallelismConfigurationBuildActionExecuter(BuildActionExecuter<BuildActionParameters> delegate, ParallelismConfigurationManager parallelismConfigurationManager) {
        this.delegate = delegate;
        this.parallelismConfigurationManager = parallelismConfigurationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionResult execute(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry contextServices) {
        StartParameterInternal startParameter = action.getStartParameter();
        this.parallelismConfigurationManager.setParallelismConfiguration(new DefaultParallelismConfiguration(startParameter.isParallelProjectExecutionEnabled(), startParameter.getMaxWorkerCount()));
        try {
            BuildActionResult buildActionResult = this.delegate.execute(action, requestContext, actionParameters, contextServices);
            return buildActionResult;
        }
        finally {
            this.parallelismConfigurationManager.setParallelismConfiguration(DefaultParallelismConfiguration.DEFAULT);
        }
    }
}

