/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.NavigableSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.execution.plan.Node;

public abstract class TaskNode
extends Node {
    private final NavigableSet<Node> mustSuccessors = Sets.newTreeSet();
    private final Set<Node> mustPredecessors = Sets.newHashSet();
    private final NavigableSet<Node> shouldSuccessors = Sets.newTreeSet();
    private final NavigableSet<Node> finalizers = Sets.newTreeSet();
    private final NavigableSet<Node> finalizingSuccessors = Sets.newTreeSet();

    @Override
    public boolean doCheckDependenciesComplete() {
        if (!super.doCheckDependenciesComplete()) {
            return false;
        }
        for (Node dependency : this.mustSuccessors) {
            if (dependency.isComplete()) continue;
            return false;
        }
        for (Node dependency : this.finalizingSuccessors) {
            if (dependency.isComplete()) continue;
            return false;
        }
        return true;
    }

    public Set<Node> getMustSuccessors() {
        return this.mustSuccessors;
    }

    @Override
    public Set<Node> getFinalizers() {
        return this.finalizers;
    }

    public Set<Node> getFinalizingSuccessors() {
        return this.finalizingSuccessors;
    }

    public Set<Node> getShouldSuccessors() {
        return this.shouldSuccessors;
    }

    protected void addMustSuccessor(TaskNode toNode) {
        this.mustSuccessors.add(toNode);
        toNode.mustPredecessors.add(this);
    }

    protected void addFinalizingSuccessor(TaskNode finalized) {
        this.finalizingSuccessors.add(finalized);
    }

    protected void addFinalizer(TaskNode finalizerNode) {
        this.finalizers.add(finalizerNode);
        finalizerNode.addFinalizingSuccessor(this);
    }

    protected void addShouldSuccessor(Node toNode) {
        this.shouldSuccessors.add(toNode);
    }

    public void removeShouldSuccessor(TaskNode toNode) {
        this.shouldSuccessors.remove(toNode);
    }

    @Override
    public Iterable<Node> getAllSuccessors() {
        return Iterables.concat(this.getMustSuccessors(), this.getFinalizingSuccessors(), super.getAllSuccessors());
    }

    @Override
    public Iterable<Node> getAllSuccessorsInReverseOrder() {
        return Iterables.concat(super.getAllSuccessorsInReverseOrder(), this.mustSuccessors.descendingSet(), this.finalizingSuccessors.descendingSet(), this.shouldSuccessors.descendingSet());
    }

    @Override
    public Iterable<Node> getAllPredecessors() {
        return Iterables.concat(this.mustPredecessors, this.finalizers, super.getAllPredecessors());
    }

    @Override
    public boolean hasHardSuccessor(Node successor) {
        if (super.hasHardSuccessor(successor)) {
            return true;
        }
        if (!(successor instanceof TaskNode)) {
            return false;
        }
        return this.getMustSuccessors().contains(successor) || this.getFinalizingSuccessors().contains(successor);
    }

    public abstract void appendPostAction(Action<? super Task> var1);

    public abstract Action<? super Task> getPostAction();

    public abstract TaskInternal getTask();

    @Override
    public boolean isPublicNode() {
        return true;
    }
}

