/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.annotations;

import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.properties.BeanPropertyContext;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.reflect.ParameterValidationContext;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.work.Incremental;

public class InputPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return Input.class;
    }

    @Override
    public boolean isPropertyRelevant() {
        return true;
    }

    @Override
    public boolean shouldVisit(PropertyVisitor visitor) {
        return !visitor.visitOutputFilePropertiesOnly();
    }

    @Override
    public void visitPropertyValue(String propertyName, PropertyValue value, PropertyMetadata propertyMetadata, PropertyVisitor visitor, BeanPropertyContext context) {
        visitor.visitInputProperty(propertyName, value, propertyMetadata.isAnnotationPresent(Optional.class));
    }

    @Override
    public void validatePropertyMetadata(PropertyMetadata propertyMetadata, ParameterValidationContext visitor) {
        Class valueType = propertyMetadata.getDeclaredType();
        if (File.class.isAssignableFrom(valueType) || Path.class.isAssignableFrom(valueType) || FileCollection.class.isAssignableFrom(valueType)) {
            visitor.visitError(null, propertyMetadata.getPropertyName(), String.format("has @Input annotation used on property of type %s", valueType.getName()));
        }
        if (propertyMetadata.isAnnotationPresent(Incremental.class)) {
            visitor.visitErrorStrict(null, propertyMetadata.getPropertyName(), "has @Incremental annotation used on an @Input property");
        }
    }
}

