/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \b2\u00020\u0001:\u0004\b\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0006H\u00a6\u0002\u00a2\u0006\u0002\u0010\u0007\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "", "()V", "get", "T", "key", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;", "(Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;)Ljava/lang/Object;", "Companion", "Empty", "Impl", "Key", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Impl;", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Empty;", "frontend"})
public abstract class RenderingContext {
    public static final Companion Companion = new Companion(null);

    public abstract <T> T get(@NotNull Key<? extends T> var1);

    private RenderingContext() {
    }

    public /* synthetic */ RenderingContext(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final RenderingContext of(Object ... objectsToRender) {
        return Companion.of(objectsToRender);
    }

    @JvmStatic
    @NotNull
    public static final RenderingContext fromDiagnostic(@NotNull Diagnostic d) {
        return Companion.fromDiagnostic(d);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\b\u001a\u00028\u00002\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\nH&\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;", "T", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "compute", "objectsToRender", "", "(Ljava/util/Collection;)Ljava/lang/Object;", "frontend"})
    public static abstract class Key<T> {
        @NotNull
        private final String name;

        public abstract T compute(@NotNull Collection<? extends Object> var1);

        @NotNull
        public final String getName() {
            return this.name;
        }

        public Key(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.name = name;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\"\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\bH\u0096\u0002\u00a2\u0006\u0002\u0010\rR6\u0010\u0006\u001a*\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0007j\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0012\u0004\u0018\u00010\u0004`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Impl;", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "objectsToRender", "", "", "(Ljava/util/Collection;)V", "data", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;", "Lkotlin/collections/LinkedHashMap;", "get", "T", "key", "(Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;)Ljava/lang/Object;", "frontend"})
    public static final class Impl
    extends RenderingContext {
        private final LinkedHashMap<Key<?>, Object> data;
        private final Collection<Object> objectsToRender;

        @Override
        public <T> T get(@NotNull Key<? extends T> key) {
            Object object;
            Intrinsics.checkParameterIsNotNull(key, (String)"key");
            Object object2 = this.data.get(key);
            if (!(object2 instanceof Object)) {
                object2 = object = null;
            }
            if (object2 == null) {
                T t;
                T it = t = key.compute(this.objectsToRender);
                Map map2 = this.data;
                Key<T> key2 = key;
                T t2 = it;
                map2.put(key2, t2);
                object = t;
            }
            return (T)object;
        }

        public Impl(@NotNull Collection<? extends Object> objectsToRender) {
            Intrinsics.checkParameterIsNotNull(objectsToRender, (String)"objectsToRender");
            super(null);
            this.objectsToRender = objectsToRender;
            Impl impl = this;
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            impl.data = linkedHashMap;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Empty;", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "()V", "get", "T", "key", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;", "(Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;)Ljava/lang/Object;", "frontend"})
    public static final class Empty
    extends RenderingContext {
        public static final Empty INSTANCE;

        @Override
        public <T> T get(@NotNull Key<? extends T> key) {
            Intrinsics.checkParameterIsNotNull(key, (String)"key");
            return key.compute(CollectionsKt.emptyList());
        }

        private Empty() {
            super(null);
        }

        static {
            Empty empty;
            INSTANCE = empty = new Empty();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J%\u0010\u0007\u001a\u00020\u00042\u0016\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\t\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Companion;", "", "()V", "fromDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "d", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "of", "objectsToRender", "", "([Ljava/lang/Object;)Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "frontend"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final RenderingContext of(Object ... objectsToRender) {
            Intrinsics.checkParameterIsNotNull((Object)objectsToRender, (String)"objectsToRender");
            return new Impl(ArraysKt.toList((Object[])objectsToRender));
        }

        @JvmStatic
        @NotNull
        public final RenderingContext fromDiagnostic(@NotNull Diagnostic d) {
            List list2;
            Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
            Diagnostic diagnostic = d;
            if (diagnostic instanceof SimpleDiagnostic) {
                list2 = CollectionsKt.emptyList();
            } else if (diagnostic instanceof DiagnosticWithParameters1) {
                list2 = CollectionsKt.listOf(((DiagnosticWithParameters1)d).getA());
            } else if (diagnostic instanceof DiagnosticWithParameters2) {
                Object[] objectArray = new Object[2];
                Object a = ((DiagnosticWithParameters2)d).getA();
                Intrinsics.checkExpressionValueIsNotNull(a, (String)"d.a");
                objectArray[0] = a;
                Object b = ((DiagnosticWithParameters2)d).getB();
                Intrinsics.checkExpressionValueIsNotNull(b, (String)"d.b");
                objectArray[1] = b;
                list2 = CollectionsKt.listOf((Object[])objectArray);
            } else if (diagnostic instanceof DiagnosticWithParameters3) {
                Object[] objectArray = new Object[3];
                Object a = ((DiagnosticWithParameters3)d).getA();
                Intrinsics.checkExpressionValueIsNotNull(a, (String)"d.a");
                objectArray[0] = a;
                Object b = ((DiagnosticWithParameters3)d).getB();
                Intrinsics.checkExpressionValueIsNotNull(b, (String)"d.b");
                objectArray[1] = b;
                Object c = ((DiagnosticWithParameters3)d).getC();
                Intrinsics.checkExpressionValueIsNotNull(c, (String)"d.c");
                objectArray[2] = c;
                list2 = CollectionsKt.listOf((Object[])objectArray);
            } else {
                if (diagnostic instanceof ParametrizedDiagnostic) {
                    String string = "Unexpected diagnostic: " + d.getClass();
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                list2 = CollectionsKt.emptyList();
            }
            List parameters2 = list2;
            return new Impl(parameters2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

