/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.bean;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Queue;
import org.codehaus.groovy.runtime.ConvertedClosure;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.bean.AbstractNestedRuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNodeFactory;
import org.gradle.internal.reflect.ParameterValidationContext;
import org.gradle.util.ClosureBackedAction;
import org.gradle.util.ConfigureUtil;

class NestedRuntimeBeanNode
extends AbstractNestedRuntimeBeanNode {
    public NestedRuntimeBeanNode(RuntimeBeanNode<?> parentNode, String propertyName, Object bean, TypeMetadata typeMetadata) {
        super(parentNode, propertyName, bean, typeMetadata);
    }

    @Override
    public void visitNode(PropertyVisitor visitor, Queue<RuntimeBeanNode<?>> queue, RuntimeBeanNodeFactory nodeFactory, ParameterValidationContext validationContext) {
        this.visitImplementation(visitor);
        this.visitProperties(visitor, queue, nodeFactory, validationContext);
    }

    private void visitImplementation(PropertyVisitor visitor) {
        visitor.visitInputProperty(this.getPropertyName(), new ImplementationPropertyValue(NestedRuntimeBeanNode.getImplementationClass(this.getBean())), false);
    }

    @VisibleForTesting
    static Class<?> getImplementationClass(Object bean) {
        if (Proxy.isProxyClass(bean.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(bean);
            if (invocationHandler instanceof ConvertedClosure) {
                Object delegate = ((ConvertedClosure)invocationHandler).getDelegate();
                return delegate.getClass();
            }
            return invocationHandler.getClass();
        }
        if (bean instanceof ConfigureUtil.WrappedConfigureAction) {
            return ((ConfigureUtil.WrappedConfigureAction)bean).getConfigureClosure().getClass();
        }
        if (bean instanceof ClosureBackedAction) {
            return ((ClosureBackedAction)bean).getClosure().getClass();
        }
        return bean.getClass();
    }

    private static class ImplementationPropertyValue
    implements PropertyValue {
        private final Class<?> beanClass;

        public ImplementationPropertyValue(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        @Override
        public Object call() {
            return this.beanClass;
        }

        @Override
        public void attachProducer(Task producer) {
        }

        @Override
        public void maybeFinalizeValue() {
        }
    }
}

