/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.Collections;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;

public class DefaultProjectDependencyConstraint
implements DependencyConstraint {
    private final ProjectDependency projectDependency;
    private String reason;

    public DefaultProjectDependencyConstraint(ProjectDependency projectDependency) {
        this.projectDependency = projectDependency;
    }

    public void version(Action<? super MutableVersionConstraint> configureAction) {
        throw new UnsupportedOperationException("Cannot change version constraint on a project dependency");
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public void because(@Nullable String reason) {
        this.reason = reason;
    }

    public AttributeContainer getAttributes() {
        return this.projectDependency.getAttributes();
    }

    public DependencyConstraint attributes(Action<? super AttributeContainer> configureAction) {
        this.projectDependency.attributes(configureAction);
        return this;
    }

    public VersionConstraint getVersionConstraint() {
        return new DefaultImmutableVersionConstraint("", this.projectDependency.getVersion(), "", Collections.emptyList(), "");
    }

    public String getGroup() {
        return this.projectDependency.getGroup();
    }

    public String getName() {
        return this.projectDependency.getName();
    }

    @Nullable
    public String getVersion() {
        return this.projectDependency.getVersion();
    }

    public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
        return identifier.getModule().equals(this.getModule()) && identifier.getVersion().equals(this.projectDependency.getVersion());
    }

    public ModuleIdentifier getModule() {
        String group = this.projectDependency.getGroup();
        return DefaultModuleIdentifier.newId(group != null ? group : "", this.projectDependency.getName());
    }
}

