/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.file.FilePermissionException;
import net.rubygrapefruit.platform.file.Files;
import net.rubygrapefruit.platform.file.NoSuchFileException;
import net.rubygrapefruit.platform.file.NotADirectoryException;
import net.rubygrapefruit.platform.internal.FunctionResult;

public abstract class AbstractFiles
implements Files {
    protected NativeException listDirFailure(File dir, FunctionResult result2) {
        if (result2.getFailure() == FunctionResult.Failure.NoSuchFile) {
            throw new NoSuchFileException(String.format("Could not list directory %s as this directory does not exist.", dir));
        }
        if (result2.getFailure() == FunctionResult.Failure.NotADirectory) {
            throw new NotADirectoryException(String.format("Could not list directory %s as it is not a directory.", dir));
        }
        if (result2.getFailure() == FunctionResult.Failure.Permissions) {
            throw new FilePermissionException(String.format("Could not list directory %s: permission denied", dir));
        }
        throw new NativeException(String.format("Could not list directory %s: %s", dir, result2.getMessage()));
    }
}

