/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.ProjectState;
import org.gradle.api.Task;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformer;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.time.Clock;
import org.gradle.profile.BuildProfile;
import org.gradle.profile.ContinuousOperation;
import org.gradle.profile.FragmentedOperation;
import org.gradle.profile.ProfileListener;
import org.gradle.profile.ProjectProfile;
import org.gradle.profile.TaskExecution;

public class ProfileEventAdapter
implements BuildListener,
ProjectEvaluationListener,
TaskExecutionListener,
DependencyResolutionListener,
BuildCompletionListener,
ArtifactTransformListener {
    private final BuildStartedTime buildStartedTime;
    private final Clock clock;
    private final ProfileListener listener;
    private final ThreadLocal<ContinuousOperation> currentTransform = new ThreadLocal();
    private BuildProfile buildProfile;

    public ProfileEventAdapter(BuildStartedTime buildStartedTime, Clock clock, ProfileListener listener) {
        this.buildStartedTime = buildStartedTime;
        this.clock = clock;
        this.listener = listener;
    }

    public void buildStarted(Gradle gradle) {
        long now = this.clock.getCurrentTime();
        this.buildProfile = new BuildProfile(gradle.getStartParameter());
        this.buildProfile.setBuildStarted(now);
        this.buildProfile.setProfilingStarted(this.buildStartedTime.getStartTime());
    }

    public void settingsEvaluated(Settings settings) {
        this.buildProfile.setSettingsEvaluated(this.clock.getCurrentTime());
    }

    public void projectsLoaded(Gradle gradle) {
        this.buildProfile.setProjectsLoaded(this.clock.getCurrentTime());
    }

    public void projectsEvaluated(Gradle gradle) {
        this.buildProfile.setProjectsEvaluated(this.clock.getCurrentTime());
    }

    public void buildFinished(BuildResult result) {
        this.buildProfile.setSuccessful(result.getFailure() == null);
    }

    @Override
    public void completed() {
        if (this.buildProfile != null) {
            this.buildProfile.setBuildFinished(this.clock.getCurrentTime());
            try {
                this.listener.buildFinished(this.buildProfile);
            }
            finally {
                this.buildProfile = null;
            }
        }
    }

    public void beforeEvaluate(Project project) {
        long now = this.clock.getCurrentTime();
        this.buildProfile.getProjectProfile(project.getPath()).getConfigurationOperation().setStart(now);
    }

    public void afterEvaluate(Project project, ProjectState state) {
        long now = this.clock.getCurrentTime();
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project.getPath());
        projectProfile.getConfigurationOperation().setFinish(now);
    }

    public void beforeExecute(Task task) {
        long now = this.clock.getCurrentTime();
        Project project = task.getProject();
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project.getPath());
        projectProfile.getTaskProfile(task.getPath()).setStart(now);
    }

    public void afterExecute(Task task, TaskState state) {
        long now = this.clock.getCurrentTime();
        Project project = task.getProject();
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project.getPath());
        TaskExecution taskExecution = projectProfile.getTaskProfile(task.getPath());
        taskExecution.setFinish(now);
        taskExecution.completed(state);
    }

    public void beforeResolve(ResolvableDependencies dependencies) {
        long now = this.clock.getCurrentTime();
        this.buildProfile.getDependencySetProfile(dependencies.getPath()).setStart(now);
    }

    public void afterResolve(ResolvableDependencies dependencies) {
        long now = this.clock.getCurrentTime();
        this.buildProfile.getDependencySetProfile(dependencies.getPath()).setFinish(now);
    }

    public void beforeTransform(ArtifactTransformer transform, @Nullable ComponentArtifactIdentifier artifactId, File file) {
        long now = this.clock.getCurrentTime();
        StringBuilder transformDescription = new StringBuilder(256);
        if (artifactId != null) {
            transformDescription.append(artifactId.getDisplayName());
        } else {
            transformDescription.append(file.getAbsolutePath());
        }
        transformDescription.append(" with ");
        transformDescription.append(transform.getDisplayName());
        FragmentedOperation transformProfile = this.buildProfile.getTransformProfile(transformDescription.toString());
        this.currentTransform.set(transformProfile.start(now));
    }

    public void afterTransform(ArtifactTransformer transform, @Nullable ComponentArtifactIdentifier artifactId, File file, @Nullable Throwable failure) {
        long now = this.clock.getCurrentTime();
        this.currentTransform.get().setFinish(now);
        this.currentTransform.remove();
    }
}

